/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.Function;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Shape;
import ProGAL.geom3d.Vector;
import ProGAL.math.Constants;
import ProGAL.math.Functions;
import ProGAL.math.RootFinding;

public class Circle
implements Shape {
    private Point center;
    private double radius;
    private Vector normal;

    public Circle(Point center, double radius, Vector normal) {
        this.center = center;
        this.radius = radius;
        if (normal != null) {
            this.normal = normal.normalize();
        }
    }

    public Circle(Point center, Point through, Vector normal) {
        this.center = center;
        this.radius = center.distance(through);
        this.normal = normal.normalize();
    }

    public Circle(Point p0, Point p1, Point p2) {
        this.center = Point.getCircumCenter(p0, p1, p2);
        this.radius = this.center.distance(p0);
        Vector v0 = new Vector(this.center, p0);
        Vector v1 = new Vector(this.center, p1);
        this.normal = v0.cross(v1).normalize();
    }

    @Override
    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public Vector getNormalVector() {
        return this.normal;
    }

    public Vector getNormal() {
        return this.normal;
    }

    public void setCenter(Point p) {
        this.center = p;
    }

    public Point getPoint() {
        return this.center.add(this.normal.getOrthonormal().scaleToLength(this.radius));
    }

    public Plane getPlane() {
        return new Plane(this.center, this.normal);
    }

    public Point getClosestPoint(Point p) {
        Point pr = new Plane(this.center, this.normal).projectPoint(p);
        if (this.center.distanceSquared(pr) <= Constants.EPSILON) {
            return this.getPoint();
        }
        return this.center.add(new Vector(this.center, pr).scaleToLength(this.radius));
    }

    public Point getFarthestPoint(Point p) {
        Point pr = new Plane(this.center, this.normal).projectPoint(p);
        if (this.center.distanceSquared(pr) <= Constants.EPSILON) {
            return this.getPoint();
        }
        return this.center.add(new Vector(this.center, pr).scaleToLength(this.radius).multiply(-1.0));
    }

    public double getClosestDistance(Circle cb) {
        Vector u = cb.normal.getOrthonormal();
        Vector v = cb.normal.cross(u);
        double ra2 = this.radius * this.radius;
        double ca2 = this.center.dot(this.center);
        double cacb = this.center.dot(cb.center);
        double cau = this.center.dot(u);
        double cav = this.center.dot(v);
        double naca = this.normal.dot(this.center);
        double nacb = this.normal.dot(cb.center);
        double nau = this.normal.dot(u);
        double nav = this.normal.dot(v);
        double rb2 = cb.radius * cb.radius;
        double cb2 = cb.center.dot(cb.center);
        double cbu = cb.center.dot(u);
        double cbv = cb.center.dot(v);
        double a0 = rb2 + cb2 + ca2 - 2.0 * cacb - (nacb - naca) * (nacb - naca);
        double a1 = -2.0 * rb2 * nau * nav;
        double a2 = 2.0 * cb.radius * (cbv - cav - (nacb - naca) * nav);
        double a3 = 2.0 * cb.radius * (cbu - cau - (nacb - naca) * nau);
        double a4 = -rb2 * nav * nav;
        double a5 = -rb2 * nau * nau;
        double a6 = -2.0 * this.radius;
        double a7 = ra2 + rb2 + ca2 + cb2 - 2.0 * cacb;
        double a8 = 2.0 * cb.radius * (cbv - cav);
        double a9 = 2.0 * cb.radius * (cbu - cau);
        double[] c = new double[]{a9 * a9 - a6 * a6 * a5 + 2.0 * a7 * a9 - a6 * a6 * a3 + a7 * a7 - a6 * a6 * a0, 2.0 * (2.0 * a7 * a8 - a6 * a6 * a2) + 2.0 * (2.0 * a8 * a9 - a6 * a6 * a1), 2.0 * (a6 * a6 * a5 - a9 * a9) + 4.0 * (a8 * a8 - a6 * a6 * a4) + 2.0 * (a7 * a7 - a6 * a6 * a0), 2.0 * (2.0 * a7 * a8 - a6 * a6 * a2) - 2.0 * (2.0 * a8 * a9 - a6 * a6 * a1), a9 * a9 - a6 * a6 * a5 - 2.0 * a7 * a9 + a6 * a6 * a3 + a7 * a7 - a6 * a6 * a0};
        Function f = new Function(c);
        double root = RootFinding.brent(f, 0.5, 0.8, 1.0E-6, 1.0E-5, 1000);
        return root;
    }

    public static Circle getEquilateralCircle(Point a, Point b) {
        Point center = Point.getMidpoint(a, b);
        Vector ab = a.vectorTo(b);
        double radius = Math.sqrt(3.0) * ab.length() / 2.0;
        return new Circle(center, radius, ab);
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        return String.format("Circle[center=%s,radius=%" + dec + "f,normal=%s]", this.center.toString(dec), this.radius, this.normal.toString(dec));
    }

    public void toConsole() {
        this.toConsole(2);
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    public Point[] getIntersection(Circle c) {
        double sum;
        Point[] intersectionPoints = null;
        double dist = this.center.distance(c.getCenter());
        if (dist - (sum = this.radius + c.getRadius()) > Constants.EPSILON) {
            return intersectionPoints;
        }
        double diff = Math.abs(this.radius - c.getRadius());
        if (dist - diff < -Constants.EPSILON) {
            return intersectionPoints;
        }
        if (Math.abs(dist - sum) < Constants.EPSILON) {
            Vector v = new Vector(this.center, c.getCenter());
            double fraction = this.radius / (this.radius + c.getRadius());
            intersectionPoints = new Point[]{this.center.addThis(v.multiply(fraction))};
            return intersectionPoints;
        }
        if (dist - diff < Constants.EPSILON) {
            intersectionPoints = new Point[1];
            if (this.radius > c.radius) {
                Vector v = new Vector(this.center, c.getCenter());
                v.scaleToLengthThis(this.radius);
                intersectionPoints[0] = this.center.add(v);
            } else {
                Vector v = new Vector(c.getCenter(), this.center);
                v.scaleToLengthThis(c.getRadius());
                intersectionPoints[0] = c.getCenter().add(v);
            }
        } else {
            double alpha = Math.acos((this.radius * this.radius + dist * dist - c.getRadius() * c.getRadius()) / (2.0 * this.radius * dist));
            Vector v = new Vector(this.center, c.getCenter());
            v.scaleToLengthThis(this.radius);
            intersectionPoints = new Point[2];
            this.getNormalVector().rotateIn(v, alpha);
            intersectionPoints[0] = this.center.add(v);
            this.getNormalVector().rotateIn(v, -2.0 * alpha);
            intersectionPoints[1] = this.center.add(v);
        }
        return intersectionPoints;
    }

    public Double getFirstIntersection(Line line, Point p, Vector dir) {
        double dist = line.getDistance(this.center);
        if (dist > this.radius - Constants.EPSILON) {
            return null;
        }
        Vector op = new Vector(this.center, p);
        double r2 = this.radius * this.radius;
        if (dist < 0.001) {
            Vector oco = line.dir.multiply(this.radius);
            double cosBeta = op.dot(oco) / r2;
            Vector cr = op.cross(oco);
            cr.divideThis(r2);
            double sinBeta = cr.length();
            double beta = Math.atan2(sinBeta, cosBeta);
            System.out.println("beta = " + Functions.toDeg(beta));
            if (this.normal.dot(dir) > 0.0) {
                if (this.normal.dot(cr) > 0.0) {
                    return beta;
                }
                return Math.PI * 2 - beta;
            }
            if (this.normal.dot(cr) > 0.0) {
                return Math.PI * 2 - beta;
            }
            return beta;
        }
        Point co = line.orthogonalProjection(this.center);
        double oco2 = dist * dist;
        double pco2 = co.distanceSquared(p);
        double cosAlpha = dist / this.radius;
        double cosBeta = (r2 + oco2 - pco2) / (2.0 * this.radius * dist);
        Vector oco = new Vector(this.center, co);
        Vector cr = op.cross(oco);
        cr.divideThis(op.length() * oco.length());
        double sinBeta = cr.length();
        double alpha = Math.acos(cosAlpha);
        System.out.println("alpha = " + Functions.toDeg(cosAlpha));
        double beta = Math.atan2(sinBeta, cosBeta);
        System.out.println("beta = " + Functions.toDeg(beta));
        if (this.normal.dot(dir) > 0.0) {
            if (this.normal.dot(cr) > 0.0) {
                return beta - alpha;
            }
            return Math.PI * 2 - beta - alpha;
        }
        if (this.normal.dot(cr) > 0.0) {
            return Math.PI * 2 - beta - alpha;
        }
        return beta - alpha;
    }

    public double getDistanceSquared(Point p) {
        double NPC = this.normal.dot(p.subtract(this.center));
        double secondTerm = Math.sqrt(p.distanceSquared(this.center) - NPC * NPC) - this.radius;
        return NPC * NPC + secondTerm * secondTerm;
    }

    public double getDistance(Point p) {
        return Math.sqrt(this.getDistanceSquared(p));
    }

    public Double getFirstIntersection(Circle c, Point p, Vector dir) {
        double dist = this.center.distance(c.getCenter());
        if (dist > this.radius + c.getRadius() - Constants.EPSILON) {
            return null;
        }
        double r2d2 = this.radius * this.radius + dist * dist;
        double rd2 = 2.0 * this.radius * dist;
        double cosAlpha = (r2d2 - c.getRadius() * c.getRadius()) / rd2;
        System.out.println("cosAlpha =" + cosAlpha + " " + Math.acos(cosAlpha));
        double distP2 = p.distanceSquared(c.getCenter());
        double cosBeta = (r2d2 - distP2) / rd2;
        System.out.println("cosBeta =" + cosAlpha + " " + Math.acos(cosBeta));
        Vector op = new Vector(this.center, p);
        Vector oco = new Vector(this.center, c.getCenter());
        Vector cr = op.cross(oco);
        cr.divideThis(op.length() * oco.length());
        double sinBeta = cr.length();
        double alpha = Math.acos(cosAlpha);
        System.out.println("alpha = " + Functions.toDeg(cosAlpha));
        double beta = Math.atan2(sinBeta, cosBeta);
        System.out.println("beta = " + Functions.toDeg(beta));
        if (this.normal.dot(dir) > 0.0) {
            if (this.normal.dot(cr) > 0.0) {
                return beta - alpha;
            }
            return Math.PI * 2 - beta - alpha;
        }
        if (this.normal.dot(cr) > 0.0) {
            return Math.PI * 2 - beta - alpha;
        }
        return beta - alpha;
    }

    public static LineSegment getFurthestDistance_centers(Circle c1, Circle c2) {
        Vector v = c1.center.vectorTo(c2.center);
        Vector y2 = c2.normal.cross(v);
        Vector x2 = c2.normal.cross(y2);
        x2.multiplyThis(c2.radius / x2.length());
        Point p21 = c2.center.add(x2);
        Point p22 = c2.center.subtract(x2);
        Vector y1 = c1.normal.cross(v).normalizeThis();
        Vector x1 = c1.normal.cross(y1);
        x1.multiplyThis(c1.radius / x1.length());
        Point p11 = c1.center.add(x1);
        Point p12 = c1.center.subtract(x1);
        double d11_21 = p11.distanceSquared(p21);
        double d12_21 = p12.distanceSquared(p21);
        double d11_22 = p11.distanceSquared(p22);
        double d12_22 = p12.distanceSquared(p22);
        if (d11_21 > d12_21 && d11_21 > d11_22 && d11_21 > d12_22) {
            return new LineSegment(p11, p21);
        }
        if (d12_21 > d11_22 && d12_21 > d12_22) {
            return new LineSegment(p12, p21);
        }
        if (d11_22 > d12_22) {
            return new LineSegment(p11, p22);
        }
        return new LineSegment(p12, p22);
    }

    public static Point getFurthestPoint_bruteForce(Circle c, Point p) {
        if (c.radius < Constants.EPSILON) {
            return c.center;
        }
        int divisions = 8;
        Vector x = new Vector(1.001, 1.002, 1.003).crossThis(c.normal).normalizeThis();
        Vector y = c.normal.cross(x);
        double maxT = 0.0;
        double maxDist = 0.0;
        for (double range = Math.PI * 2; range > 0.3141592653589793; range /= 8.0) {
            for (double t = maxT - range / 2.0; t < maxT + range / 2.0; t += range / (double)divisions) {
                Point pc = c.center.add(x.multiply(c.radius * Math.cos(t)).addThis(y.multiply(c.radius * Math.sin(t))));
                double dist = p.distanceSquared(pc);
                if (!(dist > maxDist)) continue;
                maxT = t;
                maxDist = dist;
            }
        }
        Point pc = c.center.add(x.multiply(c.radius * Math.cos(maxT)).addThis(y.multiply(c.radius * Math.sin(maxT))));
        return pc;
    }

    public static LineSegment getFurthestDistance_bruteForce(Circle c1, Circle c2) {
        if (c1.radius < Constants.EPSILON) {
            return new LineSegment(c1.center, Circle.getFurthestPoint_bruteForce(c2, c1.center));
        }
        int divisions = 8;
        Vector x1 = new Vector(1.001, 1.002, 1.003).crossThis(c1.normal).normalizeThis();
        Vector y1 = c1.normal.cross(x1);
        Vector x2 = new Vector(1.001, 1.002, 1.003).crossThis(c2.normal).normalizeThis();
        Vector y2 = c2.normal.cross(x2);
        double maxT1 = 0.0;
        double maxT2 = 0.0;
        double maxDist = 0.0;
        for (double range = Math.PI * 2; range > 0.3141592653589793; range /= 8.0) {
            for (double t1 = maxT1 - range / 2.0; t1 < maxT1 + range / 2.0; t1 += range / (double)divisions) {
                Point p1 = c1.center.add(x1.multiply(c1.radius * Math.cos(t1)).addThis(y1.multiply(c1.radius * Math.sin(t1))));
                for (double t2 = maxT2 - range / 2.0; t2 < maxT2 + range / 2.0; t2 += range / (double)divisions) {
                    Point p2 = c2.center.add(x2.multiply(c2.radius * Math.cos(t2)).addThis(y2.multiply(c2.radius * Math.sin(t2))));
                    double dist = p1.distanceSquared(p2);
                    if (!(dist > maxDist)) continue;
                    maxT1 = t1;
                    maxT2 = t2;
                    maxDist = dist;
                }
            }
        }
        Point p1 = c1.center.add(x1.multiply(c1.radius * Math.cos(maxT1)).addThis(y1.multiply(c1.radius * Math.sin(maxT1))));
        Point p2 = c2.center.add(x2.multiply(c2.radius * Math.cos(maxT2)).addThis(y2.multiply(c2.radius * Math.sin(maxT2))));
        return new LineSegment(p1, p2);
    }
}

