/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.Simplex;
import ProGAL.geom3d.Vector;

public class LineSegment
implements Simplex {
    protected Point a;
    protected Point b;

    public LineSegment(Point a, Point b) {
        this.a = a;
        this.b = b;
    }

    public LineSegment(Point a, Vector v) {
        this.a = a;
        this.b = a.add(v);
    }

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public void setA(Point a) {
        this.a = a;
    }

    public void setB(Point b) {
        this.b = b;
    }

    public Vector getAToB() {
        return this.a.vectorTo(this.b);
    }

    public double getLength() {
        return Math.sqrt(this.getLengthSquared());
    }

    public double getLengthSquared() {
        return this.a.distanceSquared(this.b);
    }

    public Point getClosestPoint(Point q) {
        Vector dir = this.a.vectorTo(this.b);
        Vector aq = this.a.vectorTo(q);
        double t = dir.dot(aq) / dir.getLengthSquared();
        t = Math.min(1.0, Math.max(0.0, t));
        return new Point(this.a.x() + t * dir.x(), this.a.y() + t * dir.y(), this.a.z() + t * dir.z());
    }

    public double getSquaredDistance(Point q) {
        return q.distanceSquared(this.getClosestPoint(q));
    }

    public double getDistance(Point q) {
        return q.distance(this.getClosestPoint(q));
    }

    public Point getMidPoint() {
        return Point.getMidpoint(this.a, this.b);
    }

    @Override
    public Point getCenter() {
        return this.getMidPoint();
    }

    @Override
    public Point getPoint(int i) {
        if (i < 0 || i > 1) {
            throw new IllegalArgumentException("Invalid index (" + i + ") 1-simplex has two points only");
        }
        if (i == 0) {
            return this.a;
        }
        return this.b;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof LineSegment) {
            return this.equals((LineSegment)o);
        }
        return false;
    }

    public boolean equals(LineSegment ls) {
        return this.a.equals(ls.a) && this.b.equals(ls.b);
    }

    public LineSegment clone() {
        return new LineSegment(this.a.clone(), this.b.clone());
    }

    public String toString() {
        return "Segment[" + this.a + "," + this.b + "]";
    }

    public String toString(int dec) {
        return "Segment[" + this.a.toString(dec) + "," + this.b.toString(dec) + "]";
    }

    public void toConsole() {
        System.out.println(this.toString());
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }
}

