/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d;

import ProGAL.geom3d.Line;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Shape;
import ProGAL.geom3d.Simplex;
import ProGAL.geom3d.Vector;
import ProGAL.math.Constants;
import ProGAL.math.Matrix;

public class Triangle
implements Simplex {
    protected Point p1;
    protected Point p2;
    protected Point p3;
    protected Shape[] LSSs = new Shape[3];
    protected Shape face;

    public Triangle(Point p1, Point p2, Point p3) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
    }

    public Triangle(Point[] p) {
        this.p1 = p[0];
        this.p2 = p[1];
        this.p3 = p[2];
    }

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    public Point getP3() {
        return this.p3;
    }

    public Point getCorner(int c) {
        return this.getPoint(c);
    }

    @Override
    public Point getPoint(int c) {
        switch (c) {
            case 0: {
                return this.p1;
            }
            case 1: {
                return this.p2;
            }
            case 2: {
                return this.p3;
            }
        }
        throw new Error("Badly specified point number (" + c + "). Should be between 0 and 2");
    }

    @Override
    public int getDimension() {
        return 2;
    }

    public boolean orient(Point p) {
        Matrix m = new Matrix(4, 4);
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m.set(r, c, this.getCorner(r).getCoord(c));
            }
            m.set(r, 3, 1.0);
        }
        for (int c = 0; c < 3; ++c) {
            m.set(3, c, p.getCoord(c));
        }
        m.set(3, 3, 1.0);
        double det = m.determinant();
        if (Math.abs(det) < Constants.EPSILON) {
            return true;
        }
        return det < 0.0;
    }

    @Override
    public Point getCenter() {
        return new Point((this.p1.x() + this.p2.x() + this.p3.x()) / 3.0, (this.p1.y() + this.p2.y() + this.p3.y()) / 3.0, (this.p1.z() + this.p2.z() + this.p3.z()) / 3.0);
    }

    public double getArea() {
        return 0.5 * this.p1.vectorTo(this.p2).crossThis(this.p1.vectorTo(this.p3)).length();
    }

    public Vector getNormal() {
        return this.p1.vectorTo(this.p2).crossThis(this.p1.vectorTo(this.p3)).normalizeThis();
    }

    public double circumradius() {
        double a = this.p1.distance(this.p2);
        double b = this.p1.distance(this.p3);
        double c = this.p2.distance(this.p3);
        double s = (a + b + c) / 2.0;
        return a * b * c / (4.0 * Math.sqrt(s * (a + b - s) * (a + c - s) * (b + c - s)));
    }

    public Point circumcenter() {
        Vector n = this.getNormal();
        Point m1 = Point.getMidpoint(this.p1, this.p2);
        Point m2 = Point.getMidpoint(this.p1, this.p3);
        Line l1 = new Line(m1, this.p1.vectorTo(this.p2).crossThis(n));
        Line l2 = new Line(m2, this.p1.vectorTo(this.p3).crossThis(n));
        return l1.getIntersection(l2);
    }

    public double inradius() {
        double a = this.p1.distance(this.p2);
        double b = this.p1.distance(this.p3);
        double c = this.p2.distance(this.p3);
        double s = (a + b + c) / 2.0;
        return Math.sqrt((s - a) * (s - b) * (s - c) / s);
    }

    public Point incenter() {
        double a = this.p1.distance(this.p2);
        double b = this.p1.distance(this.p3);
        double c = this.p2.distance(this.p3);
        double P = a + b + c;
        Vector C = this.p3.toVector().multiplyThis(a);
        C.addThis(this.p2.toVector().multiplyThis(b));
        C.addThis(this.p1.toVector().multiplyThis(c));
        C.divideThis(P);
        return C.toPoint();
    }

    public Point getIntersection(Point p, Point q) {
        Vector dir = new Vector(p, q);
        Vector u = new Vector(this.p1, this.p2);
        Vector v = new Vector(this.p1, this.p3);
        Vector n = u.cross(v);
        if (n.isZeroVector()) {
            System.out.println("Normal is zero");
            return null;
        }
        Vector w0 = new Vector(this.p1, p);
        double a = -n.dot(w0);
        double b = n.dot(dir);
        if (Math.abs(b) < Constants.EPSILON) {
            if (a == 0.0) {
                System.out.println("a is zero");
                return null;
            }
            System.out.println("a is not zero");
            return null;
        }
        double r = a / b;
        if (r < 0.0) {
            return null;
        }
        Point intersection = new Point(p.x() + r * dir.x(), p.y() + r * dir.y(), p.z() + r * dir.z());
        if (this.contains(intersection)) {
            return intersection;
        }
        return null;
    }

    public boolean containsPoint(Point p) {
        return this.p1.equals(p) || this.p2.equals(p) || this.p3.equals(p);
    }

    public boolean contains(Point p) {
        double D;
        Vector u = new Vector(this.p1, this.p2);
        Vector v = new Vector(this.p1, this.p3);
        double uu = u.dot(u);
        double uv = u.dot(v);
        double vv = v.dot(v);
        Vector w = new Vector(this.p1, p);
        double wu = w.dot(u);
        double wv = w.dot(v);
        double s = (uv * wv - vv * wu) / (D = uv * uv - uu * vv);
        if (s < 0.0 || s > 1.0) {
            return false;
        }
        double t = (uv * wu - uu * wv) / D;
        return !(t < 0.0) && !(s + t > 1.0);
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        return String.format("Triangle[p1=%s,p2=%s,p3=%s]", this.p1.toString(dec), this.p2.toString(dec), this.p3.toString(dec));
    }

    public void toConsole() {
        this.toConsole(2);
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    private boolean isBig(Point p) {
        return Math.abs(p.x()) > 1000.0 || Math.abs(p.y()) > 1000.0 || Math.abs(p.z()) > 1000.0;
    }

    public Triangle clone() {
        return new Triangle(this.p1.clone(), this.p2.clone(), this.p3.clone());
    }
}

