/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.complex;

import ProGAL.geom3d.Plane;
import ProGAL.geom3d.complex.CTriangle;
import ProGAL.geom3d.complex.CVertex;
import ProGAL.geom3d.volumes.Tetrahedron;

public class CTetrahedron
extends Tetrahedron {
    private CTetrahedron[] neighbours = new CTetrahedron[4];
    private CTriangle[] triangles = new CTriangle[4];
    private boolean modified = false;
    private boolean flat = false;

    public CTetrahedron(CVertex p0, CVertex p1, CVertex p2, CVertex p3) {
        super(p0, p1, p2, p3);
    }

    protected CTetrahedron() {
        this(null, null, null, null);
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setPoint(CVertex p, int i) {
        this.corners[i] = p;
    }

    public void setNeighbour(int index, CTetrahedron t) {
        this.neighbours[index] = t;
    }

    public void setTriangle(int index, CTriangle t) {
        this.triangles[index] = t;
    }

    @Override
    public CVertex getPoint(int i) {
        return (CVertex)this.corners[i];
    }

    public CTetrahedron getNeighbour(int index) {
        return this.neighbours[index];
    }

    public CTriangle getTriangle(int index) {
        return this.triangles[index];
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean containsBigPoint() {
        return this.getPoint(0).isBigpoint() || this.getPoint(1).isBigpoint() || this.getPoint(2).isBigpoint() || this.getPoint(3).isBigpoint();
    }

    public int getNumberBigPoints() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (!this.getPoint(i).isBigpoint()) continue;
            ++count;
        }
        return count;
    }

    public CTetrahedron getNeighbour(CVertex v) {
        for (int i = 0; i < 4; ++i) {
            CTetrahedron tetr = this.getNeighbour(i);
            if (!tetr.containsPoint(v)) continue;
            return tetr;
        }
        return null;
    }

    public boolean hasNeighbor(CTetrahedron t) {
        for (int i = 0; i < 4; ++i) {
            if (this.neighbours[i] != t) continue;
            return true;
        }
        return false;
    }

    public int getID(CVertex v) {
        if (v == this.getPoint(0)) {
            return 0;
        }
        if (v == this.getPoint(1)) {
            return 1;
        }
        if (v == this.getPoint(2)) {
            return 2;
        }
        if (v == this.getPoint(3)) {
            return 3;
        }
        return -1;
    }

    public CVertex[] getCommonVertices(CTetrahedron tetr) {
        CVertex[] points = new CVertex[4];
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (!tetr.containsPoint(this.getPoint(i))) continue;
            points[n] = new CVertex(this.getPoint(i), this.getPoint((int)i).idx);
            for (int k = 0; k < 3; ++k) {
                if (!(Math.abs(points[n].get(k)) > 100.0)) continue;
                points[n].set(k, points[n].get(k) / 1.0);
            }
            ++n;
        }
        return points;
    }

    public Plane getPlane(CTetrahedron tetr) {
        CVertex[] points = new CVertex[3];
        CVertex v = null;
        int i = 0;
        int j = 0;
        while (i < 3) {
            if (tetr.containsPoint(this.getPoint(j))) {
                points[i] = this.getPoint(j);
                ++i;
            } else {
                v = this.getPoint(j);
            }
            ++j;
        }
        Plane plane = !points[0].isBigpoint() ? new Plane(points[0], points[1], points[2]) : (!points[1].isBigpoint() ? new Plane(points[1], points[2], points[0]) : new Plane(points[2], points[0], points[1]));
        if (plane.above(v) == 1) {
            plane.setNormal(plane.getNormal().multiplyThis(-1.0));
        }
        return plane;
    }

    public void updateNeighbour(CTetrahedron lookfor, CTetrahedron replacement) {
        for (int i = 0; i < 4; ++i) {
            if (this.neighbours[i] != lookfor) continue;
            this.neighbours[i] = replacement;
            break;
        }
    }

    public int findpoint(CVertex p) {
        for (int i = 0; i < 4; ++i) {
            if (this.getPoint(i) != p) continue;
            return i;
        }
        System.out.println("Problemer med findpoint\n");
        return -1;
    }

    public CTetrahedron findNeighbour(CVertex v) {
        for (int i = 0; i < 4; ++i) {
            if (!this.getNeighbour(i).containsPoint(v)) continue;
            return this.getNeighbour(i);
        }
        return null;
    }

    public CVertex findVertex(CTetrahedron tetr) {
        for (int i = 0; i < 4; ++i) {
            CVertex p = this.getPoint(i);
            if (tetr.containsPoint(p)) continue;
            return p;
        }
        return null;
    }

    public boolean containsPoint(CVertex p) {
        for (int i = 0; i < 4; ++i) {
            if (this.getPoint(i) != p) continue;
            return true;
        }
        return false;
    }

    public boolean containsTriangle(CTriangle t) {
        for (int tp = 0; tp < 3; ++tp) {
            boolean found = false;
            for (int p = 0; p < 4; ++p) {
                if (this.getPoint(p) != t.getPoint(tp)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public CVertex oppositeVertex(CTriangle base) {
        for (int p = 0; p < 4; ++p) {
            if (base.containsPoint(this.getPoint(p))) continue;
            return this.getPoint(p);
        }
        throw new RuntimeException("The triangle is not part of this tetrahedron");
    }

    public CTriangle oppositeTriangle(CVertex v) {
        for (CTriangle t : this.triangles) {
            if (t == null || t.containsPoint(v)) continue;
            return t;
        }
        throw new RuntimeException("The vertex is not part of this tetrahedron");
    }

    public int apexid(int index) {
        CTetrahedron apex_tet = this.getNeighbour(index);
        if (apex_tet != null) {
            for (int i = 0; i < 4; ++i) {
                if (apex_tet.getNeighbour(i) != this) continue;
                return i;
            }
        }
        return -1;
    }
}

