/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.complex.delaunayComplex;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.complex.CEdge;
import ProGAL.geom3d.complex.CTetrahedron;
import ProGAL.geom3d.complex.CTriangle;
import ProGAL.geom3d.complex.CVertex;
import ProGAL.geom3d.complex.SimplicialComplex;
import ProGAL.geom3d.complex.delaunayComplex.FirstTetrahedron;
import ProGAL.geom3d.complex.delaunayComplex.Flip14;
import ProGAL.geom3d.complex.delaunayComplex.Flips;
import ProGAL.geom3d.complex.delaunayComplex.Walk;
import ProGAL.geom3d.predicates.ExactJavaPredicates;
import ProGAL.geom3d.predicates.Predicates;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.math.Randomization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DelaunayComplex
implements SimplicialComplex {
    private final List<CVertex> points;
    private final List<CEdge> edges;
    private final List<CTriangle> triangles;
    private final List<CTetrahedron> tetrahedra;
    private final Predicates predicates;
    private final Walk walk;
    private final Flip14 f14;
    private final Flips flips;

    public DelaunayComplex(List<Point> points) {
        this.points = new ArrayList<CVertex>(points.size());
        int i = 0;
        for (Point p : points) {
            this.points.add(new CVertex(p, i++));
        }
        this.edges = new ArrayList<CEdge>(points.size() * 6);
        this.triangles = new ArrayList<CTriangle>(points.size() * 6);
        this.tetrahedra = new ArrayList<CTetrahedron>(points.size() * 6);
        this.predicates = new ExactJavaPredicates();
        this.walk = new Walk(this.predicates);
        this.flips = new Flips(this.predicates);
        this.f14 = new Flip14(this.flips);
        this.compute();
        this.completeComplex();
    }

    public boolean isDelaunay() {
        for (CTetrahedron tetr : this.tetrahedra) {
            Sphere sphere = new Sphere(tetr);
        }
        return true;
    }

    @Override
    public List<CTetrahedron> getTetrahedra() {
        return new ArrayList<CTetrahedron>(this.tetrahedra);
    }

    public List<CTetrahedron> getAllTetrahedra() {
        ArrayList<CTetrahedron> allTetrahedra = new ArrayList<CTetrahedron>();
        for (CVertex v : this.getVertices()) {
            List<CTetrahedron> adjacentTetrahedra = v.getAllAdjacentTetrahedra();
            for (CTetrahedron tetr : adjacentTetrahedra) {
                if (allTetrahedra.contains(tetr)) continue;
                allTetrahedra.add(tetr);
            }
        }
        return allTetrahedra;
    }

    public List<CTetrahedron> getBigTetrahedra() {
        ArrayList<CTetrahedron> bigTetrahedra = new ArrayList<CTetrahedron>();
        for (CVertex v : this.getVertices()) {
            List<CTetrahedron> adjacentTetrahedra = v.getAllAdjacentTetrahedra();
            for (CTetrahedron tetr : adjacentTetrahedra) {
                if (!tetr.containsBigPoint() || bigTetrahedra.contains(tetr)) continue;
                bigTetrahedra.add(tetr);
            }
        }
        return bigTetrahedra;
    }

    @Override
    public List<CTriangle> getTriangles() {
        return new ArrayList<CTriangle>(this.triangles);
    }

    @Override
    public List<CEdge> getEdges() {
        return new ArrayList<CEdge>(this.edges);
    }

    @Override
    public List<CVertex> getVertices() {
        return new ArrayList<CVertex>(this.points);
    }

    public CVertex getVertex(int i) {
        return this.points.get(i);
    }

    protected void compute() {
        double max = 1000.0;
        for (CVertex v : this.points) {
            v.addThis(new Vector(Randomization.randBetween(-1.0E-5, 1.0E-5), Randomization.randBetween(-1.0E-5, 1.0E-5), Randomization.randBetween(-1.0E-5, 1.0E-5)));
        }
        CTetrahedron next_t = new FirstTetrahedron(max);
        this.flips.addTetrahedron(next_t);
        for (CVertex p : this.points) {
            next_t = this.walk.walk(next_t, p);
            next_t = this.f14.flip14(next_t, p);
            CTetrahedron tmp = this.flips.fixDelaunay();
            if (tmp == null) continue;
            next_t = tmp;
        }
    }

    protected void completeComplex() {
        this.tetrahedra.clear();
        this.triangles.clear();
        this.edges.clear();
        for (CTetrahedron cTetrahedron : this.flips.getTetrahedrastack()) {
            if (cTetrahedron.isModified() || cTetrahedron.containsBigPoint()) continue;
            this.tetrahedra.add(cTetrahedron);
        }
        class VertexPair {
            CVertex p1;
            CVertex p2;

            VertexPair(CVertex p1, CVertex p2) {
                this.p1 = p1;
                this.p2 = p2;
            }

            public boolean equals(Object o) {
                return ((VertexPair)o).p1 == this.p1 && ((VertexPair)o).p2 == this.p2 || ((VertexPair)o).p1 == this.p2 && ((VertexPair)o).p2 == this.p1;
            }

            public int hashCode() {
                return this.p1.hashCode() ^ this.p2.hashCode();
            }
        }
        HashMap<VertexPair, CEdge> edgeMap = new HashMap<VertexPair, CEdge>();
        for (CTetrahedron t : this.tetrahedra) {
            edgeMap.put(new VertexPair(t.getPoint(0), t.getPoint(1)), new CEdge(t.getPoint(0), t.getPoint(1)));
            edgeMap.put(new VertexPair(t.getPoint(0), t.getPoint(2)), new CEdge(t.getPoint(0), t.getPoint(2)));
            edgeMap.put(new VertexPair(t.getPoint(0), t.getPoint(3)), new CEdge(t.getPoint(0), t.getPoint(3)));
            edgeMap.put(new VertexPair(t.getPoint(1), t.getPoint(2)), new CEdge(t.getPoint(1), t.getPoint(2)));
            edgeMap.put(new VertexPair(t.getPoint(1), t.getPoint(3)), new CEdge(t.getPoint(1), t.getPoint(3)));
            edgeMap.put(new VertexPair(t.getPoint(2), t.getPoint(3)), new CEdge(t.getPoint(2), t.getPoint(3)));
        }
        this.edges.addAll(edgeMap.values());
        for (CEdge e : this.edges) {
            ((CVertex)e.getA()).addAdjacentEdge(e);
            ((CVertex)e.getB()).addAdjacentEdge(e);
        }
        HashSet<CTriangle> hashSet = new HashSet<CTriangle>();
        for (CTetrahedron cTetrahedron : this.tetrahedra) {
            hashSet.add(new CTriangle(cTetrahedron.getPoint(1), cTetrahedron.getPoint(2), cTetrahedron.getPoint(3), cTetrahedron, cTetrahedron.getNeighbour(0)));
            hashSet.add(new CTriangle(cTetrahedron.getPoint(0), cTetrahedron.getPoint(2), cTetrahedron.getPoint(3), cTetrahedron, cTetrahedron.getNeighbour(1)));
            hashSet.add(new CTriangle(cTetrahedron.getPoint(0), cTetrahedron.getPoint(1), cTetrahedron.getPoint(3), cTetrahedron, cTetrahedron.getNeighbour(2)));
            hashSet.add(new CTriangle(cTetrahedron.getPoint(0), cTetrahedron.getPoint(1), cTetrahedron.getPoint(2), cTetrahedron, cTetrahedron.getNeighbour(3)));
        }
        this.triangles.addAll(hashSet);
        for (CTriangle cTriangle : this.triangles) {
            CEdge e1 = (CEdge)edgeMap.get(new VertexPair((CVertex)cTriangle.getPoint(0), (CVertex)cTriangle.getPoint(1)));
            CEdge e2 = (CEdge)edgeMap.get(new VertexPair((CVertex)cTriangle.getPoint(1), (CVertex)cTriangle.getPoint(2)));
            CEdge e3 = (CEdge)edgeMap.get(new VertexPair((CVertex)cTriangle.getPoint(2), (CVertex)cTriangle.getPoint(0)));
            cTriangle.setEdge(0, e1);
            cTriangle.setEdge(1, e2);
            cTriangle.setEdge(2, e3);
            e1.addTriangle(cTriangle);
            e2.addTriangle(cTriangle);
            e3.addTriangle(cTriangle);
        }
        for (CTriangle cTriangle : this.triangles) {
            CTetrahedron tet = cTriangle.getAdjacentTetrahedron(0);
            if (tet.getNeighbour(0).containsTriangle(cTriangle)) {
                tet.setTriangle(0, cTriangle);
            } else if (tet.getNeighbour(1).containsTriangle(cTriangle)) {
                tet.setTriangle(1, cTriangle);
            } else if (tet.getNeighbour(2).containsTriangle(cTriangle)) {
                tet.setTriangle(2, cTriangle);
            } else if (tet.getNeighbour(3).containsTriangle(cTriangle)) {
                tet.setTriangle(3, cTriangle);
            }
            tet = cTriangle.getAdjacentTetrahedron(1);
            if (tet.getNeighbour(0).containsTriangle(cTriangle)) {
                tet.setTriangle(0, cTriangle);
                continue;
            }
            if (tet.getNeighbour(1).containsTriangle(cTriangle)) {
                tet.setTriangle(1, cTriangle);
                continue;
            }
            if (tet.getNeighbour(2).containsTriangle(cTriangle)) {
                tet.setTriangle(2, cTriangle);
                continue;
            }
            if (!tet.getNeighbour(3).containsTriangle(cTriangle)) continue;
            tet.setTriangle(3, cTriangle);
        }
    }

    public Set<CTetrahedron> getVertexHull(CVertex v) {
        HashSet<CTetrahedron> hull = new HashSet<CTetrahedron>();
        for (CEdge e : v.getAdjacentEdges()) {
            for (CTriangle tri : e.getAdjacentTriangles()) {
                hull.add(tri.getAdjacentTetrahedron(0));
                hull.add(tri.getAdjacentTetrahedron(1));
            }
        }
        return hull;
    }

    public boolean checkTetrahedra() {
        for (CTetrahedron t : this.tetrahedra) {
            for (CVertex p : this.points) {
                if (t.getPoint(0) == p || t.getPoint(1) == p || t.getPoint(2) == p || t.getPoint(3) == p || !this.predicates.insphere(t, (Point)p).equals((Object)Predicates.SphereConfig.INSIDE)) continue;
                return false;
            }
        }
        return true;
    }
}

