/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.complex.delaunayComplex;

import ProGAL.geom3d.complex.CTetrahedron;
import ProGAL.geom3d.complex.CVertex;
import ProGAL.geom3d.predicates.Predicates;

class Walk {
    private Predicates primitives;

    public Walk(Predicates primitives) {
        this.primitives = primitives;
    }

    public CTetrahedron walk(CTetrahedron t, CVertex p) {
        boolean next = false;
        while (true) {
            for (int i = 0; i < 4; ++i) {
                if (this.primitives.inplane(t.getPoint((i + 1) % 4), t.getPoint((i + 2) % 4), t.getPoint((i + 3) % 4), p)) {
                    p.setDegenerate(true);
                    p.setDegCase(CVertex.DegenerateCase.ONFACE);
                    p.setDegPointOpposite(t.getPoint(i));
                    if (this.primitives.inplane(t.getPoint((i + 1) % 4), t.getPoint((i + 2) % 4), t.getPoint(i % 4), p)) {
                        p.setDegCase(CVertex.DegenerateCase.ONEDGE);
                        p.setDegPointA(t.getPoint((i + 1) % 4));
                        p.setDegPointB(t.getPoint((i + 2) % 4));
                    }
                    if (this.primitives.inplane(t.getPoint((i + 2) % 4), t.getPoint((i + 3) % 4), t.getPoint(i % 4), p)) {
                        p.setDegCase(CVertex.DegenerateCase.ONEDGE);
                        p.setDegPointA(t.getPoint((i + 2) % 4));
                        p.setDegPointB(t.getPoint((i + 3) % 4));
                    }
                    if (this.primitives.inplane(t.getPoint((i + 1) % 4), t.getPoint((i + 3) % 4), t.getPoint(i % 4), p)) {
                        p.setDegCase(CVertex.DegenerateCase.ONEDGE);
                        p.setDegPointA(t.getPoint((i + 1) % 4));
                        p.setDegPointB(t.getPoint((i + 3) % 4));
                    }
                    return t;
                }
                Predicates.PlaneConfig pc = this.primitives.diffsides(t.getPoint((i + 1) % 4), t.getPoint((i + 2) % 4), t.getPoint((i + 3) % 4), p, t.getPoint(i));
                if (pc != Predicates.PlaneConfig.DIFF) continue;
                next = true;
                t = t.getNeighbour(i);
                break;
            }
            if (!next) break;
            next = false;
        }
        return t;
    }
}

