/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.kineticDelaunay;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Shape;
import ProGAL.geom3d.Triangle;
import ProGAL.geom3d.kineticDelaunay.Vertex;
import ProGAL.geom3d.viewer.J3DScene;
import ProGAL.geom3d.volumes.LSS;
import java.awt.Color;
import java.util.Arrays;

public class Tri {
    private Vertex[] corners = new Vertex[3];
    Integer count = null;
    boolean dAlive = true;
    boolean cAlive = true;
    private Shape[] LSSs = new Shape[3];
    private Triangle triangle;
    int alph = 0;

    public Tri(Vertex[] corners) {
        this.corners = corners;
        this.sortCorners();
    }

    public Tri(Vertex v0, Vertex v1, Vertex v2) {
        this.corners[0] = v0;
        this.corners[1] = v1;
        this.corners[2] = v2;
        this.sortCorners();
    }

    private void sortCorners() {
        Vertex tmp;
        int id0 = this.corners[0].getId();
        int id1 = this.corners[1].getId();
        int id2 = this.corners[2].getId();
        if (id0 > id1) {
            if (id2 > id1) {
                tmp = this.corners[0];
                this.corners[0] = this.corners[1];
                if (id0 > id2) {
                    this.corners[1] = this.corners[2];
                    this.corners[2] = tmp;
                } else {
                    this.corners[1] = tmp;
                }
            } else {
                tmp = this.corners[0];
                this.corners[0] = this.corners[2];
                this.corners[2] = tmp;
            }
        }
        if (id1 > id2) {
            if (id0 > id2) {
                tmp = this.corners[0];
                this.corners[0] = this.corners[2];
                this.corners[2] = this.corners[1];
                this.corners[1] = tmp;
            } else {
                tmp = this.corners[1];
                this.corners[1] = this.corners[2];
                this.corners[2] = tmp;
            }
        }
    }

    public Vertex getCorner(int i) {
        return this.corners[i];
    }

    public void setAlph(int i) {
        this.alph = i;
    }

    public int getAlph() {
        return this.alph;
    }

    public double getCircumRadius() {
        return new Circle((Point)this.corners[0], (Point)this.corners[1], this.corners[2]).getRadius();
    }

    public boolean hasVertex(Vertex v) {
        for (int i = 0; i < 3; ++i) {
            if (this.corners[i] != v) continue;
            return true;
        }
        return false;
    }

    public boolean isAlive() {
        return this.dAlive;
    }

    public void setAlive(boolean dAlive) {
        this.dAlive = dAlive;
    }

    public boolean isBig() {
        return this.corners[0].getId() < 4 || this.corners[1].getId() < 4;
    }

    public boolean isAlpha(double alpha) {
        return this.getCircumRadius() < alpha;
    }

    public int getCount() {
        if (this.count != null) {
            return this.count;
        }
        this.count = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.corners[i].getType() != Vertex.VertexType.R) continue;
            this.count = this.count + (int)Math.pow(2.0, i);
        }
        return this.count;
    }

    public int indexOf_slow(Vertex v) {
        return Arrays.binarySearch(this.corners, v);
    }

    public String toString() {
        return Arrays.toString(this.corners);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tri)) {
            return false;
        }
        return ((Tri)o).getCorner(0).equals(this.corners[0]) && ((Tri)o).getCorner(1).equals(this.corners[1]) && ((Tri)o).getCorner(2).equals(this.corners[2]);
    }

    public int hashCode() {
        return this.corners[0].getId() + this.corners[1].getId() * 2 + this.corners[2].getId() * 4;
    }

    public void toConsole() {
        System.out.println(this.toString());
    }

    public void fromSceneEdges(J3DScene scene) {
        for (int i = 0; i < 3; ++i) {
            scene.removeShape(this.LSSs[i]);
        }
        scene.repaint();
    }

    public void fromSceneEdge(J3DScene scene) {
        for (int i = 0; i < 3; ++i) {
            scene.removeShape(this.LSSs[i]);
        }
        scene.repaint();
    }

    public void toSceneEdges(J3DScene scene, Color clr, double width) {
        int k = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = i + 1; j < 3; ++j) {
                if (this.LSSs[k] == null) {
                    this.LSSs[k] = new LSS(this.corners[i], this.corners[j], width);
                }
                scene.addShape(this.LSSs[k++], clr, 3);
            }
        }
        scene.repaint();
    }

    public void toScene(J3DScene scene, Color clr) {
        this.triangle = new Triangle(this.corners[0], this.corners[1], this.corners[2]);
        scene.addShape(this.triangle, clr);
        scene.repaint();
    }

    public void fromScene(J3DScene scene) {
        scene.removeShape(this.triangle);
        scene.repaint();
    }

    public void toSceneEdges(J3DScene scene, Color clr, double width, double bigWidth) {
        double edgeWidth = width;
        for (int i = 0; i < 3; ++i) {
            if (this.corners[i].getId() >= 4) continue;
            edgeWidth = bigWidth;
        }
        int k = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = i + 1; j < 3; ++j) {
                if (this.LSSs[k] == null) {
                    this.LSSs[k] = new LSS(this.corners[i], this.corners[j], edgeWidth);
                }
                scene.addShape(this.LSSs[k++], clr, 3);
            }
        }
        scene.repaint();
    }
}

