/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.surface;

import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.surface.ParametricSurface;
import ProGAL.math.Matrix;

public class ParametricParaboloid
extends ParametricSurface {
    private double a;
    private double b;
    private double c;
    private Vector displacement;
    private Matrix rotation;

    public ParametricParaboloid(double a, double b, double c) {
        this(a, b, c, new Vector(0.0, 0.0, 0.0));
    }

    public ParametricParaboloid(double a, double b, double c, Vector displacement) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.displacement = displacement;
        this.rotation = Matrix.createIdentityMatrix(3);
    }

    public Vector getDisplacement() {
        return this.displacement.clone();
    }

    public void setDisplacement(Vector v) {
        this.displacement.set(v);
    }

    public double getA() {
        return this.a;
    }

    public void setA(double v) {
        this.a = v;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double v) {
        this.b = v;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double v) {
        this.c = v;
    }

    public Matrix getRotation() {
        return this.rotation.clone();
    }

    public void setRotation(Matrix rot) {
        for (int r = 0; r < this.rotation.getM(); ++r) {
            for (int c = 0; c < this.rotation.getN(); ++c) {
                this.rotation.set(r, c, rot.get(r, c));
            }
        }
    }

    @Override
    public Point getPoint(double u, double v) {
        return (Point)this.rotation.multiplyIn(new Point(this.a * (u + v), this.b * (v - u), this.c * v * u)).addThis(this.displacement);
    }

    @Override
    public Point getPoint(ProGAL.geom2d.Point par) {
        return this.getPoint(par.get(0), par.get(1));
    }

    @Override
    public ParametricParaboloid clone() {
        ParametricParaboloid ret = new ParametricParaboloid(this.a, this.b, this.c, this.displacement.clone());
        ret.setRotation(this.rotation);
        return ret;
    }

    public String toString() {
        return String.format("ParametricParaboloid[a:%.3f,b:%.3f,c:%.3f,dis:%s,rot:\n%s", this.a, this.b, this.c, this.displacement.toString(3), this.rotation.toString(3));
    }
}

