/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.tessellation.BowyerWatson;

import ProGAL.geom3d.PointWeighted;
import ProGAL.geom3d.volumes.Tetrahedron;

public class Tetr
extends Tetrahedron {
    public final PointWeighted[] corners = new PointWeighted[4];
    public final Tetr[] neighbors = new Tetr[4];
    public final int[] cornerSides = new int[4];

    public Tetr(PointWeighted p0, PointWeighted p1, PointWeighted p2, PointWeighted p3) {
        super(p0, p1, p2, p3);
        this.corners[0] = p0;
        this.corners[1] = p1;
        this.corners[2] = p2;
        this.corners[3] = p3;
        if (Tetr.orient3d(p1.getCoords(), p2.getCoords(), p3.getCoords(), p0.getCoords()) > 0.0) {
            this.cornerSides[0] = 1;
            this.cornerSides[1] = -1;
            this.cornerSides[2] = 1;
            this.cornerSides[3] = -1;
        } else {
            this.cornerSides[0] = -1;
            this.cornerSides[1] = 1;
            this.cornerSides[2] = -1;
            this.cornerSides[3] = 1;
        }
    }

    public int cornerIdx(PointWeighted p) {
        for (int i = 0; i < 4; ++i) {
            if (this.corners[i] != p) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return String.format("Tetr[%s,%s,%s,%s]", this.corners[0], this.corners[1], this.corners[2], this.corners[3]);
    }

    private static double orient3d(double[] pa, double[] pb, double[] pc, double[] pd) {
        double adx = pa[0] - pd[0];
        double bdx = pb[0] - pd[0];
        double cdx = pc[0] - pd[0];
        double ady = pa[1] - pd[1];
        double bdy = pb[1] - pd[1];
        double cdy = pc[1] - pd[1];
        double adz = pa[2] - pd[2];
        double bdz = pb[2] - pd[2];
        double cdz = pc[2] - pd[2];
        double bdxcdy = bdx * cdy;
        double cdxbdy = cdx * bdy;
        double cdxady = cdx * ady;
        double adxcdy = adx * cdy;
        double adxbdy = adx * bdy;
        double bdxady = bdx * ady;
        return adz * (bdxcdy - cdxbdy) + bdz * (cdxady - adxcdy) + cdz * (adxbdy - bdxady);
    }
}

