/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.viewer.J3DScene;
import ProGAL.geom3d.volumes.Cone;
import ProGAL.geom3d.volumes.Sphere;
import java.awt.Color;

public class InfCone {
    protected Point apex;
    protected Vector axis;
    protected double angle;

    public InfCone(Point apex, Vector axis, double angle) {
        this.apex = apex;
        this.axis = axis;
        this.angle = angle;
    }

    public InfCone(Point apex, Point p1, Point p2, Point p3) {
        Vector v1 = apex.vectorTo(p1);
        v1.normalizeThis();
        Vector v2 = apex.vectorTo(p2);
        v2.normalizeThis();
        Vector v3 = apex.vectorTo(p3);
        v3.normalizeThis();
        Circle c = new Circle(apex.add(v1), apex.add(v2), apex.add(v3));
        this.axis = apex.vectorTo(c.getCenter()).normalizeThis();
        this.angle = 2.0 * Math.atan(c.getRadius() / apex.distance(c.getCenter()));
    }

    public Point getApex() {
        return this.apex;
    }

    public Vector getAxis() {
        return this.axis;
    }

    public double getAngle() {
        return this.angle;
    }

    public String toString(int dec) {
        return String.format("Cone[apex:%s,axis:%s,angle:%." + dec + "f]", this.apex, this.axis, this.angle);
    }

    public String toString() {
        return this.toString(2);
    }

    public static void main(String[] args) {
        J3DScene scene = J3DScene.createJ3DSceneInFrame();
        Point p0 = new Point(Point.getRandomPoint(3, -1.0, 1.0).getCoords());
        Point p1 = new Point(Point.getRandomPoint(3, -1.0, 1.0).getCoords());
        Point p2 = new Point(Point.getRandomPoint(3, -1.0, 1.0).getCoords());
        Point p3 = new Point(Point.getRandomPoint(3, -1.0, 1.0).getCoords());
        InfCone n = new InfCone(p0, p1, p2, p3);
        System.out.println(p0);
        System.out.println(n);
        Cone c = new Cone(n.getApex().add(n.getAxis()), n.getApex(), Math.tan(n.getAngle() / 2.0));
        scene.addShape(new Sphere(p0, 0.05), Color.BLACK);
        scene.addShape(new Sphere(p1, 0.05));
        scene.addShape(new Sphere(p2, 0.05));
        scene.addShape(new Sphere(p3, 0.05));
        scene.addShape(c, new Color(0, 0, 200, 240), 100);
        scene.setAxisEnabled(true);
    }
}

