/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom2d.Circle;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Cylinder;
import ProGAL.geom3d.volumes.LSS;
import ProGAL.geom3d.volumes.Sphere;
import java.util.ArrayList;

public class InfCylinder {
    protected Line line;
    protected double radius;

    public InfCylinder(Line l, double r) {
        this.line = l;
        this.radius = r;
    }

    public LSS capWithHalfSpheres(PointList enclosedPoints) {
        double lowerT = Double.POSITIVE_INFINITY;
        double upperT = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < enclosedPoints.size(); ++i) {
            Point p = (Point)enclosedPoints.get(i);
            Sphere s = new Sphere(p, this.radius + (double)1.0E-5f);
            double[] intersections = s.intersectionParameters(this.line);
            if (intersections.length < 2) {
                double intersection = this.line.orthogonalProjectionParameter(p);
                if (intersection > upperT) {
                    upperT = intersection;
                }
                if (!(intersection < lowerT)) continue;
                lowerT = intersection;
                continue;
            }
            if (intersections[0] > upperT) {
                upperT = intersections[0];
            }
            if (!(intersections[1] < lowerT)) continue;
            lowerT = intersections[1];
        }
        return new LSS(this.line.getPoint(lowerT), this.line.getPoint(upperT), this.radius);
    }

    public Cylinder capWithDiscs(PointList enclosedPoints) {
        double lowerT = Double.POSITIVE_INFINITY;
        double upperT = Double.NEGATIVE_INFINITY;
        for (Point p : enclosedPoints) {
            Plane plane = new Plane(p, this.line.getDir());
            double intersection = plane.getIntersectionParameter(this.line);
            if (intersection > upperT) {
                upperT = intersection;
            }
            if (!(intersection < lowerT)) continue;
            lowerT = intersection;
        }
        return new Cylinder(this.line.getPoint(lowerT), this.line.getPoint(upperT), this.radius);
    }

    public static InfCylinder createMinRadCylinderFromDirection(PointList points, Vector dir) {
        Plane p = new Plane(dir);
        ArrayList<ProGAL.geom2d.Point> points2d = new ArrayList<ProGAL.geom2d.Point>();
        Vector x = new Vector(dir.x(), dir.y(), dir.z() + 1.0);
        if (dir.x() == 0.0 && dir.x() == 0.0) {
            x.setX(x.x() + 1.0);
        }
        x = x.cross(dir).scaleToLength(1.0);
        Vector y = x.cross(dir).scaleToLength(1.0);
        for (int i = 0; i < points.size(); ++i) {
            Point po = (Point)points.get(i);
            Point projected = p.projectPoint(po);
            ProGAL.geom2d.Point p2d = new ProGAL.geom2d.Point(x.dot(projected.toVector()), y.dot(projected.toVector()));
            points2d.add(p2d);
            System.out.println(p2d);
        }
        Circle mec = Circle.minimumEnclosingCircle_Welzl(points2d);
        Point linePoint = x.multiply(mec.center().x()).addThis(y.multiply(mec.center().y())).toPoint();
        return new InfCylinder(new Line(linePoint, dir.clone()), mec.getRadius() + mec.getRadius() * 0.001);
    }

    public String toString() {
        return String.format("InfCylinder[%s,%.2f]", this.line.toString(), this.radius);
    }

    public LSS capWithHalfSpheres(LSS c1, LSS c2) {
        double lowerT = Double.POSITIVE_INFINITY;
        double upperT = Double.NEGATIVE_INFINITY;
        Point[] centers = new Point[]{c1.segment.getA(), c1.segment.getB(), c2.segment.getA(), c2.segment.getB()};
        double[] rads = new double[]{c1.rad, c1.rad, c2.rad, c2.rad};
        for (int i = 0; i < 4; ++i) {
            Point p = centers[i];
            double rad = rads[i];
            Sphere s = new Sphere(p, this.radius - rad + 1.0E-5);
            double[] intersections = s.intersectionParameters(this.line);
            if (intersections.length < 2) {
                double intersection = this.line.orthogonalProjectionParameter(p);
                if (intersection + rad > upperT) {
                    upperT = intersection + rad;
                }
                if (!(intersection - rad < lowerT)) continue;
                lowerT = intersection - rad;
                continue;
            }
            double upperIntersection = intersections[0];
            double lowerIntersection = intersections[1];
            if (upperIntersection > upperT) {
                upperT = upperIntersection;
            }
            if (!(lowerIntersection < lowerT)) continue;
            lowerT = lowerIntersection;
        }
        return new LSS(this.line.getPoint(lowerT), this.line.getPoint(upperT), this.radius);
    }
}

