/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom2d.Circle;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.LineSegment;
import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.PointList;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.InfCylinder;
import ProGAL.geom3d.volumes.Volume;
import ProGAL.math.Constants;
import ProGAL.math.Matrix3x3;

public class LSS
implements Volume {
    public LineSegment segment;
    public double rad;

    public LSS(Point p1, Point p2, double r) {
        this(new LineSegment(p1, p2), r);
    }

    public LSS(LineSegment segment, double r) {
        this.segment = segment;
        this.rad = r;
    }

    public static LSS createBoundingLSS(PointList points) {
        return LSS.createBoundingLSS_covariance(points);
    }

    public static LSS createBoundingLSS_covariance(PointList points) {
        if (points.size() <= 0) {
            throw new Error("Cannot create capsule enclosing 0 points");
        }
        if (points.size() == 1) {
            return new LSS(((Point)points.get(0)).clone(), ((Point)points.get(0)).clone(), 0.0);
        }
        if (points.size() == 2) {
            return new LSS(((Point)points.get(0)).clone(), ((Point)points.get(1)).clone(), 0.0);
        }
        Matrix3x3 covMatr = points.getCovariance();
        covMatr.toConsole(3);
        Vector[] eigenVecs = covMatr.getEigenvectors();
        if (eigenVecs[0] == null) {
            eigenVecs[0] = eigenVecs[1].cross(eigenVecs[2]);
        }
        if (eigenVecs[1] == null) {
            eigenVecs[1] = eigenVecs[2].cross(eigenVecs[0]);
        }
        if (eigenVecs[2] == null) {
            eigenVecs[2] = eigenVecs[0].cross(eigenVecs[1]);
        }
        Vector dir = eigenVecs[0];
        if (eigenVecs[1] != null && eigenVecs[1].length() > dir.length()) {
            dir = eigenVecs[1];
        }
        if (eigenVecs[2] != null && eigenVecs[2].length() > dir.length()) {
            dir = eigenVecs[2];
        }
        InfCylinder iCyl = InfCylinder.createMinRadCylinderFromDirection(points, dir.normalizeThis());
        LSS ret = iCyl.capWithHalfSpheres(points);
        return ret;
    }

    public static LSS createBoundingLSS_MaxDist(LSS v1, LSS v2) {
        double[] rads = new double[]{v1.rad, v1.rad, v2.rad, v2.rad};
        Point[] points = new Point[]{v1.segment.getA(), v1.segment.getB(), v2.segment.getA(), v2.segment.getB()};
        int m1 = 0;
        int m2 = 1;
        double best = v1.segment.getLength() + v1.rad + v1.rad;
        double dist = v2.segment.getLength() + v2.rad + v2.rad;
        if (dist > best) {
            best = dist;
            m1 = 2;
            m2 = 3;
        }
        double sumOfRads = v1.rad + v2.rad;
        for (int i = 0; i < 2; ++i) {
            for (int j = 2; j < 4; ++j) {
                dist = points[i].distance(points[j]) + sumOfRads;
                if (!(dist > best)) continue;
                best = dist;
                m1 = i;
                m2 = j;
            }
        }
        Vector dir = points[m1].vectorTo(points[m2]).scaleToLength(1.0);
        int exclude = 0;
        exclude = m1 > 1 && m2 > 1 ? 2 : (rads[m1] > rads[m2] ? m2 : m1);
        InfCylinder iCyl = LSS.createCylinderFromDirAndThreeSpheres(dir, rads, points, exclude);
        LSS ret = iCyl.capWithHalfSpheres(v1, v2);
        return ret;
    }

    private static final InfCylinder createCylinderFromDirAndThreeSpheres(Vector dir, double[] rads, Point[] points, int exclude) {
        Plane p = new Plane(new Point(0.0, 0.0, 0.0), dir);
        Vector rand = new Vector(1.0, dir.x() == -1.0 || dir.x() == 1.0 ? 1.0 : 0.0, 0.0);
        Vector x = rand.cross(dir).scaleToLength(1.0);
        Vector y = x.cross(dir);
        Circle[] cArr = new Circle[3];
        int c = 0;
        for (int i = 0; i < 3; ++i) {
            if (exclude == c) {
                ++c;
            }
            Vector proj = p.projectPoint(points[c]).toVector();
            cArr[i] = new Circle(new ProGAL.geom2d.Point(x.dot(proj), y.dot(proj)), rads[c]);
            ++c;
        }
        Circle mec = new Circle(cArr[0], cArr[1], cArr[2]);
        Point linePoint = x.multiply(mec.center().x()).add(y.multiply(mec.center().y())).toPoint();
        return new InfCylinder(new Line(linePoint, dir), mec.getRadius());
    }

    private static double clamp(double s) {
        if (s < 0.0) {
            return 0.0;
        }
        if (s > 1.0) {
            return 1.0;
        }
        return s;
    }

    public double distanceToPoint(Point point) {
        Vector d = this.segment.getAToB();
        double t = LSS.clamp(-point.vectorTo(this.segment.getA()).dot(d) / d.dot(d));
        return this.segment.getA().add(d.multiplyThis(t)).subtractThis(point.toVector()).toVector().length();
    }

    public boolean overlaps(LSS capsule) {
        double minDist = this.closestSegmentPoint(capsule);
        return minDist <= this.rad + capsule.rad;
    }

    public double closestSegmentPoint(LSS capsule) {
        double t;
        double b;
        Point startPoint1 = this.segment.getA();
        Point startPoint2 = capsule.segment.getA();
        Vector dir1 = this.segment.getAToB();
        Vector dir2 = capsule.segment.getAToB();
        double a = dir1.getLengthSquared();
        double e = dir2.getLengthSquared();
        if (a < Constants.EPSILON && e < Constants.EPSILON) {
            return startPoint1.distance(startPoint2);
        }
        if (a < Constants.EPSILON) {
            return LSS.closestSegmentPoint(startPoint2, capsule.segment.getB(), startPoint1);
        }
        if (e < Constants.EPSILON) {
            return LSS.closestSegmentPoint(startPoint1, this.segment.getB(), startPoint2);
        }
        Vector r = startPoint2.vectorTo(startPoint1);
        double f = dir2.dot(r);
        double c = dir1.dot(r);
        double denom = a * e - (b = dir1.dot(dir2)) * b;
        double s = denom != 0.0 ? LSS.clamp((b * f - c * e) / denom) : 0.0;
        double tnom = b * s + f;
        if (tnom < 0.0) {
            t = 0.0;
            s = LSS.clamp(-c / a);
        } else if (tnom > e) {
            t = 1.0;
            s = LSS.clamp((b - c) / a);
        } else {
            t = tnom / e;
        }
        Point c1 = startPoint1.add(dir1.multiplyThis(s));
        Point c2 = startPoint2.add(dir2.multiplyThis(t));
        return c1.distance(c2);
    }

    private static double closestSegmentPoint(Point p11, Point p12, Point p2) {
        Line l = new Line(p11, p11.vectorTo(p12));
        double t = l.orthogonalProjectionParameter(p2);
        t = LSS.clamp(t) * p11.distance(p12);
        return l.getPoint(t).distance(p2);
    }

    @Override
    public boolean overlaps(Volume vol) {
        if (vol instanceof LSS) {
            return this.overlaps((LSS)vol);
        }
        throw new Error("Unimplemented");
    }

    public boolean contains(Point p) {
        Line l = new Line(this.segment);
        double t = l.orthogonalProjectionParameter(p);
        if (t > 1.0) {
            t = 1.0;
        } else if (t < 0.0) {
            t = 0.0;
        }
        return l.getPoint(t).distance(p) <= this.rad;
    }

    @Override
    public double getVolume() {
        double sphereVols = 4.1887902047863905 * this.rad * this.rad * this.rad;
        double cylVol = Math.PI * this.rad * this.rad * this.segment.getLength();
        return sphereVols + cylVol;
    }

    @Override
    public LSS clone() {
        return new LSS(this.segment.clone(), this.rad);
    }

    @Override
    public Point getCenter() {
        return this.segment.getMidPoint();
    }

    public String toString() {
        return String.format("LSS[ls=%s,r=%f]", this.segment, this.rad);
    }
}

