/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Circle;
import ProGAL.geom3d.ParametricPlane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.geom3d.volumes.Volume;

public class Lens
implements Volume {
    private final Sphere s0;
    private final Sphere s1;
    private Circle equator;
    private ParametricPlane plane;
    private double d0;
    private double d1;
    private double r;

    public Lens(Sphere s0, Sphere s1) {
        this.s0 = s0.clone();
        this.s1 = s1.clone();
        double d = s0.getCenter().distance(s1.getCenter());
        this.d0 = (d * d - s1.getRadiusSquared() + s0.getRadiusSquared()) / (2.0 * d);
        this.d1 = d - this.d0;
        if (this.d0 <= 0.0 || this.d1 <= 0.0) {
            throw new IllegalArgumentException("Lens spheres are not allowed to contain eachother");
        }
        this.r = Math.sqrt(s0.getRadiusSquared() - this.d0 * this.d0);
        if (Double.isNaN(this.r)) {
            throw new IllegalArgumentException("Lens is undefined unless the lens-spheres intersect");
        }
        Vector normal = s0.getCenter().vectorTo(s1.getCenter()).divideThis(d);
        Point center = s0.getCenter().add(normal.multiply(this.d0));
        this.equator = new Circle(center, this.r, normal);
        Vector x = new Vector(1.0, 0.001, 1.0E-4).crossThis(normal).normalizeThis();
        Vector y = normal.cross(x);
        this.plane = new ParametricPlane(center, x, y);
    }

    public double getRadius() {
        return this.r;
    }

    public double getFocalDistance(int i) {
        if (i == 0) {
            return this.d0;
        }
        return this.d1;
    }

    public double getSphereRadius(int i) {
        if (i == 0) {
            return this.s0.getRadius();
        }
        return this.s1.getRadius();
    }

    public Point getSphereCenter(int i) {
        if (i == 0) {
            return this.s0.getCenter().clone();
        }
        return this.s1.getCenter().clone();
    }

    @Override
    public Point getCenter() {
        double dSq = this.s0.getCenter().distanceSquared(this.s1.getCenter());
        double d0p = (dSq - this.s1.getRadius() * this.s1.getRadius() + this.s0.getRadius() * this.s0.getRadius()) / (2.0 * dSq);
        return this.s0.getCenter().add(this.s0.getCenter().vectorTo(this.s1.getCenter()).multiplyThis(d0p));
    }

    @Override
    public boolean overlaps(Volume vol) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getVolume() {
        double R = this.s0.getRadius();
        double r = this.s1.getRadius();
        double dSq = this.s0.getCenter().distanceSquared(this.s1.getCenter());
        double d = Math.sqrt(dSq);
        return Math.PI * (R + r - d) * (R + r - d) * (dSq + (2.0 * d - 3.0 * r) * r + (2.0 * d + 6.0 * r - 3.0 * R) * R) / 12.0 * d;
    }

    @Override
    public Lens clone() {
        return new Lens(this.s0.clone(), this.s1.clone());
    }

    public double distance(Point p) {
        Vector cp = this.equator.getCenter().vectorTo(p);
        if (cp.dot(this.equator.getNormal()) > 0.0) {
            Vector a0p = this.s0.center.vectorTo(p);
            double a0pDist = a0p.length();
            if (a0pDist < this.s0.radius) {
                return 0.0;
            }
            double a0Theta = Math.atan(this.r / this.d0);
            double a0Angle = a0p.angle(this.equator.getNormal());
            if (a0Angle <= a0Theta) {
                return a0pDist - this.s0.radius;
            }
            return this.discDistance(p);
        }
        Vector a1p = this.s1.center.vectorTo(p);
        double a1pDist = a1p.length();
        double a1Theta = Math.atan(this.r / this.d1);
        double a1Angle = Math.PI - a1p.angle(this.equator.getNormal());
        if (a1Angle <= a1Theta) {
            return a1pDist - this.s1.radius;
        }
        return this.discDistance(p);
    }

    private double discDistance(Point p) {
        double rSq;
        double[] xyz = this.plane.projectPoint(p);
        double xySq = xyz[0] * xyz[0] + xyz[1] * xyz[1];
        if (xySq <= (rSq = this.equator.getRadius() * this.equator.getRadius())) {
            return xyz[2];
        }
        return Math.sqrt(xySq + xyz[2] * xyz[2] + rSq - 2.0 * this.equator.getRadius() * Math.sqrt(xySq));
    }

    private Point getCirclePoint(double s) {
        return this.equator.getCenter().add(this.plane.v1.multiply(Math.cos(s) * this.getRadius()).addThis(this.plane.v2.multiply(Math.sin(s) * this.getRadius())));
    }

    public double distance(Lens l) {
        Point tmpMinus;
        Point tmpPlus;
        double delta;
        Vector a0b0 = this.s0.center.vectorTo(l.s0.center).normalizeThis();
        Vector a0b1 = this.s0.center.vectorTo(l.s1.center).normalizeThis();
        Vector a1b0 = this.s1.center.vectorTo(l.s0.center).normalizeThis();
        Vector a1b1 = this.s1.center.vectorTo(l.s1.center).normalizeThis();
        double a0b0Angle = a0b0.angle(this.equator.getNormal());
        double a0b1Angle = a0b1.angle(this.equator.getNormal());
        double a1b0Angle = Math.PI - a1b0.angle(this.equator.getNormal());
        double a1b1Angle = Math.PI - a1b1.angle(this.equator.getNormal());
        double b0a0Angle = Math.PI - a0b0.angle(l.equator.getNormal());
        double b0a1Angle = Math.PI - a1b0.angle(l.equator.getNormal());
        double b1a0Angle = a0b1.angle(l.equator.getNormal());
        double b1a1Angle = a1b1.angle(l.equator.getNormal());
        double a0Theta = Math.atan(this.r / this.d0);
        double a1Theta = Math.atan(this.r / this.d1);
        double b0Theta = Math.atan(l.r / l.d0);
        double b1Theta = Math.atan(l.r / l.d1);
        double a0b0Dist = Math.max(0.0, this.s0.center.distance(l.s0.center) - this.s0.radius - l.s0.radius);
        double a0b1Dist = Math.max(0.0, this.s0.center.distance(l.s1.center) - this.s0.radius - l.s1.radius);
        double a1b0Dist = Math.max(0.0, this.s1.center.distance(l.s0.center) - this.s1.radius - l.s0.radius);
        double a1b1Dist = Math.max(0.0, this.s1.center.distance(l.s1.center) - this.s1.radius - l.s1.radius);
        if (a0b0Angle <= a0Theta && b0a0Angle <= b0Theta) {
            return a0b0Dist;
        }
        if (a0b1Angle <= a0Theta && b1a0Angle <= b1Theta) {
            return a0b1Dist;
        }
        if (a1b0Angle <= a1Theta && b0a1Angle <= b0Theta) {
            return a1b0Dist;
        }
        if (a1b1Angle <= a1Theta && b1a1Angle <= b1Theta) {
            return a1b1Dist;
        }
        Point disc1Point = null;
        Point disc2Point = null;
        double scale = 0.5;
        double deltaRed = 0.5;
        double tmpPlusDist = Double.POSITIVE_INFINITY;
        double tmpMinusDist = 0.0;
        double s = 0.0;
        double t = 0.0;
        for (delta = Math.PI; delta > 0.001; delta *= deltaRed) {
            tmpPlus = this.getCirclePoint(s + delta / 100.0);
            tmpPlusDist = l.discDistance(tmpPlus);
            if (tmpPlusDist < (tmpMinusDist = l.discDistance(tmpMinus = this.getCirclePoint(s - delta / 100.0)))) {
                disc1Point = tmpPlus;
                s += delta * scale;
                continue;
            }
            disc1Point = tmpMinus;
            s -= delta * scale;
        }
        double sDist = Math.min(tmpPlusDist, tmpMinusDist);
        if (sDist < 1.0E-4) {
            return 0.0;
        }
        for (delta = Math.PI; delta > 0.001; delta *= deltaRed) {
            tmpPlus = l.getCirclePoint(t + delta / 100.0);
            tmpPlusDist = this.discDistance(tmpPlus);
            if (tmpPlusDist < (tmpMinusDist = this.discDistance(tmpMinus = l.getCirclePoint(t - delta / 100.0)))) {
                disc2Point = tmpPlus;
                t += delta * scale;
                continue;
            }
            disc2Point = tmpMinus;
            t -= delta * scale;
        }
        double tDist = Math.min(tmpPlusDist, tmpMinusDist);
        if (tDist < 1.0E-4) {
            return 0.0;
        }
        Vector pApB = disc1Point.vectorTo(disc2Point);
        double pApBAngle = pApB.angle(this.equator.getNormal());
        if (pApBAngle < a0Theta) {
            return this.s0.center.distance(disc2Point) - this.s0.radius;
        }
        if (Math.PI - pApBAngle < a1Theta) {
            return this.s1.center.distance(disc2Point) - this.s1.radius;
        }
        pApBAngle = pApB.angle(l.equator.getNormal());
        if (pApBAngle < b0Theta) {
            return l.s0.center.distance(disc1Point) - l.s0.radius;
        }
        if (Math.PI - pApBAngle < b1Theta) {
            return l.s1.center.distance(disc1Point) - l.s1.radius;
        }
        return Math.min(sDist, tDist);
    }

    public static void main(String[] args) {
        Sphere a0 = new Sphere(new Point(0.0, 1.0, 0.0), Math.sqrt(2.0));
        Sphere a1 = new Sphere(new Point(2.0, 1.0, 0.0), Math.sqrt(2.0));
        Lens A = new Lens(a0, a1);
        Sphere b0 = new Sphere(new Point(2.0, 4.0, 0.0), Math.sqrt(2.0));
        Sphere b1 = new Sphere(new Point(6.0, 4.0, 0.0), Math.sqrt(10.0));
        Lens B = new Lens(b0, b1);
        System.out.println(A.distance(B));
    }
}

