/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geomNd;

import ProGAL.geomNd.Vector;
import ProGAL.math.Constants;
import ProGAL.math.Randomization;
import java.io.Serializable;
import java.util.Arrays;

public class Point
implements Serializable {
    private static final long serialVersionUID = -6776647998875885511L;
    protected final double[] coords;
    protected final int dim;

    public Point(Point p) {
        this.dim = p.coords.length;
        this.coords = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.coords[i] = p.coords[i];
        }
    }

    public Point(double[] coords) {
        this.coords = coords;
        this.dim = coords.length;
    }

    public Point(int dimensions) {
        this.coords = new double[dimensions];
        this.dim = dimensions;
    }

    public double get(int d) {
        return this.coords[d];
    }

    public double getCoord(int d) {
        return this.coords[d];
    }

    public double[] getCoords() {
        return this.coords;
    }

    public int getDimensions() {
        return this.dim;
    }

    public void set(int d, double v) {
        this.coords[d] = v;
    }

    public void setCoord(int d, double v) {
        this.coords[d] = v;
    }

    public void fill(double v) {
        Arrays.fill(this.coords, v);
    }

    public Point set(Point p) {
        for (int i = 0; i < Math.min(this.dim, p.dim); ++i) {
            this.coords[i] = p.coords[i];
        }
        return this;
    }

    public Point setCoord(Point p) {
        for (int i = 0; i < Math.min(this.dim, p.dim); ++i) {
            this.coords[i] = p.coords[i];
        }
        return this;
    }

    public Point add(Vector v) {
        return this.clone().addThis(v);
    }

    public Point addThis(Vector v) {
        for (int i = 0; i < Math.min(this.dim, v.dim); ++i) {
            int n = i;
            this.coords[n] = this.coords[n] + v.coords[i];
        }
        return this;
    }

    public Point multiplyThis(double s) {
        int d = 0;
        while (d < this.dim) {
            int n = d++;
            this.coords[n] = this.coords[n] * s;
        }
        return this;
    }

    public double distanceSquared(Point p) {
        assert (this.dim == p.dim) : "Dimensions don't match";
        double sum = 0.0;
        for (int d = 0; d < this.dim; ++d) {
            double delta = this.coords[d] - p.coords[d];
            sum += delta * delta;
        }
        return sum;
    }

    public double distanceSquared() {
        double sum = 0.0;
        for (int d = 0; d < this.dim; ++d) {
            sum += this.coords[d] * this.coords[d];
        }
        return sum;
    }

    public double distance(Point p) {
        return Math.sqrt(this.distanceSquared(p));
    }

    public double dot(Point p) {
        double sum = 0.0;
        for (int d = 0; d < this.dim; ++d) {
            sum += this.coords[d] * p.coords[d];
        }
        return sum;
    }

    public double distance() {
        return Math.sqrt(this.distanceSquared());
    }

    public static Point getMidpoint(Point p, Point q) {
        if (p.dim != q.dim) {
            throw new IllegalArgumentException("Dimension of points must match");
        }
        double[] coords = new double[p.dim];
        for (int d = 0; d < p.dim; ++d) {
            coords[d] = (p.coords[d] + q.coords[d]) / 2.0;
        }
        return new Point(coords);
    }

    public static boolean collinear(Point p1, Point p2, Point p3) {
        double a = Point.getAngle(p1, p2, p3);
        return Math.abs(a - Math.PI) < Constants.EPSILON || Math.abs(a) < Constants.EPSILON;
    }

    public static double getAngle(Point p1, Point p2, Point p3) {
        Vector v1 = p2.vectorTo(p1);
        Vector v2 = p2.vectorTo(p3);
        return Math.acos(v1.dot(v2) / Math.sqrt(v1.getLengthSquared() * v2.getLengthSquared()));
    }

    public double distanceSquaredXY() {
        return this.coords[0] * this.coords[0] + this.coords[1] * this.coords[1];
    }

    public double distanceXY() {
        return Math.sqrt(this.distanceSquaredXY());
    }

    public double polarAngleSinXY() {
        return this.coords[1] / Math.sqrt(this.coords[0] * this.coords[0] + this.coords[1] * this.coords[1]);
    }

    public double polarAngleCosXY() {
        return this.coords[0] / Math.sqrt(this.coords[0] * this.coords[0] + this.coords[1] * this.coords[1]);
    }

    public double polarAngleXY() {
        double angle = Math.acos(this.polarAngleCosXY());
        if (this.coords[1] < 0.0) {
            angle = Math.PI * 2 - angle;
        }
        return angle;
    }

    public static Point getRandomPoint(int d, double minCoord, double maxCoord) {
        Point ret = new Point(d);
        for (int i = 0; i < d; ++i) {
            ret.coords[i] = Randomization.randBetween(minCoord, maxCoord);
        }
        return ret;
    }

    public Vector vectorTo(Point p1) {
        double[] newCoords = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            newCoords[d] = p1.coords[d] - this.coords[d];
        }
        return new Vector(newCoords);
    }

    public Vector toVector() {
        return new Vector(this.coords);
    }

    public Point clone() {
        double[] newArr = new double[this.dim];
        for (int d = 0; d < this.dim; ++d) {
            newArr[d] = this.coords[d];
        }
        return new Point(newArr);
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        StringBuilder ret = new StringBuilder();
        ret.append("Point[");
        for (int d = 0; d < this.dim - 1; ++d) {
            ret.append(String.format("%." + dec + "f, ", this.coords[d]));
        }
        if (this.dim > 0) {
            ret.append(String.format("%." + dec + "f]", this.coords[this.dim - 1]));
        }
        return ret.toString();
    }

    public void toConsole() {
        this.toConsole(2);
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }
}

