/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Units;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.TrimDataSet;
import org.das2.qds.examples.Schemes;
import org.das2.util.LoggerManager;

public abstract class AbstractDataSet
implements QDataSet,
MutablePropertyDataSet {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset");
    boolean hasIndexedProperties = false;
    protected HashMap<String, Object> properties = new HashMap();
    private boolean immutable = false;

    @Override
    public abstract int rank();

    @Override
    public double value() {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public String svalue() {
        Units u = (Units)this.property("UNITS");
        if (u == null) {
            return String.valueOf(this.value());
        }
        return u.createDatum(this.value()).toString();
    }

    @Override
    public double value(int i0) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0, int i1) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0, int i1, int i2) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public Object property(String name) {
        return this.properties.get(name);
    }

    @Override
    public Object property(String name, int i) {
        Object r = null;
        if (this.hasIndexedProperties) {
            String pname = name + "__" + i;
            r = this.properties.get(pname);
        }
        if (r != null) {
            return r;
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.properties.get(name);
        }
        return null;
    }

    private static void checkPropertyType(String name, Object value) {
        switch (name) {
            case "DELTA_MINUS": 
            case "DELTA_PLUS": 
            case "BIN_MINUS": 
            case "BIN_PLUS": 
            case "WEIGHTS": {
                if (value != null && !(value instanceof QDataSet)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a QDataSet (%s)", name, value.toString()));
                }
                return;
            }
            case "DEPEND_0": 
            case "DEPEND_1": 
            case "DEPEND_2": 
            case "DEPEND_3": 
            case "BUNDLE_0": 
            case "BUNDLE_1": 
            case "BUNDLE_2": 
            case "BUNDLE_3": {
                if (value != null && !(value instanceof QDataSet)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a QDataSet (%s)", name, value.toString()));
                }
                return;
            }
            case "UNITS": {
                if (value != null && !(value instanceof Units)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a Unit (%s)", name, value.toString()));
                }
                return;
            }
            case "NAME": 
            case "LABEL": 
            case "TITLE": 
            case "FORMAT": 
            case "SCALE_TYPE": 
            case "METADATA_MODEL": 
            case "BINS_0": 
            case "BINS_1": {
                if (value != null && !(value instanceof String)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a String (%s)", name, value.toString()));
                }
                return;
            }
            case "VALID_MIN": 
            case "VALID_MAX": 
            case "TYPICAL_MIN": 
            case "TYPICAL_MAX": 
            case "FILL_VALUE": {
                if (value != null && !(value instanceof Number)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a Number (%s)", name, value.toString()));
                }
                return;
            }
            case "USER_PROPERTIES": 
            case "METADATA": {
                if (value != null && !(value instanceof Map)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a Map (%s)", name, value.toString()));
                }
                return;
            }
            case "QUBE": {
                if (value != null && !(value instanceof Boolean)) {
                    logger.warning(String.format("AbstractDataSet.checkPropertyType: %s is not a Boolean (%s)", name, value.toString()));
                }
                return;
            }
        }
    }

    @Override
    public void putProperty(String name, Object value) {
        this.checkImmutable();
        String propCheckName = name;
        int i__ = name.indexOf("__");
        if (i__ > -1) {
            this.hasIndexedProperties = true;
            propCheckName = name.substring(0, i__);
        }
        if (value != null) {
            AbstractDataSet.checkPropertyType(propCheckName, value);
        }
        if (name.startsWith("DEPEND_")) {
            if (name.equals("DEPEND_0") && value != null) {
                if (value instanceof QDataSet) {
                    QDataSet dep0 = (QDataSet)value;
                    if (this.rank() > 0 && dep0.length() != this.length()) {
                        if (Schemes.isPolyMesh(dep0)) {
                            int n = dep0.slice(1).length();
                            if (n != this.length()) {
                                logger.log(Level.WARNING, "DEPEND_0 PolyMesh has incorrect length, its length is {0} should be {1}", new Object[]{n, this.length()});
                            }
                        } else {
                            logger.log(Level.WARNING, "DEPEND_0 is incorrect length, its length is {0} should be {1}", new Object[]{dep0.length(), this.length()});
                        }
                    }
                    if (this == value) {
                        logger.log(Level.WARNING, "{0} is self-referential, causing infinite loop", name);
                        logger.log(Level.WARNING, "ignoring putProperty call");
                        return;
                    }
                } else if (value instanceof String) {
                    logger.warning("Use DEPENDNAME_0 instead of DEPEND_0");
                }
            } else if (name.equals("DEPEND_1") && value != null) {
                if (this.rank() <= 1) {
                    logger.warning("DEPEND_1 was set on dataset of rank 0 or rank 1.  Ignoring...");
                } else if (value instanceof QDataSet) {
                    QDataSet dep1 = (QDataSet)value;
                    if (this.rank() > 0 && this.length() > 0 && dep1.rank() == 1 && dep1.length() != this.length(0)) {
                        logger.log(Level.WARNING, "DEPEND_1 is incorrect length, its length is {0} should be {1}", new Object[]{dep1.length(), this.length(0)});
                    }
                } else if (value instanceof String) {
                    logger.warning("Use DEPENDNAME_1 instead of DEPEND_1");
                }
            }
            if (name.charAt(7) - 48 > 0 && value instanceof QDataSet && ((QDataSet)value).rank() > 1) {
                logger.log(Level.FINER, "high rank 2 {0} might imply this is not a QUBE.", name);
            }
        }
        this.properties.put(name, value);
    }

    @Override
    public void putProperty(String name, int index, Object value) {
        this.checkImmutable();
        this.hasIndexedProperties = true;
        this.properties.put(name + "__" + index, value);
    }

    @Override
    public void makeImmutable() {
        this.immutable = true;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    protected final void checkImmutable() {
        if (this.immutable) {
            throw new IllegalArgumentException("dataset has been marked as immutable");
        }
    }

    @Override
    public int length() {
        throw new IllegalArgumentException("rank error, rank 0 datasets have no length()");
    }

    @Override
    public int length(int i0) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public int length(int i0, int i1) {
        throw new IllegalArgumentException("rank error, expected " + this.rank());
    }

    @Override
    public int length(int i0, int i1, int i2) {
        throw new IllegalArgumentException("rank error, expected " + this.rank() + ", NAME=" + this.property("NAME"));
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        return null;
    }

    @Override
    public QDataSet slice(int i) {
        return new Slice0DataSet(this, i);
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new TrimDataSet(this, start, end);
    }

    public String toString() {
        return DataSetUtil.toString(this);
    }
}

