/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.Arrays;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class CdfSparseDataSet
extends AbstractDataSet {
    int rank;
    int length;
    int[] indexes;
    QDataSet[] dss;
    private int lastIndex;

    public CdfSparseDataSet(int rank, int length, QDataSet value) {
        if (rank < 1) {
            throw new IllegalArgumentException("rank must be 1 or more");
        }
        this.rank = rank;
        if (this.rank - 1 != value.rank()) {
            throw new IllegalArgumentException("value rank must be the same as the rank");
        }
        this.length = length;
        this.indexes = new int[]{0, length};
        this.dss = new QDataSet[]{value, null};
    }

    @Override
    public int rank() {
        return this.rank;
    }

    public synchronized void putValues(int i0, QDataSet ds) {
        int ll;
        if (this.isImmutable()) {
            throw new IllegalArgumentException("dataset has been made immutable");
        }
        if (ds == null && i0 < this.length) {
            throw new NullPointerException("putValues of null dataset ds");
        }
        if (ds instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)ds).isImmutable()) {
            ds = Ops.copy(ds);
        }
        if ((ll = this.indexes.length) < 2) {
            if (i0 != 0) {
                throw new IllegalArgumentException("first insert must have insertion index 0.");
            }
        } else if (i0 < this.indexes[ll - 2]) {
            throw new IllegalArgumentException("indexes must be inserted in order.");
        }
        this.indexes = Arrays.copyOf(this.indexes, ll + 1);
        this.indexes[ll - 1] = i0;
        this.indexes[ll] = this.length;
        this.dss = Arrays.copyOf(this.dss, ll + 1);
        this.dss[ll - 1] = ds;
        this.dss[ll] = null;
    }

    private synchronized int indexInternal(int i0) {
        if (this.lastIndex >= 0 && this.indexes[this.lastIndex] <= i0 && i0 < this.indexes[this.lastIndex + 1]) {
            return this.lastIndex;
        }
        int i = Arrays.binarySearch(this.indexes, i0);
        if (i < -1) {
            this.lastIndex = -i - 2;
        } else if (i > -1) {
            this.lastIndex = i;
        } else {
            throw new IllegalArgumentException("zeroth index must be specified.");
        }
        return this.lastIndex;
    }

    public int datasetCount() {
        return this.dss.length - 1;
    }

    public void setLength(int length) {
        if (this.isImmutable()) {
            throw new IllegalArgumentException("dataset has been made immutable");
        }
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int length(int i0) {
        int i = this.indexInternal(i0);
        return this.dss[i].length();
    }

    @Override
    public int length(int i0, int i1) {
        int i = this.indexInternal(i0);
        return this.dss[i].length(i1);
    }

    @Override
    public int length(int i0, int i1, int i2) {
        int i = this.indexInternal(i0);
        return this.dss[i].length(i1, i2);
    }

    @Override
    public double value(int i0) {
        int i = this.indexInternal(i0);
        return this.dss[i].value();
    }

    @Override
    public double value(int i0, int i1) {
        int i = this.indexInternal(i0);
        return this.dss[i].value(i1);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        int i = this.indexInternal(i0);
        return this.dss[i].value(i1, i2);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        int i = this.indexInternal(i0);
        return this.dss[i].value(i1, i2, i3);
    }

    @Override
    public QDataSet slice(int i0) {
        int i = this.indexInternal(i0);
        return this.dss[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QDataSet trim(int i0, int i1) {
        if (i0 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (i1 > this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (i0 > i1) {
            throw new IndexOutOfBoundsException();
        }
        int ii0 = this.indexInternal(i0);
        int ii1 = this.indexInternal(i1);
        CdfSparseDataSet result = new CdfSparseDataSet(this.rank, i1 - i0, this.dss[ii0]);
        CdfSparseDataSet cdfSparseDataSet = this;
        synchronized (cdfSparseDataSet) {
            if (ii0 > 0) {
                result.putValues(0, this.dss[ii0]);
            }
            for (int ii = ii0 + 1; ii <= ii1; ++ii) {
                result.putValues(this.indexes[ii] - i0, this.dss[ii]);
            }
        }
        DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(this, null), result);
        return result;
    }
}

