/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import org.das2.qds.QDataSet;

public final class ConstantDataSet
implements QDataSet {
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    double value;

    public ConstantDataSet(int len, double value) {
        this(1, len, 1, 1, 1, value);
    }

    public static ConstantDataSet create(double value, int[] qube) {
        switch (qube.length) {
            case 0: {
                return new ConstantDataSet(0, 1, 1, 1, 1, value);
            }
            case 1: {
                return new ConstantDataSet(1, qube[0], 1, 1, 1, value);
            }
            case 2: {
                return new ConstantDataSet(2, qube[0], qube[1], 1, 1, value);
            }
            case 3: {
                return new ConstantDataSet(3, qube[0], qube[1], qube[2], 1, value);
            }
            case 4: {
                return new ConstantDataSet(4, qube[0], qube[1], qube[2], qube[3], value);
            }
        }
        throw new IllegalArgumentException("unsupported rank: " + qube.length);
    }

    private ConstantDataSet(int rank, int len0, int len1, int len2, int len3, double value) {
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        this.value = value;
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public String svalue() {
        return String.valueOf(this.value);
    }

    @Override
    public double value(int i0) {
        return this.value;
    }

    @Override
    public double value(int i0, int i1) {
        return this.value;
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.value;
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.value;
    }

    @Override
    public Object property(String name) {
        return null;
    }

    @Override
    public Object property(String name, int i) {
        return null;
    }

    @Override
    public int length() {
        return this.len0;
    }

    @Override
    public int length(int i) {
        return this.len1;
    }

    @Override
    public int length(int i, int j) {
        return this.len2;
    }

    @Override
    public int length(int i, int j, int k) {
        return this.len3;
    }

    @Override
    public QDataSet slice(int i) {
        return new ConstantDataSet(this.rank - 1, this.len1, this.len2, this.len3, 1, this.value);
    }

    @Override
    public QDataSet trim(int start, int end) {
        return new ConstantDataSet(this.rank - 1, end - start, this.len1, this.len2, this.len3, this.value);
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        return null;
    }
}

