/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.lang.reflect.Array;
import java.util.Map;
import org.das2.datum.Units;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;

public final class DDataSet
extends ArrayDataSet {
    double[] back;
    private static final boolean RANGE_CHECK = "true".equals(System.getProperty("rangeChecking", "true"));
    public static final String version = "20150219";

    public static DDataSet createRank0() {
        return new DDataSet(0, 1, 1, 1, 1);
    }

    public static DDataSet createRank1(int len0) {
        return new DDataSet(1, len0, 1, 1, 1);
    }

    public static DDataSet createRank2(int len0, int len1) {
        return new DDataSet(2, len0, len1, 1, 1);
    }

    public static DDataSet createRank3(int len0, int len1, int len2) {
        return new DDataSet(3, len0, len1, len2, 1);
    }

    public static DDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new DDataSet(4, len0, len1, len2, len3);
    }

    public static DDataSet create(int[] qube) {
        switch (qube.length) {
            case 0: {
                return new DDataSet(0, 1, 1, 1, 1);
            }
            case 1: {
                return DDataSet.createRank1(qube[0]);
            }
            case 2: {
                return DDataSet.createRank2(qube[0], qube[1]);
            }
            case 3: {
                return DDataSet.createRank3(qube[0], qube[1], qube[2]);
            }
            case 4: {
                return DDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
            }
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static DDataSet createRank1Bins(double min, double max, Units u) {
        DDataSet result = new DDataSet(1, 2, 1, 1, 1);
        if (u != null) {
            result.putProperty("UNITS", u);
        }
        result.putValue(0, min);
        result.putValue(1, max);
        result.putProperty("BINS_0", "min,max");
        return result;
    }

    public static DDataSet wrap(double[] data, int[] qube) {
        switch (qube.length) {
            case 1: {
                return new DDataSet(1, qube[0], 1, 1, 1, data);
            }
            case 2: {
                return new DDataSet(2, qube[0], qube[1], 1, 1, data);
            }
            case 3: {
                return new DDataSet(3, qube[0], qube[1], qube[2], 1, data);
            }
            case 4: {
                return new DDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
            }
            case 0: {
                return new DDataSet(0, 1, 1, 1, 1, data);
            }
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static DDataSet wrap(double[] back, int rank, int len0, int len1, int len2) {
        return new DDataSet(rank, len0, len1, len2, 1, back);
    }

    protected DDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new double[len0 * len1 * len2 * len3]);
    }

    protected DDataSet(int rank, int len0, int len1, int len2, int len3, double[] back) {
        super(Double.TYPE);
        if (back == null) {
            throw new NullPointerException("back was null");
        }
        this.back = back;
        if (rank < 0) {
            throw new IllegalArgumentException("rank was -1");
        }
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        if (this.back.length < len0 * len1 * len2 * len3) {
            logger.warning("backing array appears to be too short");
        }
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    protected Object getBack() {
        this.checkImmutable();
        return this.back;
    }

    @Override
    protected Object getBackReadOnly() {
        return this.back;
    }

    @Override
    protected int getBackJvmMemory() {
        return this.back.length * 8;
    }

    @Override
    protected Object getBackCopy() {
        Object newback = Array.newInstance(this.back.getClass().getComponentType(), this.back.length);
        System.arraycopy(this.back, 0, newback, 0, this.back.length);
        return newback;
    }

    @Override
    protected void setBack(Object back) {
        this.checkImmutable();
        this.back = (double[])back;
    }

    @Override
    public double value() {
        if (RANGE_CHECK && this.rank != 0) {
            throw new IllegalArgumentException("rank 0 access on rank " + this.rank + " dataset");
        }
        return this.back[0];
    }

    @Override
    public double value(int i0) {
        if (RANGE_CHECK) {
            if (this.rank != 1) {
                throw new IllegalArgumentException("rank 1 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
        }
        return this.back[i0];
    }

    @Override
    public double value(int i0, int i1) {
        if (RANGE_CHECK) {
            if (this.rank != 2) {
                throw new IllegalArgumentException("rank 2 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
        }
        return this.back[i0 * this.len1 + i1];
    }

    @Override
    public double value(int i0, int i1, int i2) {
        if (RANGE_CHECK) {
            if (this.rank != 3) {
                throw new IllegalArgumentException("rank 3 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
        }
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        if (RANGE_CHECK) {
            if (this.rank != 4) {
                throw new IllegalArgumentException("rank 4 access on rank " + this.rank + " dataset");
            }
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
            if (i3 < 0 || i3 >= this.len3) {
                throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
            }
        }
        return this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3];
    }

    @Override
    public void putValue(double value) {
        this.checkImmutable();
        if (this.rank != 0) {
            throw new IllegalArgumentException("rank 0 putValue called on dataset that is rank " + this.rank + ".");
        }
        this.back[0] = value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.checkImmutable();
        if (RANGE_CHECK && (i0 < 0 || i0 >= this.len0)) {
            throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
        }
        this.back[i0] = value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        if (RANGE_CHECK) {
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
        }
        this.back[i0 * this.len1 + i1] = value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.checkImmutable();
        if (RANGE_CHECK) {
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
        }
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.checkImmutable();
        if (RANGE_CHECK) {
            if (i0 < 0 || i0 >= this.len0) {
                throw new IndexOutOfBoundsException("i0=" + i0 + " " + this);
            }
            if (i1 < 0 || i1 >= this.len1) {
                throw new IndexOutOfBoundsException("i1=" + i1 + " " + this);
            }
            if (i2 < 0 || i2 >= this.len2) {
                throw new IndexOutOfBoundsException("i2=" + i2 + " " + this);
            }
            if (i3 < 0 || i3 >= this.len3) {
                throw new IndexOutOfBoundsException("i3=" + i3 + " " + this);
            }
        }
        this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3] = value;
    }

    public void addValue(int i0, double value) {
        this.checkImmutable();
        int n = i0;
        this.back[n] = this.back[n] + value;
    }

    public void addValue(int i0, int i1, double value) {
        if (value != 0.0) {
            this.checkImmutable();
            int n = i0 * this.len1 + i1;
            this.back[n] = this.back[n] + value;
        }
    }

    public void addValue(int i0, int i1, int i2, double value) {
        this.checkImmutable();
        int n = i0 * this.len1 * this.len2 + i1 * this.len2 + i2;
        this.back[n] = this.back[n] + value;
    }

    public void addValues(QDataSet ds, QDataSet wds) {
        this.checkImmutable();
        if (wds == null) {
            wds = Ops.valid(ds);
        }
        switch (this.rank) {
            case 1: {
                for (int i0 = 0; i0 < this.len0; ++i0) {
                    double w = wds.value(i0);
                    if (!(w > 0.0)) continue;
                    int n = i0;
                    this.back[n] = this.back[n] + ds.value(i0) * w;
                }
                break;
            }
            case 2: {
                for (int i0 = 0; i0 < this.len0; ++i0) {
                    for (int i1 = 0; i1 < this.len1; ++i1) {
                        double w = wds.value(i0, i1);
                        if (!(w > 0.0)) continue;
                        int n = i0 * this.len1 + i1;
                        this.back[n] = this.back[n] + ds.value(i0, i1) * w;
                    }
                }
                break;
            }
            case 3: {
                for (int i0 = 0; i0 < this.len0; ++i0) {
                    for (int i1 = 0; i1 < this.len1; ++i1) {
                        for (int i2 = 0; i2 < this.len2; ++i2) {
                            double w = wds.value(i0, i1, i2);
                            if (!(w > 0.0)) continue;
                            int n = i0 * this.len1 * this.len2 + i1 * this.len2 + i2;
                            this.back[n] = this.back[n] + ds.value(i0, i1, i2) * w;
                        }
                    }
                }
                break;
            }
            case 4: {
                for (int i0 = 0; i0 < this.len0; ++i0) {
                    for (int i1 = 0; i1 < this.len1; ++i1) {
                        for (int i2 = 0; i2 < this.len2; ++i2) {
                            for (int i3 = 0; i3 < this.len3; ++i3) {
                                double w = wds.value(i0, i1, i2, i3);
                                if (!(w > 0.0)) continue;
                                int n = i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3;
                                this.back[n] = this.back[n] + ds.value(i0, i1, i2, i3) * w;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("rank exception");
            }
        }
    }

    public void accumValue(int i0, double value) {
        this.addValue(i0, value);
    }

    public void accumValue(int i0, int i1, double value) {
        this.addValue(i0, i1, value);
    }

    public static DDataSet wrap(double[] back) {
        return new DDataSet(1, back.length, 1, 1, 1, back);
    }

    public static DDataSet wrap(double[] back, int nx, int ny) {
        return new DDataSet(2, nx, ny, 1, 1, back);
    }

    public static DDataSet wrap(double[] back, int rank, int len0, int len1, int len2, int len3) {
        return new DDataSet(rank, len0, len1, len2, len3, back);
    }

    public static DDataSet wrap(double[] xx, Units xunits) {
        DDataSet result = DDataSet.wrap(xx);
        result.putProperty("UNITS", xunits);
        return result;
    }

    public static DDataSet wrapRank2(double[] back, int n1) {
        return new DDataSet(2, back.length / n1, n1, 1, 1, back);
    }

    public static DDataSet wrapRank3(double[] back, int n1, int n2) {
        return new DDataSet(3, back.length / (n1 * n2), n1, n2, 1, back);
    }

    public static void copyElements(DDataSet src, int srcpos, DDataSet dest, int destpos, int nrec) {
        if (src.len1 != dest.len1 || src.len2 != dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        DDataSet.copyElements(src, srcpos, dest, destpos, nrec * src.len1 * src.len2 * src.len3, false);
    }

    public static void copyElements(DDataSet src, int srcpos, DDataSet dest, int destpos, int len, boolean checkAlias) {
        if (checkAlias && src.len1 * src.len2 * src.len3 != dest.len1 * dest.len2 * dest.len3) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        int srcpos1 = srcpos * src.len1 * src.len2 * src.len3;
        int destpos1 = destpos * dest.len1 * dest.len2 * dest.len3;
        int len1 = len;
        System.arraycopy(src.back, srcpos1, dest.back, destpos1, len1);
    }

    @Override
    public QDataSet slice(int i) {
        if (this.rank < 1) {
            throw new IllegalArgumentException("slice called on rank 0 dataset");
        }
        if (this.len0 <= i) {
            throw new IndexOutOfBoundsException("out of bounds in slice of len0=" + this.len0 + " dataset: " + i);
        }
        int nrank = this.rank - 1;
        int noff1 = i * this.len1 * this.len2 * this.len3;
        int noff2 = (i + 1) * this.len1 * this.len2 * this.len3;
        double[] newback = new double[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        DDataSet result = new DDataSet(nrank, this.len1, this.len2, this.len3, 1, newback);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (this.rank == 0) {
            throw new IllegalArgumentException("trim called on rank 0 dataset");
        }
        if (start == 0 && end == this.len0) {
            return this;
        }
        if (RANGE_CHECK) {
            if (start > 0 && this.len0 == 0) {
                throw new IndexOutOfBoundsException("start>0 on a length=0 dataset");
            }
            if (start > this.len0) {
                throw new IndexOutOfBoundsException("start=" + start + " > " + this.len0);
            }
            if (start < 0) {
                throw new IndexOutOfBoundsException("start=" + start + " < 0");
            }
            if (end > this.len0) {
                throw new IndexOutOfBoundsException("end=" + end + " > " + this.len0);
            }
            if (end < 0) {
                throw new IndexOutOfBoundsException("end=" + end + " < 0");
            }
            if (start > end) {
                throw new IllegalArgumentException("trim called with start>end: " + start + ">" + end);
            }
        }
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        double[] newback = new double[noff2 - noff1];
        if (noff2 - noff1 > 0) {
            System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        }
        DDataSet result = new DDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        Map<String, Object> depProps = DataSetUtil.trimProperties(this, start, end);
        props.putAll(depProps);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            if (this.isImmutable()) {
                return null;
            }
            return (T)this;
        }
        return super.capability(clazz);
    }
}

