/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.das2.qds.QDataSet;

public class DataSetAnnotations {
    private static final DataSetAnnotations instance = new DataSetAnnotations();
    public static final Integer VALUE_0 = 0;
    public static final Integer VALUE_1 = 1;
    private final WeakHashMap<QDataSet, Map<String, Object>> annotations = new WeakHashMap();
    private static final boolean hitTracking = true;
    private final WeakHashMap<QDataSet, Map<String, Integer>> hits = new WeakHashMap();
    public static final String ANNOTATION_INVALID_COUNT = "invalidCount";
    public static final String ANNOTATION_ZERO_COUNT = "zeroCount";
    public static final String ANNOTATION_BOUNDS = "bounds";
    public static final String ANNOTATION_CADENCE = "cadence";
    public static final String ANNOTATION_QUBE = "qube";

    public static DataSetAnnotations getInstance() {
        return instance;
    }

    public synchronized Object getAnnotation(QDataSet ds, String annotation) {
        Integer h;
        Map<String, Object> anno = this.annotations.get(ds);
        if (anno == null) {
            return null;
        }
        Map<String, Integer> hit = this.hits.get(ds);
        if (hit == null) {
            hit = new HashMap<String, Integer>();
            this.hits.put(ds, hit);
        }
        if ((h = hit.get(annotation)) == null) {
            hit.put(annotation, 1);
        } else {
            hit.put(annotation, 1 + h);
        }
        return anno.get(annotation);
    }

    public synchronized void putAnnotation(QDataSet ds, String annotation, Object value) {
        Map<String, Object> anno = this.annotations.get(ds);
        if (anno == null) {
            anno = new HashMap<String, Object>();
        }
        anno.put(annotation, value);
        this.annotations.put(ds, anno);
    }

    public synchronized void peek() {
        for (Map.Entry<QDataSet, Map<String, Object>> ent : this.annotations.entrySet()) {
            System.err.println("\n---" + ent.getKey() + "---");
            Map<String, Integer> hits1 = null;
            hits1 = this.hits.get(ent.getKey());
            for (Map.Entry<String, Object> ent1 : ent.getValue().entrySet()) {
                Integer h;
                String ss = "";
                ss = hits1 != null ? ((h = hits1.get(ent1.getKey())) != null ? h.toString() : "0") : "??";
                System.err.println("" + ent1.getKey() + "->" + ent1.getValue() + "  " + ss);
            }
        }
    }

    public synchronized void reset() {
        this.annotations.clear();
        this.hits.clear();
    }
}

