/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.Map;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public class LeafTrimDataSet
extends AbstractDataSet {
    final QDataSet ds;
    final int start;
    final int end;

    public LeafTrimDataSet(QDataSet source, int start, int end) {
        Object o;
        int i;
        String bundleNName;
        QDataSet bds;
        if (source.rank() == 0) {
            throw new IllegalArgumentException("source is rank 0");
        }
        this.ds = source;
        this.start = start;
        this.end = end;
        int len = 0;
        if (this.ds.rank() == 1) {
            len = this.ds.length();
        } else if (this.ds.rank() == 2) {
            len = this.ds.length(0);
        } else if (this.ds.rank() == 3) {
            len = this.ds.length(0, 0);
        } else if (this.ds.rank() == 4) {
            len = this.ds.length(0, 0, 0);
        } else {
            throw new IllegalArgumentException("rank exception");
        }
        if (end > len) {
            throw new IndexOutOfBoundsException("end is greater than last dimension length");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("start is less than 0");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start is greater than end");
        }
        String depNName = "DEPEND_" + (this.ds.rank() - 1);
        QDataSet depN = (QDataSet)this.ds.property(depNName);
        if (depN != null) {
            if (depN.rank() == 2) {
                depN = new LeafTrimDataSet(depN, start, end);
                this.properties.put(depNName, depN);
            } else {
                depN = depN.trim(start, end);
                this.properties.put(depNName, depN);
            }
        }
        if ((bds = (QDataSet)this.ds.property(bundleNName = "BUNDLE_" + (this.ds.rank() - 1))) != null) {
            bds = bds.trim(start, end);
            this.properties.put(bundleNName, bds);
        }
        for (i = 0; i < this.ds.rank() - 1; ++i) {
            o = this.ds.property("DEPEND_" + i);
            if (o == null) continue;
            this.properties.put("DEPEND_" + i, o);
        }
        for (i = 0; i < this.ds.rank() - 1; ++i) {
            o = this.ds.property("BUNDLE_" + i);
            if (o == null) continue;
            this.properties.put("BUNDLE_" + i, o);
        }
        for (i = 0; i < this.ds.rank() - 1; ++i) {
            o = this.ds.property("BINS_" + i);
            if (o == null) continue;
            this.properties.put("BINS_" + i, o);
        }
    }

    @Override
    public int rank() {
        return this.ds.rank();
    }

    @Override
    public double value(int i) {
        return this.ds.value(i + this.start);
    }

    @Override
    public double value(int i0, int i1) {
        return this.ds.value(i0, i1 + this.start);
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, i1, i2 + this.start);
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.ds.value(i0, i1, i2, i3 + this.start);
    }

    @Override
    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    @Override
    public Object property(String name, int i) {
        if (DataSetUtil.isInheritedProperty(name) && this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.ds.rank() == 1 ? this.ds.property(name, i - this.start) : this.ds.property(name, i);
    }

    @Override
    public int length() {
        return this.ds.rank() == 1 ? this.end - this.start : this.ds.length();
    }

    @Override
    public int length(int i) {
        return this.ds.rank() == 2 ? this.end - this.start : this.ds.length(i);
    }

    @Override
    public int length(int i, int j) {
        return this.ds.rank() == 3 ? this.end - this.start : this.ds.length(i, j);
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.ds.rank() == 4 ? this.end - this.start : this.ds.length(i0, i1, i2);
    }

    @Override
    public QDataSet slice(int i) {
        if (this.rank() == 1) {
            return this.ds.slice(i + this.start);
        }
        LeafTrimDataSet result = new LeafTrimDataSet(this.ds.slice(i), this.start, this.end);
        DataSetUtil.copyDimensionProperties(this, result);
        Map<String, Object> ps = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        ps = DataSetUtil.sliceProperties(this.ds, i, ps);
        DataSetUtil.putProperties(ps, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        if (this.rank() == 1) {
            return this.ds.trim(this.start + start, this.start + end);
        }
        LeafTrimDataSet result = new LeafTrimDataSet(this.ds.trim(start, end), this.start, this.end);
        for (int i = 1; i < this.rank(); ++i) {
            String s;
            String pname = "DEPEND_" + i;
            QDataSet dds = (QDataSet)this.property(pname);
            if (dds != null) {
                result.putProperty(pname, dds);
            }
            if ((dds = (QDataSet)this.property(pname = "BUNDLE_" + i)) != null) {
                result.putProperty(pname, dds);
            }
            if ((s = (String)this.property(pname = "BINS_" + i)) == null) continue;
            result.putProperty(pname, s);
        }
        DataSetUtil.copyDimensionProperties(this, result);
        return result;
    }
}

