/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetIterator;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public final class QubeDataSetIterator
implements DataSetIterator {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.iterator");
    private DimensionIterator[] it;
    private DimensionIteratorFactory[] fit;
    private boolean isAllIndexLists;
    private int rank;
    private int[] qube;
    private QDataSet ds;
    private boolean[] initialNext;
    private boolean allnext = true;
    private ProgressMonitor monitor;
    private boolean debugMe = false;

    public static String currentJythonLine() {
        StackTraceElement[] sts = new Exception().getStackTrace();
        for (int i = 0; i < sts.length; ++i) {
            if (!sts[i].getClassName().startsWith("org.python.pycode")) continue;
            return sts[i].getFileName() + ":" + sts[i].getLineNumber();
        }
        return "???";
    }

    public static void checkValidIndexList(QDataSet ds, int indexSize) {
        Number max;
        if (indexSize > -1 && (max = (Number)ds.property("VALID_MAX")) != null && max.intValue() != indexSize) {
            String jythonLine = QubeDataSetIterator.currentJythonLine();
            if (jythonLine.equals("???")) {
                if (max instanceof Integer || max instanceof Long) {
                    logger.log(Level.WARNING, "rfe737: index list appears to be for dimensions of length {0} (see VALID_MAX) but is indexing dimension length {1}, which may indicate there''s a bug.", new Object[]{max, indexSize});
                } else if (!(max.doubleValue() > 1.0E100)) {
                    logger.log(Level.WARNING, "rfe737: VALID_MAX is not an integer but data is used as an index list, which may indicate there''s a bug.", new Object[]{max, indexSize});
                }
            } else {
                logger.log(Level.WARNING, "rfe737: index list appears to be for dimensions of length {0} (see VALID_MAX) but is indexing dimension length {1}, which may indicate there''s a bug at {2}.", new Object[]{max, indexSize, jythonLine});
            }
        }
        int n = Math.min(ds.length(), 100);
        for (int i = 0; i < n; ++i) {
            double v = ds.value(i);
            if (v == Math.floor(v)) continue;
            String jythonLine = QubeDataSetIterator.currentJythonLine();
            if (jythonLine.equals("???")) {
                logger.warning("rfe737: indices should be integers, which might indicate there's a bug");
                break;
            }
            logger.log(Level.WARNING, "rfe737: indices should be integers, which might indicate there''s a bug at {0}", jythonLine);
            break;
        }
    }

    public QubeDataSetIterator(QDataSet ds) {
        logger.log(Level.FINE, "new dataset iterator for {0}", ds);
        ArrayList<String> problems = new ArrayList<String>();
        if (!DataSetUtil.validate(ds, problems)) {
            throw new IllegalArgumentException("data doesn't validate: " + problems);
        }
        this.rank = ds.rank();
        this.it = new DimensionIterator[this.rank];
        this.fit = new DimensionIteratorFactory[this.rank];
        if (DataSetUtil.isQube(ds)) {
            this.qube = DataSetUtil.qubeDims(ds);
            this.ds = ds;
        } else {
            this.qube = null;
            this.ds = ds;
        }
        for (int i = 0; i < this.rank; ++i) {
            this.fit[i] = new StartStopStepIteratorFactory(0, null, 1);
        }
        this.initialize();
    }

    private QubeDataSetIterator(QDataSet ds, DimensionIteratorFactory[] fits) {
        if (Boolean.TRUE.equals(ds.property("QUBE"))) {
            this.qube = DataSetUtil.qubeDims(ds);
            this.ds = ds;
        } else {
            this.qube = null;
            this.ds = ds;
        }
        this.rank = ds.rank();
        this.ds = ds;
        this.fit = fits;
        this.it = new DimensionIterator[fits.length];
        this.initialize();
    }

    public void setMonitor(ProgressMonitor mon) {
        this.monitor = mon;
        this.monitor.setTaskSize(this.rank == 0 ? 1L : (long)this.dimLength(0));
        this.monitor.started();
    }

    public static QubeDataSetIterator sliceIterator(QDataSet ds, int sliceIndex) {
        QubeDataSetIterator result;
        switch (ds.rank()) {
            case 0: {
                throw new IllegalArgumentException("can't slice rank 0");
            }
            case 1: {
                throw new IllegalArgumentException("can't slice rank 1");
            }
            case 2: {
                result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1)});
                break;
            }
            case 3: {
                result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1), new StartStopStepIteratorFactory(0, null, 1)});
                break;
            }
            case 4: {
                result = new QubeDataSetIterator(ds, new DimensionIteratorFactory[]{new SingletonIteratorFactory(sliceIndex), new StartStopStepIteratorFactory(0, ds.length(sliceIndex), 1), new StartStopStepIteratorFactory(0, null, 1), new StartStopStepIteratorFactory(0, null, 1)});
                break;
            }
            default: {
                throw new IllegalArgumentException("rank limit");
            }
        }
        return result;
    }

    public void setIndexIteratorFactory(int dim, DimensionIteratorFactory fit) {
        IndexListIteratorFactory ffit;
        int max;
        if (dim >= this.rank) {
            throw new IllegalArgumentException(String.format("rank limit: rank %d dataset %s has no index %d", this.ds.rank(), this.ds, dim));
        }
        if (fit instanceof IndexListIteratorFactory && (max = (ffit = (IndexListIteratorFactory)fit).getMaxIndexExclusive()) > -1 && this.qube != null && this.qube[dim] != max) {
            if (this.qube[dim] - max == 1) {
                logger.log(Level.FINER, "rfe737: index list appears to be for dimensions of length {0} (see VALID_MAX) but is indexing dimension length {1}, I bet you know what you are doing...", new Object[]{max, this.qube[dim]});
            } else {
                String jythonLine = QubeDataSetIterator.currentJythonLine();
                if (jythonLine.equals("???")) {
                    logger.log(Level.WARNING, "rfe737: index list appears to be for dimensions of length {0} (see VALID_MAX) but is indexing dimension length {1}, which may indicate there''s a bug.", new Object[]{max, this.qube[dim]});
                } else {
                    logger.log(Level.WARNING, "rfe737: index list appears to be for dimensions of length {0} (see VALID_MAX) but is indexing dimension length {1}, which may indicate there''s a bug at {2}.", new Object[]{max, this.qube[dim], jythonLine});
                }
            }
        }
        this.fit[dim] = fit;
        this.initialize();
    }

    private void initialize() {
        int dimLength;
        int i;
        boolean allLi = true;
        boolean zeroLength = false;
        this.initialNext = new boolean[this.rank];
        if (this.rank > 0) {
            this.initialNext[this.rank - 1] = true;
        }
        for (i = 0; i < this.rank; ++i) {
            this.initialNext[i] = true;
            dimLength = this.dimLength(i);
            if (dimLength == 0) {
                zeroLength = true;
            }
            this.it[i] = this.fit[i].newIterator(dimLength);
            if (!(this.it[i] instanceof IndexListIterator)) {
                allLi = false;
            }
            if (i <= 0 || i >= this.rank - 1) continue;
            if (this.it[i].hasNext()) {
                this.it[i].nextIndex();
                this.initialNext[i] = false;
                continue;
            }
            zeroLength = true;
        }
        while (zeroLength && this.it[0].hasNext() && this.qube == null) {
            this.it[0].nextIndex();
            this.initialNext[0] = false;
            zeroLength = false;
            for (i = 1; i < this.rank; ++i) {
                dimLength = this.dimLength(i);
                if (dimLength == 0) {
                    zeroLength = true;
                }
                this.it[i] = this.fit[i].newIterator(dimLength);
                this.initialNext[i] = true;
                if (!(this.it[i] instanceof IndexListIterator)) {
                    allLi = false;
                }
                if (i >= this.rank - 1) continue;
                if (this.it[i].hasNext()) {
                    this.it[i].nextIndex();
                } else {
                    zeroLength = true;
                }
                this.initialNext[i] = false;
            }
        }
        this.isAllIndexLists = allLi;
    }

    private int dimLength(int idim) {
        if (this.qube != null) {
            return this.qube[idim];
        }
        int result = 0;
        switch (idim) {
            case 0: {
                result = this.ds.length();
                break;
            }
            case 1: {
                result = this.ds.length(Math.max(0, this.index(0)));
                break;
            }
            case 2: {
                result = this.ds.length(Math.max(0, this.index(0)), Math.max(0, this.index(1)));
                break;
            }
            case 3: {
                result = this.ds.length(Math.max(0, this.index(0)), Math.max(0, this.index(1)), Math.max(0, this.index(2)));
                break;
            }
            default: {
                throw new IllegalArgumentException("dimension not supported: " + idim);
            }
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        int i;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("---- hasNext ----");
            for (DimensionIterator it1 : this.it) {
                logger.log(Level.FINE, "hasNext: {0}  of {1}", new Object[]{it1, this.ds});
            }
        }
        if (this.rank == 0) {
            if (this.allnext) {
                return true;
            }
            if (this.monitor != null) {
                this.monitor.finished();
            }
            return false;
        }
        if (this.it[0].length() == 0) {
            if (this.monitor != null) {
                this.monitor.finished();
            }
            return false;
        }
        if (this.qube != null) {
            for (int i2 = 1; i2 < this.rank; ++i2) {
                if (this.it[i2].length() != 0) continue;
                if (this.monitor != null) {
                    this.monitor.finished();
                }
                return false;
            }
        }
        if (this.it[i = this.rank - 1].hasNext()) {
            return true;
        }
        if (i > 0) {
            for (int j = i - 1; j >= 0; --j) {
                if (!this.it[j].hasNext()) continue;
                if (this.qube != null) {
                    return true;
                }
                if (j == 0) {
                    QDataSet sliceDs;
                    int nslice;
                    int nextIndex = this.it[j].index();
                    while ((nslice = DataSetUtil.product(DataSetUtil.qubeDims(sliceDs = this.ds.slice(++nextIndex)))) == 0 && nextIndex < this.ds.length() - 1) {
                    }
                    return nslice > 0;
                }
                return true;
            }
        }
        if (this.monitor != null) {
            this.monitor.finished();
        }
        return false;
    }

    @Override
    public void next() {
        int i;
        if (this.allnext) {
            for (i = 0; i < this.rank - 1; ++i) {
                if (this.initialNext[i]) {
                    this.it[i].nextIndex();
                    this.initialNext[i] = false;
                }
                if (i != 0 || this.monitor == null) continue;
                this.monitor.setTaskProgress((long)this.it[0].index());
            }
            this.allnext = false;
            if (this.rank == 0) {
                return;
            }
        }
        if (this.it[i = this.rank - 1].hasNext()) {
            this.it[i].nextIndex();
            if (this.it[i] instanceof IndexListIterator) {
                for (int k = 0; k < i; ++k) {
                    if (!this.isAllIndexLists || !(this.it[k] instanceof IndexListIterator)) continue;
                    if (k == 0 && this.monitor != null) {
                        this.monitor.setTaskProgress((long)this.it[0].index());
                    }
                    if (((IndexListIterator)this.it[k]).listIndex >= ((IndexListIterator)this.it[i]).listIndex) continue;
                    this.it[k].nextIndex();
                }
            }
        } else {
            this.toString();
            if (this.debugMe) {
                boolean k = true;
            }
            boolean proceed = false;
            block2: while (!proceed && i > 0) {
                for (int j = i - 1; j >= 0; --j) {
                    int k;
                    boolean zeroLength;
                    if (this.it[j].hasNext()) {
                        this.it[j].nextIndex();
                        if (j == 0 && this.monitor != null) {
                            this.monitor.setTaskProgress((long)this.it[0].index());
                        }
                        if (this.it[j] instanceof IndexListIterator) {
                            for (int k2 = 0; k2 < j; ++k2) {
                                if (!this.isAllIndexLists || !(this.it[k2] instanceof IndexListIterator)) continue;
                                this.it[k2].nextIndex();
                            }
                        }
                        zeroLength = false;
                        for (k = j + 1; k <= i; ++k) {
                            this.it[k] = this.fit[k].newIterator(this.dimLength(k));
                            if (this.dimLength(k) == 0) {
                                zeroLength = true;
                            }
                            this.it[k].nextIndex();
                        }
                        if (zeroLength) continue;
                        proceed = true;
                        continue block2;
                    }
                    zeroLength = false;
                    if (j == 0 && this.qube == null) {
                        throw new IllegalArgumentException("no next index");
                    }
                    for (k = j + 1; k <= i; ++k) {
                        int nextDimLength = this.dimLength(k);
                        this.it[k] = this.fit[k].newIterator(nextDimLength);
                        if (nextDimLength == 0) {
                            zeroLength = true;
                        }
                        this.it[k].nextIndex();
                    }
                    if (zeroLength) continue block2;
                }
            }
            if (!proceed && this.qube == null) {
                throw new IllegalArgumentException("no more elements");
            }
        }
    }

    @Override
    public int index(int dim) {
        return this.it[dim].index();
    }

    @Override
    public int length(int dim) {
        return this.it[dim].length();
    }

    @Override
    public int rank() {
        int result = this.rank;
        for (DimensionIterator it1 : this.it) {
            if (!(it1 instanceof SingletonIterator)) continue;
            --result;
        }
        return result;
    }

    public String toString() {
        if (this.rank == 0) {
            return "Iter hasNext=" + this.hasNext();
        }
        StringBuilder its = new StringBuilder(this.it[0].toString());
        StringBuilder ats = new StringBuilder("" + this.it[0].index());
        for (int i = 1; i < this.rank; ++i) {
            its.append(",").append(this.it[i]);
            ats.append(",").append(this.it[i].index());
        }
        return "Iter [" + its + "] @ [" + ats + "] ";
    }

    @Override
    public DDataSet createEmptyDs() {
        int[] qube1;
        int i;
        ArrayList<Integer> qqube = new ArrayList<Integer>();
        ArrayList<Integer> dimMap = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.it.length; ++i2) {
            boolean reform;
            if (this.it[i2] == null || (reform = this.it[i2] instanceof SingletonIterator)) continue;
            qqube.add(this.it[i2].length());
            dimMap.add(i2);
        }
        if (this.isAllIndexLists) {
            int len = this.it[0].length();
            for (i = 1; i < this.it.length; ++i) {
                if (this.it[i].length() == len) continue;
                throw new IllegalArgumentException("all index lists must have the same length.  index 0 has " + len + " elements and index " + i + " has " + this.it[i].length() + " elements");
            }
            qube1 = new int[]{this.it[0].length()};
        } else {
            qube1 = new int[qqube.size()];
            for (int i3 = 0; i3 < qqube.size(); ++i3) {
                qube1[i3] = (Integer)qqube.get(i3);
            }
        }
        DDataSet result = DDataSet.create(qube1);
        for (i = 0; i < dimMap.size(); ++i) {
            QubeDataSetIterator itOut;
            DDataSet depNew;
            QubeDataSetIterator iter2;
            DimensionIterator ili;
            StartStopStepIterator sssi;
            DimensionIteratorFactory[] dif;
            Object sssi2;
            int idim = (Integer)dimMap.get(i);
            QDataSet dep = (QDataSet)this.ds.property("DEPEND_" + idim);
            QDataSet bund = (QDataSet)this.ds.property("BUNDLE_" + idim);
            String bins = (String)this.ds.property("BINS_" + idim);
            if (this.fit[idim] instanceof StartStopStepIteratorFactory) {
                if (dep != null && dep.rank() == 1) {
                    MutablePropertyDataSet depSlice;
                    sssi2 = (StartStopStepIterator)this.it[idim];
                    if (((StartStopStepIterator)sssi2).step == 1 && ((StartStopStepIterator)sssi2).start == 0 && ((StartStopStepIterator)sssi2).stop == dep.length()) {
                        result.putProperty("DEPEND_" + i, dep);
                    } else if (((StartStopStepIterator)sssi2).step == 1) {
                        result.putProperty("DEPEND_" + i, dep.trim(((StartStopStepIterator)sssi2).start, ((StartStopStepIterator)sssi2).stop));
                    } else if (((StartStopStepIterator)sssi2).step < 0) {
                        depSlice = DataSetOps.trim(dep, ((StartStopStepIterator)sssi2).start - dep.length(), ((StartStopStepIterator)sssi2).stop - dep.length(), ((StartStopStepIterator)sssi2).step);
                        result.putProperty("DEPEND_" + i, depSlice);
                    } else {
                        depSlice = DataSetOps.trim(dep, ((StartStopStepIterator)sssi2).start, ((StartStopStepIterator)sssi2).stop, ((StartStopStepIterator)sssi2).step);
                        result.putProperty("DEPEND_" + i, depSlice);
                    }
                } else if (dep != null && dep.rank() == 2) {
                    dif = new DimensionIteratorFactory[2];
                    if (this.it[0] instanceof StartStopStepIterator) {
                        sssi = (StartStopStepIterator)this.it[0];
                        dif[0] = new StartStopStepIteratorFactory(sssi.start, sssi.stop, sssi.step);
                    } else if (this.it[0] instanceof IndexListIterator) {
                        ili = (IndexListIterator)this.it[0];
                        dif[0] = new IndexListIteratorFactory(ili.ds);
                    } else if (this.it[0] instanceof SingletonIterator) {
                        ili = (SingletonIterator)this.it[0];
                        dif[0] = new SingletonIteratorFactory(((SingletonIterator)ili).index);
                    }
                    dif[1] = this.fit[idim];
                    iter2 = new QubeDataSetIterator(dep, dif);
                    depNew = iter2.createEmptyDs();
                    itOut = new QubeDataSetIterator(depNew);
                    while (iter2.hasNext()) {
                        iter2.next();
                        itOut.next();
                        itOut.putValue(depNew, iter2.getValue(dep));
                    }
                    result.putProperty("DEPEND_" + i, depNew);
                }
                if (bund != null) {
                    sssi2 = (StartStopStepIterator)this.it[idim];
                    if (((StartStopStepIterator)sssi2).step == 1 && ((StartStopStepIterator)sssi2).start == 0 && ((StartStopStepIterator)sssi2).stop == bund.length()) {
                        result.putProperty("BUNDLE_" + i, bund);
                    } else if (((StartStopStepIterator)sssi2).step == 1) {
                        result.putProperty("BUNDLE_" + i, bund.trim(((StartStopStepIterator)sssi2).start, ((StartStopStepIterator)sssi2).stop));
                    } else {
                        MutablePropertyDataSet bundSlice = DataSetOps.trim(bund, ((StartStopStepIterator)sssi2).start, ((StartStopStepIterator)sssi2).stop, ((StartStopStepIterator)sssi2).step);
                        result.putProperty("BUNDLE_" + i, bundSlice);
                    }
                }
                if (bins == null || this.it[idim].length() != bins.split(",").length) continue;
                result.putProperty("BINS_" + i, bins);
                continue;
            }
            if (!(this.fit[idim] instanceof IndexListIteratorFactory) || this.isAllIndexLists) continue;
            if (dep != null && dep.rank() == 2) {
                dif = new DimensionIteratorFactory[2];
                if (this.it[0] instanceof StartStopStepIterator) {
                    sssi = (StartStopStepIterator)this.it[0];
                    dif[0] = new StartStopStepIteratorFactory(sssi.start, sssi.stop, sssi.step);
                } else if (this.it[0] instanceof IndexListIterator) {
                    ili = (IndexListIterator)this.it[0];
                    dif[0] = new IndexListIteratorFactory(ili.ds);
                } else if (this.it[0] instanceof SingletonIterator) {
                    ili = (SingletonIterator)this.it[0];
                    dif[0] = new SingletonIteratorFactory(((SingletonIterator)ili).index);
                }
                dif[1] = this.fit[idim];
                iter2 = new QubeDataSetIterator(dep, dif);
                depNew = iter2.createEmptyDs();
                itOut = new QubeDataSetIterator(depNew);
                while (iter2.hasNext()) {
                    iter2.next();
                    itOut.next();
                    itOut.putValue(depNew, iter2.getValue(dep));
                }
                result.putProperty("DEPEND_" + i, depNew);
            } else if (dep != null) {
                sssi2 = (IndexListIteratorFactory)this.fit[idim];
                result.putProperty("DEPEND_" + i, DataSetOps.applyIndex(dep, 0, ((IndexListIteratorFactory)sssi2).getList(), false));
            }
            if (bund == null) continue;
            sssi2 = (IndexListIteratorFactory)this.fit[idim];
            result.putProperty("BUNDLE_" + i, DataSetOps.applyIndex(bund, 0, ((IndexListIteratorFactory)sssi2).getList(), false));
        }
        return result;
    }

    @Override
    public final double getValue(QDataSet ds) {
        switch (this.rank) {
            case 0: {
                return ds.value();
            }
            case 1: {
                return ds.value(this.index(0));
            }
            case 2: {
                return ds.value(this.index(0), this.index(1));
            }
            case 3: {
                return ds.value(this.index(0), this.index(1), this.index(2));
            }
            case 4: {
                return ds.value(this.index(0), this.index(1), this.index(2), this.index(3));
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    @Override
    public final QDataSet getRank0Value(QDataSet ds) {
        QDataSet result;
        if (DataSetUtil.isNotBundle(ds)) {
            double result2;
            switch (this.rank) {
                case 1: {
                    result2 = ds.value(this.index(0));
                    break;
                }
                case 2: {
                    result2 = ds.value(this.index(0), this.index(1));
                    break;
                }
                case 3: {
                    result2 = ds.value(this.index(0), this.index(1), this.index(2));
                    break;
                }
                case 4: {
                    result2 = ds.value(this.index(0), this.index(1), this.index(2), this.index(3));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("rank limit: " + this.rank + " is not supported");
                }
            }
            return DataSetUtil.asDataSet(result2, SemanticOps.getUnits(ds));
        }
        switch (this.rank) {
            case 1: {
                result = ds.slice(this.index(0));
                break;
            }
            case 2: {
                result = ds.slice(this.index(0)).slice(this.index(1));
                break;
            }
            case 3: {
                result = ds.slice(this.index(0)).slice(this.index(1)).slice(this.index(2));
                break;
            }
            case 4: {
                result = ds.slice(this.index(0)).slice(this.index(1)).slice(this.index(2)).slice(this.index(3));
                break;
            }
            default: {
                throw new IllegalArgumentException("rank limit: " + this.rank + " is not supported");
            }
        }
        return result;
    }

    @Override
    public final void putValue(WritableDataSet ds, double v) {
        switch (this.rank) {
            case 0: {
                ds.putValue(v);
                return;
            }
            case 1: {
                ds.putValue(this.index(0), v);
                return;
            }
            case 2: {
                ds.putValue(this.index(0), this.index(1), v);
                return;
            }
            case 3: {
                ds.putValue(this.index(0), this.index(1), this.index(2), v);
                return;
            }
            case 4: {
                ds.putValue(this.index(0), this.index(1), this.index(2), this.index(3), v);
                return;
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    @Override
    public void putRank0Value(WritableDataSet ds, QDataSet vds) {
        double v;
        QDataSet r0ds = this.getRank0Value(ds);
        Units uds = SemanticOps.getUnits(r0ds);
        Units uv = SemanticOps.getUnits(vds);
        try {
            UnitsConverter uc = uv.getConverter(uds);
            v = uc.convert(vds.value());
        }
        catch (InconvertibleUnitsException ex) {
            if (uds == Units.dimensionless || uv == Units.dimensionless) {
                v = vds.value();
            }
            throw ex;
        }
        this.putValue(ds, v);
    }

    public static class SingletonIteratorFactory
    implements DimensionIteratorFactory {
        int index;

        public SingletonIteratorFactory(int index) {
            this.index = index;
        }

        @Override
        public DimensionIterator newIterator(int length) {
            if (this.index < 0) {
                return new SingletonIterator(length + this.index);
            }
            return new SingletonIterator(this.index);
        }
    }

    public static class SingletonIterator
    implements DimensionIterator {
        int index;
        boolean hasNext = true;

        public SingletonIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int nextIndex() {
            this.hasNext = false;
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int length() {
            return 1;
        }

        public String toString() {
            return "" + this.index;
        }
    }

    public static class IndexListIteratorFactory
    implements DimensionIteratorFactory {
        QDataSet ds;

        public IndexListIteratorFactory(QDataSet ds) {
            if (ds.rank() == 0) {
                ds = Ops.join(null, ds);
            }
            this.ds = ds;
            if (ds.rank() != 1) {
                throw new IllegalArgumentException("list of indices dataset must be rank 1");
            }
            QubeDataSetIterator.checkValidIndexList(ds, -1);
        }

        @Override
        public DimensionIterator newIterator(int length) {
            ArrayDataSet list = ArrayDataSet.copy(this.ds);
            for (int i = 0; i < list.length(); ++i) {
                if (!(list.value(i) < 0.0)) continue;
                list.putValue(i, list.value(i) + (double)length);
            }
            return new IndexListIterator(list);
        }

        public QDataSet getList() {
            return this.ds;
        }

        private int getMaxIndexExclusive() {
            Number validMax = (Number)this.ds.property("VALID_MAX");
            if (validMax != null) {
                return validMax.intValue();
            }
            return -1;
        }
    }

    public static class IndexListIterator
    implements DimensionIterator {
        QDataSet ds;
        int listIndex;

        public IndexListIterator(QDataSet ds) {
            if (ds.rank() == 0) {
                ds = Ops.join(null, ds);
            }
            this.ds = ds;
            if (ds.rank() != 1) {
                throw new IllegalArgumentException("list of indices dataset must be rank 1");
            }
            this.listIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.listIndex + 1 < this.ds.length();
        }

        @Override
        public int nextIndex() {
            ++this.listIndex;
            return (int)this.ds.value(this.listIndex);
        }

        @Override
        public int index() {
            return (int)this.ds.value(this.listIndex);
        }

        @Override
        public int length() {
            return this.ds.length();
        }

        public String toString() {
            String dstr = this.ds.toString();
            dstr = dstr.replace("(dimensionless)", "");
            return "[" + dstr + " @ " + this.listIndex + "]";
        }
    }

    public static class StartStopStepIteratorFactory
    implements DimensionIteratorFactory {
        Number start;
        Number stop;
        Number step;

        public StartStopStepIteratorFactory(Number start, Number stop, Number step) {
            this.start = start;
            this.stop = stop;
            this.step = step;
        }

        @Override
        public DimensionIterator newIterator(int length) {
            int stop1;
            int dftStop;
            int dftStart;
            int step1;
            int n = step1 = this.step == null ? 1 : this.step.intValue();
            if (step1 >= 0) {
                dftStart = 0;
                dftStop = length;
            } else {
                dftStart = -1;
                dftStop = -1 - length;
            }
            int start1 = this.start == null ? dftStart : this.start.intValue();
            int n2 = stop1 = this.stop == null ? dftStop : this.stop.intValue();
            if (start1 < 0) {
                start1 = length + start1;
            }
            if (stop1 < 0) {
                stop1 = length + stop1;
            }
            return new StartStopStepIterator(start1, stop1, step1, this.start == null && this.stop == null && this.step == null);
        }
    }

    public static class StartStopStepIterator
    implements DimensionIterator {
        int start;
        int stop;
        int step;
        int index;
        boolean all;

        public StartStopStepIterator(int start, int stop, int step, boolean all) {
            this.start = start;
            this.stop = stop;
            this.step = step;
            this.index = start - step;
            this.all = all;
        }

        @Override
        public boolean hasNext() {
            if (this.step >= 0) {
                return this.index + this.step < this.stop;
            }
            return this.index + this.step > this.stop;
        }

        @Override
        public int nextIndex() {
            this.index += this.step;
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int length() {
            int remainder = (this.stop - this.start) % this.step;
            return (this.stop - this.start) / this.step + (remainder > 0 ? 1 : 0);
        }

        public String toString() {
            return this.all ? ":" : "" + this.start + ":" + this.stop + (this.step == 1 ? "" : ":" + this.step);
        }
    }

    public static interface DimensionIteratorFactory {
        public DimensionIterator newIterator(int var1);
    }

    public static interface DimensionIterator {
        public boolean hasNext();

        public int nextIndex();

        public int index();

        public int length();
    }
}

