/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds;

import java.util.Iterator;
import org.das2.datum.DatumRange;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class RecordIterator
implements Iterator<QDataSet> {
    QDataSet src;
    int index;
    int lastIndex;
    public static long TIME_STAMP = System.currentTimeMillis();

    public RecordIterator(QDataSet src) {
        if (src.rank() == 0) {
            throw new IllegalArgumentException("rank 0 dataset");
        }
        if (src.rank() > 2) {
            throw new IllegalArgumentException("rank is greater than 2");
        }
        QDataSet dep0 = (QDataSet)src.property("DEPEND_0");
        this.src = dep0 != null ? Ops.bundle(dep0, src) : src;
        this.index = 0;
        this.lastIndex = src.length();
    }

    public void constrainDepend0(DatumRange dr) {
        QDataSet dep0 = Ops.slice1(this.src, 0);
        QDataSet findeces = Ops.findex((Object)dep0, dr);
        this.index = (int)Math.ceil(findeces.value(0));
        this.lastIndex = (int)Math.ceil(findeces.value(1));
    }

    @Override
    public boolean hasNext() {
        return this.index < this.lastIndex;
    }

    @Override
    public QDataSet next() {
        return this.src.slice(this.index++);
    }

    @Override
    public void remove() {
    }
}

