/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import java.text.ParseException;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.buffer.BufferDataSet;

public class AsciiDataSet
extends BufferDataSet {
    int lenBytes;
    double fill = -1.0E38;
    private Units units = Units.dimensionless;

    public AsciiDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer back, Object type) {
        super(rank, reclen, recoffs, len0, len1, len2, len3, type, back);
        this.lenBytes = Integer.parseInt(type.toString().substring(5));
        if (this.lenBytes < 1) {
            throw new IllegalArgumentException("ascii1 is the shortest field supported.");
        }
        if (this.lenBytes > 32) {
            throw new IllegalArgumentException("ascii24 is the longest field supported.");
        }
        this.putProperty("FILL_VALUE", this.fill);
    }

    public void setLengthBytes(int length) {
        this.lenBytes = length;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    private double parseDouble(ByteBuffer back, int offset) {
        byte[] buff = new byte[this.lenBytes];
        for (int i = 0; i < this.lenBytes; ++i) {
            buff[i] = back.get(i + offset);
        }
        if (buff[this.lenBytes - 1] == 44) {
            buff[this.lenBytes - 1] = 32;
        }
        String s = new String(buff);
        if (this.units instanceof EnumerationUnits) {
            return ((EnumerationUnits)this.units).createDatum((Object)s.trim()).doubleValue(this.units);
        }
        try {
            return this.units.parse(s).doubleValue(this.units);
        }
        catch (ParseException ex) {
            return this.fill;
        }
    }

    @Override
    public double value() {
        return this.parseDouble(this.back, this.offset());
    }

    @Override
    public double value(int i0) {
        return this.parseDouble(this.back, this.offset(i0));
    }

    @Override
    public double value(int i0, int i1) {
        return this.parseDouble(this.back, this.offset(i0, i1));
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.parseDouble(this.back, this.offset(i0, i1, i2));
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.parseDouble(this.back, this.offset(i0, i1, i2, i3));
    }

    private byte[] getBytes(double d) {
        String s = this.units.createDatum(d).toString();
        return s.substring(0, this.lenBytes).getBytes();
    }

    @Override
    public void putValue(double d) {
        this.ensureWritable();
        int offs = this.offset();
        byte[] bb = this.getBytes(d);
        for (int i = 0; i < this.lenBytes; ++i) {
            this.back.put(offs + i, bb[i]);
        }
    }

    @Override
    public void putValue(int i0, double d) {
        this.ensureWritable();
        int offs = this.offset(i0);
        byte[] bb = this.getBytes(d);
        for (int i = 0; i < this.lenBytes; ++i) {
            this.back.put(offs + i, bb[i]);
        }
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        this.ensureWritable();
        int offs = this.offset(i0, i1);
        byte[] bb = this.getBytes(d);
        for (int i = 0; i < this.lenBytes; ++i) {
            this.back.put(offs + i, bb[i]);
        }
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        this.ensureWritable();
        int offs = this.offset(i0, i1, i2);
        byte[] bb = this.getBytes(d);
        for (int i = 0; i < this.lenBytes; ++i) {
            this.back.put(offs + i, bb[i]);
        }
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        this.ensureWritable();
        int offs = this.offset(i0, i1, i2, i3);
        byte[] bb = this.getBytes(d);
        for (int i = 0; i < this.lenBytes; ++i) {
            this.back.put(offs + i, bb[i]);
        }
    }
}

