/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.das2.qds.buffer.BufferDataSet;

public class UInt24DataSet
extends BufferDataSet {
    public UInt24DataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer back) {
        super(rank, reclen, recoffs, len0, len1, len2, len3, UINT24, back);
    }

    private int intValue(ByteBuffer buf, int offset) {
        ByteBuffer int4 = ByteBuffer.allocate(4);
        int4.order(ByteOrder.BIG_ENDIAN);
        int4.put((byte)0);
        if (this.back.order() == ByteOrder.LITTLE_ENDIAN) {
            int4.put(buf.get(offset));
            int4.put(buf.get(offset + 1));
            int4.put(buf.get(offset + 2));
        } else {
            int4.put(buf.get(offset + 2));
            int4.put(buf.get(offset + 1));
            int4.put(buf.get(offset));
        }
        int4.flip();
        return int4.getInt(0);
    }

    @Override
    public double value() {
        return this.intValue(this.back, this.offset());
    }

    @Override
    public double value(int i0) {
        return this.intValue(this.back, this.offset(i0));
    }

    @Override
    public double value(int i0, int i1) {
        return this.intValue(this.back, this.offset(i0, i1));
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.intValue(this.back, this.offset(i0, i1, i2));
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.intValue(this.back, this.offset(i0, i1, i2, i3));
    }

    private byte[] bytes3(int d) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        byte[] b = buf.putInt(d).array();
        if (this.back.order() == ByteOrder.BIG_ENDIAN) {
            return new byte[]{b[1], b[2], b[3]};
        }
        return new byte[]{b[3], b[2], b[1]};
    }

    @Override
    public void putValue(double d) {
        byte[] b3 = this.bytes3((int)d);
        int offset = this.offset();
        this.back.put(offset, b3[0]);
        this.back.put(offset + 1, b3[1]);
        this.back.put(offset + 2, b3[2]);
    }

    @Override
    public void putValue(int i0, double d) {
        byte[] b3 = this.bytes3((int)d);
        int offset = this.offset(i0);
        this.back.put(offset, b3[0]);
        this.back.put(offset + 1, b3[1]);
        this.back.put(offset + 2, b3[2]);
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        byte[] b3 = this.bytes3((int)d);
        int offset = this.offset(i0, i1);
        this.back.put(offset, b3[0]);
        this.back.put(offset + 1, b3[1]);
        this.back.put(offset + 2, b3[2]);
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        byte[] b3 = this.bytes3((int)d);
        int offset = this.offset(i0, i1, i2);
        this.back.put(offset, b3[0]);
        this.back.put(offset + 1, b3[1]);
        this.back.put(offset + 2, b3[2]);
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        byte[] b3 = this.bytes3((int)d);
        int offset = this.offset(i0, i1, i2, i3);
        this.back.put(offset, b3[0]);
        this.back.put(offset + 1, b3[1]);
        this.back.put(offset + 2, b3[2]);
    }
}

