/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.buffer;

import java.nio.ByteBuffer;
import org.das2.qds.buffer.BufferDataSet;

public final class VaxFloatDataSet
extends BufferDataSet {
    public VaxFloatDataSet(int rank, int reclen, int recoffs, int len0, int len1, int len2, int len3, ByteBuffer back) {
        super(rank, reclen, recoffs, len0, len1, len2, len3, VAX_FLOAT, back);
        this.makeImmutable();
    }

    private double vaxFloatValue2(ByteBuffer buf, int offset) {
        ByteBuffer tmp = ByteBuffer.allocate(4);
        int e = buf.get(1 + offset) << 1 & 0xFE | buf.get(0 + offset) >> 7 & 1;
        if (e > 2) {
            tmp.put(0, (byte)(buf.get(1 + offset) & 0x80 | (e -= 2) >> 1 & 0x7F));
            tmp.put(1, (byte)(buf.get(0 + offset) & 0x7F | e << 7 & 0x80));
            tmp.put(2, buf.get(3 + offset));
            tmp.put(3, buf.get(2 + offset));
        } else if (e == 0) {
            for (int i = 0; i < 4; ++i) {
                tmp.put(i, (byte)0);
            }
        } else {
            int f = buf.get(2 + offset) | buf.get(3 + offset) << 8 | (buf.get(0 + offset) & 0x7F) << 16 | 0x800000;
            tmp.put(0, (byte)(buf.get(1 + offset) & 0x80));
            tmp.put(1, (byte)((f >>= 3 - e) >> 16 & 0x7F));
            tmp.put(2, (byte)(f >> 8 & 0xFF));
            tmp.put(3, (byte)(f & 0xFF));
        }
        return tmp.getFloat();
    }

    @Override
    public double value() {
        return this.vaxFloatValue2(this.back, this.offset());
    }

    @Override
    public double value(int i0) {
        return this.vaxFloatValue2(this.back, this.offset(i0));
    }

    @Override
    public double value(int i0, int i1) {
        return this.vaxFloatValue2(this.back, this.offset(i0, i1));
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.vaxFloatValue2(this.back, this.offset(i0, i1, i2));
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.vaxFloatValue2(this.back, this.offset(i0, i1, i2, i3));
    }

    @Override
    public void putValue(double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, int i1, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, int i1, int i2, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

