/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.demos;

import java.text.ParseException;
import java.util.Random;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.math.PoissonDistribution;
import org.das2.qds.util.DataSetBuilder;

public class PlasmaModel {
    private double nc = 1.2;
    private double wcperp = 8.0E8;
    private double wcparl = 8.0E8;
    private static final double mass = 9.11E-28;
    private double geomFactor = 1.0E-37;
    PoissonDistribution poissonDistribution = new PoissonDistribution();

    public void setDensity(Datum density) {
        this.nc = density.doubleValue(Units.pcm3);
    }

    public Datum getDensity() {
        return Units.pcm3.createDatum(this.nc);
    }

    public void setWcparl(Datum wcparl) {
        this.wcparl = wcparl.doubleValue(Units.cmps);
    }

    public Datum getWcParl() {
        return Units.cmps.createDatum(this.wcparl);
    }

    public void setWcPerp(Datum wcperp) {
        this.wcperp = wcperp.doubleValue(Units.cmps);
    }

    public Datum getWcPerp() {
        return Units.cmps.createDatum(this.wcperp);
    }

    public void setGeomFactor(Datum geom) {
        this.geomFactor = geom.doubleValue(Units.dimensionless);
    }

    public Datum getGeomFactor() {
        return Units.dimensionless.createDatum(this.geomFactor);
    }

    public double f(Datum energy) {
        double en = energy.doubleValue(Units.eV);
        if (this.wcperp != this.wcparl) {
            throw new IllegalArgumentException("distribution is not isotropic, need pitch angle");
        }
        double v = Math.sqrt(2.0 * en * 1.6E-19 * 1.0E7 / 9.11E-28);
        double logfc = Math.log10(this.nc / (Math.pow(Math.PI, 1.5) * this.wcparl * this.wcparl)) - 3.0 * Math.pow(v / this.wcparl, 2.0);
        return Math.pow(10.0, logfc);
    }

    public double f(Datum energy, Datum pitchAngle) {
        double v = Math.sqrt(2.0 * energy.doubleValue(Units.eV) * 1.6E-19 * 1.0E7 / 9.11E-28);
        double a = pitchAngle.doubleValue(Units.radians);
        double vparl = Math.cos(a) * v;
        double vperp = Math.sin(a) * v;
        double logfc = Math.log10(this.nc / (Math.pow(Math.PI, 1.5) * this.wcparl * this.wcperp)) - Math.pow(vparl / this.wcparl, 2.0) - 2.0 * Math.pow(vperp / this.wcperp, 2.0);
        return Math.pow(10.0, logfc);
    }

    public double fcounts(Datum energy) {
        double en = energy.doubleValue(Units.eV);
        double fcount = 2.0 * (en / 9.11E-28) * (en / 9.11E-28) * this.geomFactor * this.f(energy);
        return fcount;
    }

    public int counts(Datum energy, Random random) {
        double en = energy.doubleValue(Units.eV);
        double fcount = 2.0 * (en / 9.11E-28) * (en / 9.11E-28) * this.geomFactor * this.f(energy);
        return this.poissonDistribution.poisson(fcount, random);
    }

    public double fcounts(Datum energy, Datum pitch) {
        double f = this.f(energy, pitch);
        double fcount = f * 2.0 * Math.pow(energy.doubleValue(Units.eV) / 9.11E-28, 2.0) * this.geomFactor;
        return fcount;
    }

    public int counts(Datum energy, Datum pitch, Random random) {
        double fcount = this.fcounts(energy, pitch);
        return this.poissonDistribution.poisson(fcount, random);
    }

    public QDataSet getRank2() {
        try {
            Random random = new Random(5330L);
            TimeLocationUnits xunits = Units.us2000;
            Datum start = Units.us2000.parse("2000-017T00:00");
            Datum end = Units.us2000.parse("2000-018T00:00");
            double xTagWidth = Units.seconds.convertDoubleTo(Units.microseconds, 13.8);
            double x = start.doubleValue((Units)xunits);
            DataSetBuilder builder = new DataSetBuilder(2, 1000, 20);
            DataSetBuilder xx = new DataSetBuilder(1, 1000);
            boolean ylog = false;
            DatumVector[] yTags = new DatumVector[1];
            Random s = new Random(234567L);
            double n = 2.0;
            while (x < end.doubleValue((Units)xunits)) {
                int nj;
                int whichYTags = s.nextInt(yTags.length);
                if (yTags[whichYTags] == null) {
                    nj = whichYTags * 10 + 20;
                    double[] yy = new double[nj];
                    for (int j = 0; j < nj; ++j) {
                        if (ylog) {
                            yy[j] = (double)(nj / 300) + (double)j * 0.05;
                            yy[j] = Math.pow(10.0, yy[j]);
                            continue;
                        }
                        yy[j] = (double)(nj / 3) + (double)j * 1.2;
                    }
                    yTags[whichYTags] = DatumVector.newDatumVector((double[])yy, (Units)Units.eV);
                } else {
                    nj = yTags[whichYTags].getLength();
                }
                double[] zz = new double[nj];
                int ncol = s.nextInt(4) + 1;
                DatumVector ydv = yTags[whichYTags];
                for (int icol = 0; icol < ncol; ++icol) {
                    double d = random.nextDouble();
                    this.setDensity(Units.pcm3.createDatum(n *= Math.pow(10.0, (d - 0.5) / 100.0)));
                    for (int j = 0; j < nj; ++j) {
                        zz[j] = this.counts(ydv.get(j), random);
                        builder.putValue(-1, j, zz[j]);
                    }
                    xx.putValue(-1, x);
                    x += xTagWidth;
                }
                builder.nextRecord();
                xx.nextRecord();
            }
            xx.putProperty("UNITS", Units.us2000);
            builder.putProperty("DEPEND_0", xx.getDataSet());
            DDataSet yy = DDataSet.wrap(yTags[0].toDoubleArray(Units.eV));
            yy.putProperty("UNITS", Units.eV);
            builder.putProperty("DEPEND_1", yy);
            return builder.getDataSet();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public QDataSet getRank3() {
        try {
            Random random = new Random(5330L);
            Datum start = Units.us2000.parse("2000-017T00:00");
            Datum end = Units.us2000.parse("2000-018T00:00");
            Datum xTagWidth = Units.seconds.createDatum(13.8);
            Datum t = start;
            DataSetBuilder builder = new DataSetBuilder(3, 1000, 20, 18);
            DataSetBuilder xx = new DataSetBuilder(1, 1000);
            boolean ylog = false;
            DatumVector[] energyTags = new DatumVector[1];
            DatumVector[] alphaTags = new DatumVector[1];
            Random s = new Random(234567L);
            double n = 2.0;
            while (t.lt(end)) {
                int na;
                int ne;
                int whichTags = s.nextInt(energyTags.length);
                if (energyTags[whichTags] == null) {
                    ne = whichTags * 10 + 20;
                    double[] en = new double[ne];
                    for (int j = 0; j < ne; ++j) {
                        if (ylog) {
                            en[j] = (double)(ne / 300) + (double)j * 0.05;
                            en[j] = Math.pow(10.0, en[j]);
                            continue;
                        }
                        en[j] = (double)(ne / 3) + (double)j * 1.2;
                    }
                    energyTags[whichTags] = DatumVector.newDatumVector((double[])en, (Units)Units.eV);
                } else {
                    ne = energyTags[whichTags].getLength();
                }
                if (alphaTags[whichTags] == null) {
                    na = 18;
                    double[] yy = new double[na];
                    for (int j = 0; j < na; ++j) {
                        yy[j] = Math.PI * (0.5 + (double)j) / (double)na;
                    }
                    alphaTags[whichTags] = DatumVector.newDatumVector((double[])yy, (Units)Units.radians);
                } else {
                    na = alphaTags[whichTags].getLength();
                }
                int ncol = s.nextInt(4) + 1;
                DatumVector ydv = energyTags[whichTags];
                DatumVector adv = alphaTags[whichTags];
                for (int icol = 0; icol < ncol; ++icol) {
                    double d = random.nextDouble();
                    this.setDensity(Units.pcm3.createDatum(n *= Math.pow(10.0, (d - 0.5) / 100.0)));
                    for (int j = 0; j < ne; ++j) {
                        for (int k = 0; k < na; ++k) {
                            double zz = this.counts(ydv.get(j), adv.get(k), random);
                            builder.putValue(-1, j, k, zz);
                        }
                    }
                    xx.putValue(-1, t);
                    t = t.add(xTagWidth);
                }
                builder.nextRecord();
                xx.nextRecord();
            }
            xx.putProperty("UNITS", Units.us2000);
            builder.putProperty("DEPEND_0", xx.getDataSet());
            DDataSet yy = DDataSet.wrap(energyTags[0].toDoubleArray(Units.eV));
            yy.putProperty("UNITS", Units.eV);
            DDataSet aa = DDataSet.wrap(alphaTags[0].toDoubleArray(Units.radians));
            builder.putProperty("DEPEND_1", yy);
            builder.putProperty("DEPEND_2", aa);
            return builder.getDataSet();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }
}

