/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.examples;

import java.text.ParseException;
import java.util.logging.Logger;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.ColorUtil;

public class Schemes {
    private static Logger logger = Logger.getLogger("qdataset.schemes");
    private static final QDataSet COMPLEX_COORDINATE_SYSTEM_DEPEND;

    public static QDataSet boundingBox() {
        try {
            QDataSet xx = Ops.timegen("2015-02-20T00:30", "60 s", 1440);
            MutablePropertyDataSet yy = Ops.putProperty(Ops.linspace(14.0, 16.0, 1440), "UNITS", (Object)Units.nT);
            JoinDataSet bds = new JoinDataSet(2);
            bds.join(Ops.extent(xx));
            bds.join(Ops.extent(yy));
            bds.makeImmutable();
            return bds;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isBoundingBox(QDataSet ds) {
        return ds.rank() == 2 && ds.length(0) == 2 && ds.length() == 2;
    }

    public static QDataSet arrayOfBoundingBox() {
        Ops.randomSeed(0L);
        QDataSet xx = Ops.floor(Ops.add((Object)Ops.multiply((Object)Ops.randn(100), 10), 100));
        xx = Ops.putProperty(xx, "UNITS", (Object)Units.MeV);
        MutablePropertyDataSet yy = (MutablePropertyDataSet)Ops.randn(100);
        QDataSet bx = Ops.extent(xx);
        QDataSet by = Ops.extent(yy);
        QDataSet xx2 = Ops.floor(Ops.add((Object)Ops.multiply((Object)Ops.randn(100), 12), 170));
        xx2 = Ops.putProperty(xx2, "UNITS", (Object)Units.MeV);
        QDataSet yy2 = Ops.add((Object)Ops.randn(100), 2);
        QDataSet bx2 = Ops.extent(xx2);
        QDataSet by2 = Ops.extent(yy2);
        QDataSet xx3 = Ops.floor(Ops.add((Object)Ops.multiply((Object)Ops.randn(100), 12), 140));
        xx3 = Ops.putProperty(xx3, "UNITS", (Object)Units.MeV);
        QDataSet yy3 = Ops.subtract((Object)Ops.randn(100), 1);
        QDataSet bx3 = Ops.extent(xx3);
        QDataSet by3 = Ops.extent(yy3);
        JoinDataSet bounds = (JoinDataSet)Ops.join(Ops.join(bx, by), Ops.join(bx2, by2));
        bounds.join(Ops.join(bx3, by3));
        return bounds;
    }

    public static boolean isArrayOfBoundingBox(QDataSet ds) {
        int[] dims = DataSetUtil.qubeDims(ds);
        return ds.rank() == 3 && dims != null && dims[1] == 2 && dims[2] == 2;
    }

    public static QDataSet rank2Waveform() {
        return Ops.ripplesWaveformTimeSeries(20);
    }

    public static boolean isRank2Waveform(QDataSet ds) {
        if (ds.rank() != 2) {
            return false;
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 == null) {
            return false;
        }
        Units u0 = SemanticOps.getUnits(dep0);
        if (u0 == Units.dimensionless) {
            return false;
        }
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep1 == null) {
            return false;
        }
        if (dep1.length() < 4) {
            return false;
        }
        return u0.getOffsetUnits().isConvertibleTo(SemanticOps.getUnits(dep1));
    }

    public static QDataSet rank3Waveform() {
        QDataSet w1 = Ops.ripplesWaveformTimeSeries(20);
        WritableDataSet w2 = Ops.maybeCopy(Ops.ripplesWaveformTimeSeries(14));
        WritableDataSet t2 = Ops.maybeCopy((QDataSet)w2.property("DEPEND_0"));
        QDataSet et = Ops.extent((QDataSet)w1.property("DEPEND_0"));
        double dt = et.value(1) - et.value(0);
        for (int i = 0; i < t2.length(); ++i) {
            t2.putValue(i, t2.value(i) + dt);
        }
        w2.putProperty("DEPEND_0", t2);
        w2.putProperty("DEPEND_1", Ops.multiply(w2.property("DEPEND_1"), 0.8));
        WritableDataSet w3 = Ops.maybeCopy(Ops.ripplesWaveformTimeSeries(3));
        WritableDataSet t3 = Ops.maybeCopy((QDataSet)w3.property("DEPEND_0"));
        Units tu = (Units)t3.property("UNITS");
        et = Ops.extent((QDataSet)w2.property("DEPEND_0"));
        double dt2 = et.value(1) - et.value(0);
        for (int i = 0; i < t3.length(); ++i) {
            t3.putValue(i, t3.value(i) + dt + dt2 + Units.seconds.convertDoubleTo(tu.getOffsetUnits(), 1.0));
        }
        w3.putProperty("DEPEND_0", t3);
        return Ops.join(Ops.join(w1, w2), w3);
    }

    public static boolean isRank3Waveform(QDataSet ds) {
        if (ds.rank() != 3) {
            return false;
        }
        boolean isWaveform = true;
        for (int i = 0; i < ds.length() && isWaveform; ++i) {
            if (Schemes.isRank2Waveform(ds.slice(i))) continue;
            isWaveform = false;
        }
        return isWaveform;
    }

    public static QDataSet rank2WaveformRank2Offsets() {
        QDataSet ds = Ops.ripplesWaveformTimeSeries(20);
        QDataSet offs = (QDataSet)ds.property("DEPEND_1");
        offs = Ops.append(Ops.replicate(offs, 10), Ops.replicate(Ops.divide((Object)offs, 3.0), 10));
        ds = Ops.putProperty(ds, "DEPEND_1", (Object)offs);
        return ds;
    }

    public static boolean isRank2WaveformRank2Offsets(QDataSet ds) {
        return Schemes.isRank2Waveform(ds) && ((QDataSet)ds.property("DEPEND_1")).rank() == 2;
    }

    public static QDataSet vectorTimeSeries() {
        return Ops.ripplesVectorTimeSeries(1440);
    }

    public static boolean isVectorTimeSeries(QDataSet ds) {
        return ds.rank() == 2 && (Ops.isLegacyBundle(ds) || Ops.isBundle(ds)) && Schemes.isTimeSeries(ds);
    }

    public static QDataSet simpleSpectrogram() {
        return Ops.ripples(40, 30);
    }

    public static boolean isSimpleSpectrogram(QDataSet ds) {
        if (ds.rank() == 2) {
            return ds.length(0) >= 4 || !Ops.isBundle(ds) && !Ops.isLegacyBundle(ds);
        }
        return false;
    }

    public static QDataSet scalarTimeSeries() {
        try {
            QDataSet density = Ops.add(Ops.ripples(20), Ops.randomn(0L, 20));
            density = Ops.putProperty(density, "UNITS", (Object)Units.pcm3);
            QDataSet t = Ops.timegen("2011-10-24", "20 sec", 20);
            return Ops.link(t, density);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isScalarTimeSeries(QDataSet ds) {
        return ds.rank() == 1 && Schemes.isTimeSeries(ds);
    }

    public static QDataSet scalarSeriesWithErrors() {
        QDataSet x = Ops.add(1, (Object)Ops.divide((Object)Ops.findgen(41), 2));
        QDataSet y = Ops.exp(Ops.multiply(-1, (Object)Ops.pow((Object)Ops.subtract((Object)x, 10), (Object)2)));
        WritableDataSet result = Ops.maybeCopy(Ops.link(x, y));
        result.putProperty("DELTA_PLUS", Ops.replicate(0.04, 41));
        result.putProperty("DELTA_MINUS", Ops.replicate(0.04, 41));
        return result;
    }

    public static boolean isScalarSeriesWithErrors(QDataSet ds) {
        return ds.rank() == 1 && ds.property("DELTA_PLUS") != null && ds.property("DELTA_MINUS") != null;
    }

    public static QDataSet simpleSpectrogramTimeSeries() {
        return Ops.ripplesSpectrogramTimeSeries(1440);
    }

    public static boolean isSimpleSpectrogramTimeSeries(QDataSet ds) {
        return Schemes.isSimpleSpectrogram(ds) && Schemes.isTimeSeries(ds);
    }

    public static boolean isTimeSeries(QDataSet ds) {
        return SemanticOps.isTimeSeries(ds);
    }

    public static QDataSet uniformCadence() {
        return Ops.linspace(0.0, 4.0, 100);
    }

    public static boolean isUniformCadence(QDataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        double dv = ds.value(1) - ds.value(0);
        double manyDv = (ds.value(ds.length() - 1) - ds.value(0)) / (double)(ds.length() - 1);
        return Math.abs((manyDv - dv) / dv) < 0.001;
    }

    public static QDataSet uniformRatiometricCadence() {
        return Ops.pow((Object)10, (Object)Ops.linspace(0.0, 4.0, 100));
    }

    public static boolean isUniformRatiometricCadence(QDataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        if (!UnitsUtil.isRatioMeasurement((Units)SemanticOps.getUnits(ds))) {
            return false;
        }
        double dv = Math.log(ds.value(1) / ds.value(0));
        double manyDv = Math.log(ds.value(ds.length() - 1) / ds.value(0)) / (double)(ds.length() - 1);
        return Math.abs((manyDv - dv) / dv) < 0.001;
    }

    public static QDataSet compositeImage() {
        WritableDataSet rgb = Ops.zeros(320, 240, 3);
        for (int i = 0; i < 320; ++i) {
            for (int j = 0; j < 240; ++j) {
                if (Math.pow(i - 160, 2.0) + Math.pow(j - 120, 2.0) < 2500.0) {
                    rgb.putValue(i, j, 0, 255.0);
                }
                if (i < 160) {
                    rgb.putValue(i, j, 1, 255.0);
                }
                if (j >= 120) continue;
                rgb.putValue(i, j, 2, 255.0);
            }
        }
        rgb.putProperty("DEPEND_0", Ops.linspace(0.0, 4.0, rgb.length()));
        rgb.putProperty("DEPEND_1", Ops.pow((Object)10, (Object)Ops.linspace(0.0, 4.0, rgb.length(0))));
        rgb.putProperty("RENDER_TYPE", "image");
        return rgb;
    }

    public static boolean isCompositeImage(QDataSet ds) {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        return !(ds.rank() != 3 || !DataSetUtil.checkQube(ds) || dep0 != null && !Schemes.isUniformCadence(dep0) && !Schemes.isUniformRatiometricCadence(dep0) || dep1 != null && !Schemes.isUniformCadence(dep1) && !Schemes.isUniformRatiometricCadence(dep1));
    }

    public static QDataSet eventsList() {
        try {
            QDataSet xx = Ops.timegen("2015-01-01", "60s", 1440);
            MutablePropertyDataSet dxx = Ops.putProperty(Ops.replicate(45, 1440), "UNITS", (Object)Units.seconds);
            WritableDataSet color = Ops.replicate(0xFFAAAA, 1440);
            for (int i = 100; i < 200; ++i) {
                color.putValue(i, 1.6755455E7);
            }
            EnumerationUnits eu = EnumerationUnits.create((Object)"default");
            MutablePropertyDataSet msgs = Ops.putProperty(Ops.replicate(eu.createDatum((Object)"on1").doubleValue((Units)eu), 1440), "UNITS", (Object)eu);
            QDataSet result = Ops.bundle(xx, Ops.add(xx, dxx), color, msgs);
            return result;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static QDataSet canonicalEvent() {
        QDataSet ds = Ops.bundle(Ops.dataset("2025-05-06T14:29"), Ops.dataset("2025-05-06T14:31"), Ops.dataset(Units.rgbColor.createDatum(ColorUtil.SKY_BLUE.getRGB())), Ops.dataset(Units.nominal().createDatum((Object)"Sunny and Warm")));
        DataSetUtil.toString(ds);
        return ds;
    }

    public static boolean isCanonicalEvent(QDataSet ds) {
        if (ds.rank() != 1) {
            return false;
        }
        QDataSet bundle0 = (QDataSet)ds.property("BUNDLE_0");
        if (bundle0 != null) {
            if (bundle0.length() == 3 || bundle0.length() == 4 || bundle0.length() == 5) {
                boolean t1t2;
                Units u1;
                Units u0 = (Units)bundle0.property("UNITS", 0);
                if (u0 == null) {
                    u0 = Units.dimensionless;
                }
                if ((u1 = (Units)bundle0.property("UNITS", 1)) == null) {
                    u1 = Units.dimensionless;
                }
                Units u3 = (Units)bundle0.property("UNITS", bundle0.length() - 1);
                boolean bl = t1t2 = UnitsUtil.isTimeLocation((Units)u0) && UnitsUtil.isTimeLocation((Units)u1);
                if (t1t2 || u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3) && u0.getOffsetUnits().isConvertibleTo(u1)) {
                    if (u0.isConvertibleTo(u1)) {
                        QDataSet isge = Ops.ge(Ops.slice0(ds, 1), Ops.slice0(ds, 0));
                        return Ops.total(isge) == Ops.total(Ops.valid(Ops.slice0(ds, 0)));
                    }
                    QDataSet isge = Ops.ge((Object)Ops.abs(Ops.slice0(ds, 1)), 0.0);
                    return Ops.total(isge) == Ops.total(Ops.valid(Ops.slice0(ds, 0)));
                }
                if (u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3) && u0.isConvertibleTo(u1)) {
                    QDataSet isge = Ops.ge(Ops.slice0(ds, 1), Ops.slice0(ds, 0));
                    return Ops.total(isge) == Ops.total(Ops.valid(Ops.slice0(ds, 0)));
                }
            } else {
                Units u3 = (Units)bundle0.property("UNITS", bundle0.length() - 1);
                if (u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEventsList(QDataSet ds) {
        QDataSet dep0;
        QDataSet bundle1 = (QDataSet)ds.property("BUNDLE_1");
        if (bundle1 != null) {
            if (bundle1.length() == 3 || bundle1.length() == 4 || bundle1.length() == 5) {
                boolean t1t2;
                Units u1;
                Units u0 = (Units)bundle1.property("UNITS", 0);
                if (u0 == null) {
                    u0 = Units.dimensionless;
                }
                if ((u1 = (Units)bundle1.property("UNITS", 1)) == null) {
                    u1 = Units.dimensionless;
                }
                Units u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1);
                boolean bl = t1t2 = UnitsUtil.isTimeLocation((Units)u0) && UnitsUtil.isTimeLocation((Units)u1);
                if (t1t2 || u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3) && u0.getOffsetUnits().isConvertibleTo(u1)) {
                    if (u0.isConvertibleTo(u1)) {
                        QDataSet isge = Ops.ge(Ops.slice1(ds, 1), Ops.slice1(ds, 0));
                        return Ops.total(isge) == Ops.total(Ops.valid(Ops.slice1(ds, 0)));
                    }
                    QDataSet isge = Ops.ge((Object)Ops.abs(Ops.slice1(ds, 1)), 0.0);
                    return Ops.total(isge) == Ops.total(Ops.valid(Ops.slice1(ds, 0)));
                }
                if (u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3) && u0.isConvertibleTo(u1)) {
                    QDataSet isge = Ops.ge(Ops.slice1(ds, 1), Ops.slice1(ds, 0));
                    return Ops.total(isge) == Ops.total(Ops.valid(Ops.slice1(ds, 0)));
                }
            } else {
                Units u3 = (Units)bundle1.property("UNITS", bundle1.length() - 1);
                if (u3 != null && UnitsUtil.isOrdinalMeasurement((Units)u3)) {
                    return true;
                }
            }
        } else if (SemanticOps.getUnits(ds) instanceof EnumerationUnits && (dep0 = (QDataSet)ds.property("DEPEND_0")) != null) {
            return true;
        }
        return false;
    }

    public static QDataSet angleDistribution() {
        ArrayDataSet rip = ArrayDataSet.maybeCopy(Ops.ripples(30, 15));
        QDataSet angle = Ops.linspace(0.05235987755982988, 3.0892327760299634, 30);
        angle = Ops.putProperty(angle, "UNITS", (Object)Units.radians);
        QDataSet rad = Ops.linspace(1.0, 5.0, 15);
        rip.putProperty("DEPEND_0", angle);
        rip.putProperty("DEPEND_1", rad);
        rip.putProperty("RENDER_TYPE", "pitchAngleDistribution");
        return rip;
    }

    public static QDataSet angleDistribution(int i) {
        if (i == 0) {
            ArrayDataSet rip = ArrayDataSet.maybeCopy(Ops.randn(24, 15));
            for (int j = 0; j < 15; ++j) {
                rip.putValue(0, j, 20.0);
                rip.putValue(4, j, 20.0);
            }
            QDataSet angle = Ops.multiply((Object)Ops.linspace(0.5, 23.5, 24), 15);
            angle = Ops.putProperty(angle, "UNITS", (Object)Units.degrees);
            QDataSet rad = Ops.linspace(1.0, 5.0, 15);
            rip.putProperty("DEPEND_0", angle);
            rip.putProperty("DEPEND_1", rad);
            rip.putProperty("RENDER_TYPE", "pitchAngleDistribution");
            return rip;
        }
        return null;
    }

    public static boolean isAngleDistribution(QDataSet ds) {
        if (ds.rank() != 2) {
            return false;
        }
        QDataSet ads = (QDataSet)ds.property("DEPEND_0");
        Units au = (Units)ads.property("UNITS");
        return au == null || au == Units.dimensionless || au.isConvertibleTo(Units.degrees);
    }

    public static QDataSet complexBundleDataSet2() {
        DDataSet data = DDataSet.createRank2(12, 9);
        QDataSet ttags = Ops.linspace("2019-03-07T00:30Z", "2019-03-07T11:30Z", 12);
        QDataSet vel = Schemes.vectorTimeSeries();
        QDataSet dens = Schemes.scalarTimeSeries();
        QDataSet flux = Schemes.simpleSpectrogram();
        for (int i = 0; i < data.length(); ++i) {
            data.putValue(i, 0, ttags.value(i));
            data.putValue(i, 1, dens.value(i));
            data.putValue(i, 2, vel.value(i, 0));
            data.putValue(i, 3, vel.value(i, 1));
            data.putValue(i, 4, vel.value(i, 2));
            data.putValue(i, 5, flux.value(i, 0));
            data.putValue(i, 6, flux.value(i, 1));
            data.putValue(i, 7, flux.value(i, 2));
            data.putValue(i, 8, flux.value(i, 3));
        }
        SparseDataSetBuilder sb = new SparseDataSetBuilder(2);
        sb.setLength(9);
        sb.putProperty("NAME", 0, "ttags");
        sb.putProperty("UNITS", 0, ttags.property("UNITS"));
        sb.putProperty("NAME", 1, "density");
        sb.putProperty("UNITS", 1, Units.pcm3);
        Units vunits = (Units)((QDataSet)vel.property("BUNDLE_1")).property("UNITS", 0);
        sb.putProperty("NAME", 2, "vx");
        sb.putProperty("UNITS", 2, vunits);
        sb.putProperty("NAME", 3, "vy");
        sb.putProperty("UNITS", 3, vunits);
        sb.putProperty("NAME", 4, "vz");
        sb.putProperty("UNITS", 4, vunits);
        sb.putProperty("ELEMENT_DIMENSIONS", new int[]{3});
        sb.putProperty("ELEMENT_NAME", 2, "V");
        sb.putProperty("ELEMENT_LABEL", 2, "S/C Velocity");
        sb.putProperty("START_INDEX", 2, 2);
        sb.putProperty("START_INDEX", 3, 2);
        sb.putProperty("START_INDEX", 4, 2);
        Units funits = Units.lookupUnits((String)"kg m^2 s^-2 A^-1");
        sb.putProperty("NAME", 5, "fl0");
        sb.putProperty("UNITS", 5, funits);
        sb.putProperty("NAME", 6, "fl1");
        sb.putProperty("UNITS", 6, funits);
        sb.putProperty("NAME", 7, "fl2");
        sb.putProperty("UNITS", 7, funits);
        sb.putProperty("NAME", 8, "fl3");
        sb.putProperty("UNITS", 8, funits);
        sb.putProperty("ELEMENT_DIMENSIONS", 5, new int[]{4});
        sb.putProperty("ELEMENT_NAME", 5, "Flux");
        sb.putProperty("DEPEND_1", 5, Ops.pow((Object)10, (Object)Ops.linspace(1.0, 4.0, 4)));
        sb.putProperty("START_INDEX", 5, 5);
        sb.putProperty("START_INDEX", 6, 5);
        sb.putProperty("START_INDEX", 7, 5);
        sb.putProperty("START_INDEX", 8, 5);
        data.putProperty("BUNDLE_1", sb.getDataSet());
        return data;
    }

    public static QDataSet bundleDataSet() {
        try {
            QDataSet tt = Ops.timegen("2015-01-01", "60s", 1440);
            QDataSet r1 = Ops.ripplesTimeSeries(1440);
            QDataSet r2 = Ops.unbundle(Ops.ripplesVectorTimeSeries(1440), 0);
            return Ops.bundle(tt, r1, r2);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isBundleDataSet(QDataSet ds) {
        return Ops.isBundle(ds);
    }

    public static boolean isBundleDescriptor(QDataSet bds) {
        if (bds.rank() != 2) {
            return false;
        }
        return bds.length(0) == 0;
    }

    public static QDataSet bundleDescriptor() {
        QDataSet bundle = Schemes.bundleDataSet();
        return (QDataSet)bundle.property("BUNDLE_1");
    }

    public static QDataSet rank2ComplexNumbers() {
        QDataSet w = Schemes.rank2Waveform();
        w = w.slice(0);
        return Ops.fft(w);
    }

    public static QDataSet complexCoordinateSystemDepend() {
        return COMPLEX_COORDINATE_SYSTEM_DEPEND;
    }

    public static boolean isComplexCoordinateSystemDepend(QDataSet dep) {
        return dep.length() == 2 && "ComplexNumber".equals(dep.property("COORDINATE_FRAME"));
    }

    public static boolean isComplexNumbers(QDataSet ds1) {
        QDataSet dep;
        int r = ds1.rank();
        switch (r) {
            case 0: {
                return false;
            }
            case 1: {
                if (ds1.length() != 2) {
                    return false;
                }
                dep = (QDataSet)ds1.property("DEPEND_0");
                break;
            }
            case 2: {
                if (ds1.length(0) != 2) {
                    return false;
                }
                dep = (QDataSet)ds1.property("DEPEND_1");
                break;
            }
            case 3: {
                if (ds1.length(0, 0) != 2) {
                    return false;
                }
                dep = (QDataSet)ds1.property("DEPEND_2");
                break;
            }
            case 4: {
                if (ds1.length(0, 0, 0) != 2) {
                    return false;
                }
                dep = (QDataSet)ds1.property("DEPEND_3");
                break;
            }
            default: {
                return false;
            }
        }
        if ("ComplexNumber".equals(ds1.property("COORDINATE_FRAME"))) {
            return true;
        }
        if (dep == null) {
            return false;
        }
        return Schemes.isComplexCoordinateSystemDepend(dep);
    }

    public static QDataSet complexNumbers() {
        QDataSet a = Ops.linspace(0.0, Math.PI * 2, 1441);
        QDataSet r = Ops.randomn(0L, 1441);
        QDataSet s = Ops.sin(Ops.multiply((Object)a, 20));
        QDataSet os = Ops.cos(Ops.multiply((Object)a, 70));
        QDataSet signal = Ops.add(Ops.add(s, os), r);
        return Ops.fft(signal);
    }

    public static QDataSet complexBundleDataSet() {
        try {
            int j;
            MutablePropertyDataSet mpds;
            int j2;
            QDataSet tt = Ops.timegen("2016-12-21T00:00", "60s", 1440);
            tt = Ops.putProperty(tt, "NAME", (Object)"time");
            Ops.randomSeed(5334L);
            QDataSet density = Ops.pow((Object)10, (Object)Ops.add((Object)Ops.divide((Object)Ops.randn(1440), 10), 1));
            density = Ops.putProperty(density, "UNITS", (Object)Units.pcm3);
            density = Ops.putProperty(density, "NAME", (Object)"density");
            density = Ops.putProperty(density, "DEPENDNAME_0", (Object)"time");
            QDataSet vv = Ops.transpose(Ops.reform(Ops.accum(Ops.randn(4320)), new int[]{3, 1440}));
            vv = Ops.putProperty(vv, "UNITS", (Object)Units.cmps);
            vv = Ops.putProperty(vv, "NAME", (Object)"speed");
            vv = Ops.putProperty(vv, "DEPENDNAME_0", (Object)"time");
            DDataSet ff = DDataSet.createRank2(1440, 4);
            ff.putProperty("UNITS", Units.lookupUnits((String)"s!E-1!Ncm!E-2!Nster!E-1!NkeV!E-1!N"));
            ff.putProperty("NAME", "flux");
            for (int i = 0; i < 1440; ++i) {
                ff.putValue(i, 0, 23.0 + vv.value(i, 0));
                ff.putValue(i, 1, 45.0 + vv.value(i, 0));
                ff.putValue(i, 2, 31.0 + vv.value(i, 0));
                ff.putValue(i, 3, 11.0 + vv.value(i, 0));
            }
            ff.putProperty("DEPEND_1", Ops.pow((Object)10, (Object)Ops.linspace(1.0, 4.0, 4)));
            QDataSet result = Ops.bundle(tt, density);
            for (j2 = 0; j2 < vv.length(0); ++j2) {
                mpds = (MutablePropertyDataSet)Ops.slice1(vv, j2);
                mpds.putProperty("NAME", "speed_" + (char)(120 + j2));
                mpds.putProperty("DEPENDNAME_0", "time");
                result = Ops.bundle(result, mpds);
            }
            for (j2 = 0; j2 < ff.length(0); ++j2) {
                mpds = (MutablePropertyDataSet)Ops.slice1((QDataSet)ff, j2);
                mpds.putProperty("NAME", "flux_" + j2);
                mpds.putProperty("DEPENDNAME_0", "time");
                result = Ops.bundle(result, mpds);
            }
            MutablePropertyDataSet bds = (MutablePropertyDataSet)result.property("BUNDLE_1");
            for (j = 0; j < vv.length(0); ++j) {
                bds.putProperty("START_INDEX", 2 + j, 2);
                bds.putProperty("ELEMENT_DIMENSIONS", 2 + j, new int[]{3});
                bds.putProperty("ELEMENT_NAME", 2 + j, "speed");
            }
            for (j = 0; j < ff.length(0); ++j) {
                bds.putProperty("START_INDEX", 5 + j, 5);
                bds.putProperty("ELEMENT_DIMENSIONS", 5 + j, new int[]{4});
                bds.putProperty("ELEMENT_NAME", 5 + j, "flux");
                bds.putProperty("DEPEND_1", ff.property("DEPEND_1"));
            }
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static QDataSet trajectory() {
        QDataSet tt = Ops.multiply("1hr", (Object)Ops.linspace(0.0, 24.0, 1440));
        QDataSet xy = Ops.bundle(Ops.cos(tt), Ops.sin(tt));
        return Ops.link(tt, xy);
    }

    public static boolean isTrajectory(QDataSet ds) {
        return Schemes.isBundleDataSet(ds) && ds.rank() == 2;
    }

    public static QDataSet rank1AlongTrajectory() {
        QDataSet trajectory = Schemes.trajectory();
        QDataSet zz = Ops.sin(Ops.linspace(0.0, Math.PI, trajectory.length()));
        return Ops.link(trajectory, zz);
    }

    public static boolean isRank1AlongTrajectory(QDataSet ds) {
        return ds.rank() == 1 && Schemes.isTrajectory((QDataSet)ds.property("DEPEND_0"));
    }

    public static QDataSet xyScatter() {
        QDataSet xx = Ops.randomn(5334L, 30);
        QDataSet yy = Ops.randomn(5335L, 30);
        return Ops.bundle(xx, yy);
    }

    public static boolean isXYScatter(QDataSet ds) {
        return ds.rank() == 2 && ds.length(0) == 2 && Schemes.isBundleDataSet(ds);
    }

    public static QDataSet rank1AtXYScatter() {
        QDataSet xx = Ops.randomn(5334L, 30);
        QDataSet yy = Ops.randomn(5335L, 30);
        QDataSet zz = Ops.sqrt(Ops.add(Ops.pow((Object)xx, (Object)2), Ops.pow((Object)yy, (Object)2)));
        return Ops.link(Ops.bundle(xx, yy), zz);
    }

    public static boolean isRank1AtXYScatter(QDataSet ds) {
        QDataSet xy = (QDataSet)ds.property("DEPEND_0");
        return xy != null && Schemes.isXYScatter(xy) && ds.rank() == 1;
    }

    public static boolean isRank2Bins(QDataSet dep) {
        return dep.rank() == 2 && ("min,max".equals(dep.property("BINS_1")) || "min,maxInclusive".equals(dep.property("BINS_1")));
    }

    public static QDataSet rank2Bins() {
        WritableDataSet result = Ops.maybeCopy(Ops.findgen(20, 2));
        result.putProperty("BINS_1", "min,max");
        return result;
    }

    public static boolean isLegacyXYZScatter(QDataSet zds) {
        return zds.rank() == 1 && zds.property("PLANE_0") != null;
    }

    public static QDataSet legacyXYZScatter() {
        QDataSet xx = Ops.outerProduct(Ops.linspace("2015-03-01T00:00", "2015-03-01T10:00", 150), Ops.ones(30));
        QDataSet yy = Ops.outerProduct(Ops.ones(150), Ops.linspace(10.0, 40.0, 30));
        QDataSet zz = Ops.ripples(150, 30);
        xx = Ops.reform(xx, new int[]{4500});
        yy = Ops.reform(yy, new int[]{4500});
        yy = Ops.putProperty(yy, "UNITS", (Object)Units.hertz);
        zz = Ops.reform(zz, new int[]{4500});
        yy = Ops.putProperty(yy, "DEPEND_0", (Object)xx);
        yy = Ops.putProperty(yy, "PLANE_0", (Object)zz);
        return yy;
    }

    public static boolean isXYZScatter(QDataSet zds) {
        return zds.rank() == 2 && Schemes.isBundleDataSet(zds) && zds.length(0) == 3;
    }

    public static QDataSet xyzScatter() {
        QDataSet xx = Ops.append(Ops.randn(300), Ops.add(2, (Object)Ops.randn(300)));
        QDataSet yy = Ops.append(Ops.randn(300), Ops.add(-3, (Object)Ops.randn(300)));
        QDataSet zz = Ops.sin(Ops.add(xx, yy));
        QDataSet result = Ops.bundle(xx, yy, zz);
        return result;
    }

    public static boolean isIrregularJoin(QDataSet ds) {
        return !DataSetUtil.isQube(ds);
    }

    public static QDataSet irregularJoin() {
        return Ops.ripplesJoinSpectrogramTimeSeries(40);
    }

    public static QDataSet polyMesh() {
        QDataSet xy = Schemes.xyScatter();
        QDataSet tri = Ops.triangulate(Ops.slice1(xy, 0), Ops.slice1(xy, 1));
        QDataSet result = Ops.join(xy, tri);
        result = Ops.putProperty(result, "RENDER_TYPE", (Object)"triangleMesh");
        return result;
    }

    public static boolean isPolyMesh(QDataSet ds) {
        if (ds.rank() == 3 && ds.length() == 2) {
            int ndim = ds.slice(0).length(0);
            int ncorners = ds.slice(1).length(0);
            if (ndim == 2 || ndim == 3) {
                if (ncorners == 3) {
                    return true;
                }
                if (ncorners == 4) {
                    return true;
                }
                return ncorners > 4;
            }
        }
        return false;
    }

    public static QDataSet datum() {
        return Ops.dataset("1.23 cm");
    }

    public static boolean isDatum(QDataSet ds) {
        return ds.rank() == 0;
    }

    public static QDataSet datumRange() {
        return Ops.dataset("2025-06-11");
    }

    public static boolean isDatumRange(QDataSet ds) {
        return ds.rank() == 1 && "min,max".equals(ds.property("BINS_0"));
    }

    public static boolean isNominalAtScatter(QDataSet fillds) {
        if (fillds.rank() == 2 && Schemes.isBundleDataSet(fillds)) {
            QDataSet lastDs = Ops.unbundle(fillds, fillds.length(0) - 1);
            Units u = SemanticOps.getUnits(lastDs);
            return UnitsUtil.isNominalMeasurement((Units)u);
        }
        return false;
    }

    public static QDataSet nominalAtScatter() {
        Ops.randomSeed(0L);
        QDataSet xx = Ops.randn(10);
        QDataSet yy = Ops.randn(10);
        EnumerationUnits eu = Units.nominal((String)"nominalAtScatter");
        WritableDataSet zz = Ops.maybeCopy(Ops.replicate(Ops.dataset(eu.createDatum((Object)"no")), 10));
        QDataSet r = Ops.where(Ops.lt((Object)Ops.sqrt(Ops.add(Ops.pow((Object)xx, (Object)2), Ops.pow((Object)yy, (Object)2))), 0.5));
        for (int i = 0; i < r.length(); ++i) {
            zz.putValue((int)r.value(i), eu.createDatum((Object)"Y").doubleValue((Units)eu));
        }
        return Ops.bundle(xx, yy, zz);
    }

    public static QDataSet rank3WaveformXYZ() {
        QDataSet xx = Schemes.rank2Waveform();
        QDataSet yy = Ops.multiply(-1, (Object)Schemes.rank2Waveform());
        QDataSet zz = Ops.add((Object)Schemes.rank2Waveform(), 1300);
        QDataSet result = Ops.bundle(xx, yy, zz);
        WritableDataSet bds = Ops.copy(Ops.zeros(3, 0));
        bds.putProperty("NAME", 0, "X");
        bds.putProperty("NAME", 1, "Y");
        bds.putProperty("NAME", 2, "Z");
        result = Ops.putProperty(result, "BUNDLE_2", (Object)bds);
        result = Ops.putProperty(result, "DEPEND_0", xx.property("DEPEND_0"));
        Ops.slice0(result, 0).property("BUNDLE_1");
        return result;
    }

    public static boolean isRank3WaveformXYZ(QDataSet ds) {
        QDataSet slice;
        if (ds.rank() != 3) {
            return false;
        }
        int[] qube = DataSetUtil.qubeDims(ds);
        if (qube == null) {
            return false;
        }
        QDataSet rec = ds.slice(0);
        QDataSet xoffset = (QDataSet)rec.property("DEPEND_0");
        if (xoffset == null) {
            return false;
        }
        return SemanticOps.getUnits(xoffset).isConvertibleTo(Units.seconds) && qube[2] < 5 && Schemes.isRank2Waveform(slice = Ops.slice2(ds, 0));
    }

    static {
        EnumerationUnits u1 = EnumerationUnits.create((Object)"complexCoordinates");
        DDataSet dep1 = DDataSet.createRank1(2);
        dep1.putValue(0, u1.createDatum((Object)"real").doubleValue((Units)u1));
        dep1.putValue(1, u1.createDatum((Object)"imag").doubleValue((Units)u1));
        dep1.putProperty("COORDINATE_FRAME", "ComplexNumber");
        dep1.putProperty("UNITS", u1);
        COMPLEX_COORDINATE_SYSTEM_DEPEND = dep1;
    }
}

