/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.jdesktop.layout.GroupLayout;

public class SetDepend1CadenceFilterEditorPanel
extends AbstractFilterEditorPanel {
    public static final String PROP_REGEX = "\\|setDepend1Cadence\\('?([\\+\\d.e]+)\\s*(\\w*)'?\\)";
    public JLabel jLabel1;
    public JLabel msgLabel;
    public JTextField scalarTF;
    public JComboBox unitsCB;
    Units currentUnits = null;

    public SetDepend1CadenceFilterEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.scalarTF = new JTextField();
        this.unitsCB = new JComboBox();
        this.msgLabel = new JLabel();
        this.jLabel1.setText("Depend1 Cadence:  ");
        this.scalarTF.setText("10");
        this.scalarTF.setPreferredSize(new Dimension(50, 27));
        List units = Units.getAllUnits();
        Units[] array = units.toArray(new Units[units.size()]);
        this.unitsCB.setEditable(true);
        this.unitsCB.setModel(new DefaultComboBoxModel<Units>(array));
        this.unitsCB.setMinimumSize(new Dimension(200, 27));
        this.unitsCB.setPreferredSize(new Dimension(200, 27));
        this.msgLabel.setText("<html><i>Explicity set the cadence of the measurements, typically corresponding to vertical position.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.msgLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.scalarTF, -2, 77, -2).addPreferredGap(0).add((Component)this.unitsCB, -2, 155, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.msgLabel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.scalarTF, -2, -1, -2).add((Component)this.unitsCB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile(PROP_REGEX);
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            this.scalarTF.setText(m.group(1));
            this.unitsCB.setSelectedItem(Units.lookupUnits((String)m.group(2)));
        } else {
            this.scalarTF.setText("1");
            this.unitsCB.setSelectedItem(Units.lookupUnits((String)""));
        }
    }

    @Override
    public String getFilter() {
        return "|setDepend1Cadence('" + this.scalarTF.getText() + this.unitsCB.getSelectedItem() + "')";
    }

    @Override
    public void setInput(QDataSet ds) {
        QDataSet dep = (QDataSet)ds.property("DEPEND_1");
        if (dep == null && SemanticOps.isJoin(ds)) {
            dep = (QDataSet)ds.slice(0).property("DEPEND_1");
        }
        if (dep != null) {
            Units u = SemanticOps.getUnits(dep);
            if (u != this.currentUnits) {
                Units[] uu = u.getOffsetUnits().getConvertibleUnits();
                Units oldu = (Units)this.unitsCB.getSelectedItem();
                this.unitsCB.setModel(new DefaultComboBoxModel<Units>(uu));
                this.unitsCB.setSelectedItem(oldu);
                this.currentUnits = u;
            }
        } else {
            this.msgLabel.setText("<html><i>Dataset has no DEPEND_1");
        }
    }
}

