/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.das2.qds.filters.AbstractFilterEditorPanel;
import org.das2.qds.filters.FilterEditorPanel;

public class SingleArgumentEditorPanel
extends AbstractFilterEditorPanel
implements FilterEditorPanel {
    private final String cmd;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public SingleArgumentEditorPanel(String cmd, String label, String doc, String[] examples) {
        this.initComponents();
        this.cmd = cmd;
        this.jLabel2.setText(doc);
        this.jLabel1.setText(label + ":");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(examples));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel1.setText("Label:");
        this.jLabel1.setToolTipText("Values within this range, inclusive of the min and max, are considered valid.");
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"-1e30 to 1e30", "-1 to 101", "0 to 1e38"}));
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont((float)this.jLabel2.getFont().getSize() - 2.0f));
        this.jLabel2.setText("This is the doc label that is passed into the constructor");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 331, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void setFilter(String filter) {
        Pattern p = Pattern.compile("\\|" + this.cmd + "\\((.+)\\)");
        Matcher m = p.matcher(filter);
        if (m.matches()) {
            String s = m.group(1);
            if (s.startsWith("'") && s.endsWith("'")) {
                s = s.substring(1, s.length() - 1);
            }
            s = s.trim();
            this.jComboBox1.setSelectedItem(s);
        }
    }

    @Override
    public String getFilter() {
        return "|" + this.cmd + "(" + this.jComboBox1.getSelectedItem() + ")";
    }
}

