/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.math.fft;

import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.math.fft.ComplexArray;
import org.das2.qds.math.fft.GeneralFFT;
import org.das2.qds.util.DataSetBuilder;

public class FFTUtil {
    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds) {
        return FFTUtil.fftPower(fft, vds, FFTUtil.getWindowUnity(vds.length()));
    }

    public static QDataSet getWindowUnity(final int size) {
        AbstractDataSet unity = new AbstractDataSet(){

            @Override
            public int rank() {
                return 1;
            }

            @Override
            public double value(int i) {
                return 1.0;
            }

            @Override
            public int length() {
                return size;
            }
        };
        return unity;
    }

    public static QDataSet getWindow10PercentEdgeCosine(final int size) {
        int i;
        int n = size;
        int maxlim = 410;
        int lim = Math.min(n / 10, maxlim);
        final double[] ww = new double[n];
        double step = Math.PI / (double)lim;
        for (i = 0; i < lim; ++i) {
            ww[i] = (1.0 - Math.cos(step * (double)i)) / 2.0;
            ww[n - i - 1] = ww[i];
        }
        for (i = lim; i < size - lim; ++i) {
            ww[i] = 1.0;
        }
        AbstractDataSet result = new AbstractDataSet(){

            @Override
            public int rank() {
                return 1;
            }

            @Override
            public double value(int i) {
                return ww[i];
            }

            @Override
            public int length() {
                return size;
            }
        };
        return result;
    }

    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds, QDataSet weights) {
        if (vds.length() > fft.n) {
            vds = vds.trim(0, fft.n);
        }
        double[] yreal = new double[fft.n];
        for (int i = 0; i < fft.n; ++i) {
            yreal[i] = vds.value(i) * weights.value(i);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        QDataSet xvds = (QDataSet)vds.property("DEPEND_0");
        QDataSet xtags = FFTUtil.getFrequencyDomainTags(xvds);
        double binsize = 2.0 * xtags.value(xtags.length() / 2) / (double)fft.n;
        DataSetBuilder builder = new DataSetBuilder(2, xvds.length() / 2, 2);
        for (int i = 0; i < xtags.length() / 2; ++i) {
            builder.putValue(i, 0, xtags.value(i));
            builder.putValue(i, (double)(i == 0 ? 1 : 4) * ComplexArray.magnitude2(ca, i) / binsize);
            builder.nextRecord();
        }
        return builder.getDataSet();
    }

    public static ComplexArray.Double fft(GeneralFFT fft, QDataSet vds, Units units) {
        double[] yreal = new double[vds.length()];
        for (int i = 0; i < vds.length(); ++i) {
            yreal[i] = vds.value(i);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        return ca;
    }

    public static double[] getFrequencyDomainTags(double fs, int size) {
        int i;
        double[] result = new double[size];
        int n = size;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = fs / (double)n * (double)i;
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = fs / (double)n * (double)(n21 - n + i);
        }
        return result;
    }

    static QDataSet getFrequencyDomainTags(QDataSet timeDomainTags) {
        int i;
        Units timeUnit = null;
        if (timeDomainTags == null) {
            throw new NullPointerException("null timeDomainTags passed into getFrequencyDomainTags");
        }
        timeUnit = (Units)timeDomainTags.property("UNITS");
        if (timeUnit == null) {
            timeUnit = Units.dimensionless;
        }
        double[] result = new double[timeDomainTags.length()];
        result[0] = 0.0;
        double T = timeDomainTags.value(1) - timeDomainTags.value(0);
        int n = result.length;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        Units frequencyUnit = UnitsUtil.getInverseUnit((Units)timeUnit.getOffsetUnits());
        DDataSet dresult = DDataSet.wrap(result);
        dresult.putProperty("UNITS", frequencyUnit);
        return dresult;
    }
}

