/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.math.matrix;

import org.das2.qds.math.matrix.Matrix;

public class ArrayMatrix
extends Matrix {
    private double[] array;

    public ArrayMatrix(int rows, int columns) {
        super(rows, columns);
        this.array = new double[rows * columns];
    }

    public ArrayMatrix(double[] array, int rows, int columns) {
        super(rows, columns);
        this.array = array;
        if (rows * columns != array.length) {
            throw new IllegalArgumentException("Array must be (rows * columns) in length");
        }
    }

    public ArrayMatrix(Matrix m) {
        super(m.rowCount(), m.columnCount());
        if (m instanceof ArrayMatrix) {
            this.array = (double[])((ArrayMatrix)m).array.clone();
        } else {
            this.array = new double[this.nRow * this.nCol];
            super.copy(m);
        }
    }

    @Override
    public void copy(Matrix m) {
        if (this.nRow != m.rowCount() || this.nCol != m.columnCount()) {
            throw new IllegalArgumentException();
        }
        if (m instanceof ArrayMatrix) {
            System.arraycopy(((ArrayMatrix)m).array, 0, this.array, 0, this.array.length);
        } else {
            super.copy(m);
        }
    }

    @Override
    public double get(int row, int col) {
        return this.array[row * this.nCol + col];
    }

    @Override
    public void rowTimes(int row, double s) {
        for (int iCol = 0; iCol < this.nCol; ++iCol) {
            int n = iCol + row * this.nCol;
            this.array[n] = this.array[n] * s;
        }
    }

    @Override
    public void rowTimesAddTo(int srcRow, double s, int dstRow) {
        if (srcRow == dstRow) {
            this.rowTimes(srcRow, s + 1.0);
        }
        for (int iCol = 0; iCol < this.nCol; ++iCol) {
            int n = iCol + dstRow * this.nCol;
            this.array[n] = this.array[n] + this.array[iCol + srcRow * this.nCol] * s;
        }
    }

    @Override
    public void set(int row, int col, double d) {
        this.array[col + row * this.nCol] = d;
    }

    @Override
    public void swapRows(int row1, int row2) {
        if (row1 == row2) {
            return;
        }
        double[] tmp = new double[this.nCol];
        int off1 = row1 * this.nCol;
        int off2 = row2 * this.nCol;
        System.arraycopy(this.array, off1, tmp, 0, this.nCol);
        System.arraycopy(this.array, off2, this.array, off1, this.nCol);
        System.arraycopy(tmp, 0, this.array, off2, this.nCol);
    }
}

