/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.math.matrix;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.das2.qds.math.matrix.ArrayMatrix;
import org.das2.qds.math.matrix.CompositeMatrix;
import org.das2.qds.math.matrix.Matrix;

public final class MatrixUtil {
    private static final DecimalFormat format = new DecimalFormat(" 0.0##;-");

    private MatrixUtil() {
    }

    public static void print(Matrix m, PrintStream out) {
        int nRow = m.rowCount();
        int nCol = m.columnCount();
        for (int iRow = 0; iRow < nRow; ++iRow) {
            out.print("[");
            for (int iCol = 0; iCol < nCol; ++iCol) {
                out.print(format.format(m.get(iRow, iCol)));
                out.print('\t');
            }
            out.println("]");
        }
    }

    public static Matrix inverse(Matrix m) {
        if (m.columnCount() != m.rowCount()) {
            throw new IllegalArgumentException("m must be a square matrix");
        }
        int nRow = m.rowCount();
        ArrayMatrix orig = new ArrayMatrix(m);
        Matrix inv = MatrixUtil.identity(nRow);
        CompositeMatrix both = new CompositeMatrix(orig, inv);
        for (int iRow = 0; iRow < nRow; ++iRow) {
            if (((Matrix)both).get(iRow, iRow) == 0.0) {
                MatrixUtil.pivot(both, iRow);
            }
            ((Matrix)both).rowTimes(iRow, 1.0 / ((Matrix)both).get(iRow, iRow));
            for (int i = 0; i < nRow; ++i) {
                if (i == iRow) continue;
                double scale = -((Matrix)both).get(i, iRow);
                ((Matrix)both).rowTimesAddTo(iRow, scale, i);
            }
        }
        return inv;
    }

    public static void pivot(Matrix m, int row) {
        int iRow = row + 1;
        int nRow = m.rowCount();
        if (iRow < nRow) {
            if (m.get(iRow, row) != 0.0) {
                m.swapRows(row, iRow);
                return;
            }
            MatrixUtil.print(m, System.err);
            throw new IllegalArgumentException("Can't pivot");
        }
    }

    public static Matrix identity(int rows) {
        ArrayMatrix m = new ArrayMatrix(new double[rows * rows], rows, rows);
        for (int iRow = 0; iRow < rows; ++iRow) {
            ((Matrix)m).set(iRow, iRow, 1.0);
        }
        return m;
    }

    public static Matrix multiply(Matrix m1, Matrix m2) {
        ArrayMatrix res = new ArrayMatrix(m1.rowCount(), m2.columnCount());
        MatrixUtil.multiply(m1, m2, res);
        return res;
    }

    public static void multiply(Matrix m1, Matrix m2, Matrix res) {
        if (m1.columnCount() != m2.rowCount()) {
            throw new IllegalArgumentException("");
        }
        int nRow = m1.rowCount();
        int nCol = m2.columnCount();
        int nInner = m1.columnCount();
        if (nRow != res.rowCount() || nCol != res.columnCount()) {
            // empty if block
        }
        for (int iRow = 0; iRow < nRow; ++iRow) {
            for (int iCol = 0; iCol < nCol; ++iCol) {
                double d = 0.0;
                for (int iInner = 0; iInner < nInner; ++iInner) {
                    d += m1.get(iRow, iInner) * m2.get(iInner, iCol);
                }
                res.set(iRow, iCol, d);
            }
        }
    }
}

