/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AsciiHeadersParser {
    public static final String PROP_DIMENSION = "DIMENSION";
    public static final String PROP_ELEMENT_NAMES = "ELEMENT_NAMES";
    public static final String PROP_ELEMENT_LABELS = "ELEMENT_LABELS";
    private static final Logger logger = Logger.getLogger("qdataset.ascii");
    char commented = (char)63;

    private String readNextLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        if (this.commented == '?' && line.length() > 0) {
            this.commented = (char)(line.charAt(0) == '#' ? 89 : 78);
        }
        if (line.startsWith("#")) {
            line = line.substring(1);
        } else if (this.commented == 'Y') {
            return null;
        }
        while (line != null && line.trim().length() == 0) {
            line = reader.readLine();
            if (line != null && line.startsWith("#")) {
                line = line.substring(1);
                continue;
            }
            if (this.commented == 'Y') {
                return null;
            }
            return line;
        }
        return line;
    }

    protected String prep(String s) {
        boolean dontHaveOpeningBrace = true;
        boolean addClosingBrace = false;
        boolean expectClosingBrace = false;
        int braceLevel = 0;
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new StringReader(s));){
                String line = this.readNextLine(reader);
                while (line != null) {
                    char nextChar;
                    String trimLine = line.trim();
                    if (dontHaveOpeningBrace) {
                        if (!trimLine.startsWith("{")) {
                            line = "{" + line;
                            addClosingBrace = true;
                        } else {
                            expectClosingBrace = true;
                        }
                        dontHaveOpeningBrace = false;
                    }
                    String nextLine = this.readNextLine(reader);
                    char lastChar = trimLine.length() == 0 ? (char)' ' : (char)trimLine.charAt(trimLine.length() - 1);
                    if ((lastChar == '\"' || Character.isDigit(lastChar) || lastChar == ']' || lastChar == '}') && nextLine != null && nextLine.trim().length() > 0 && (nextChar = nextLine.trim().charAt(0)) != ',' && nextChar != ']') {
                        line = line + ",";
                    }
                    boolean inQuote = false;
                    boolean backSlash = false;
                    block18: for (int i = 0; i < trimLine.length(); ++i) {
                        char ch = trimLine.charAt(i);
                        if (backSlash) {
                            backSlash = false;
                            if (ch == '\"') continue;
                        }
                        switch (ch) {
                            case '{': {
                                if (inQuote) continue block18;
                                ++braceLevel;
                                continue block18;
                            }
                            case '}': {
                                if (inQuote) continue block18;
                                --braceLevel;
                                continue block18;
                            }
                            case '\"': {
                                inQuote = !inQuote;
                                continue block18;
                            }
                            case '\\': {
                                backSlash = true;
                                continue block18;
                            }
                        }
                    }
                    sb.append(line).append("\n");
                    line = nextLine;
                    if (!expectClosingBrace || braceLevel != 0) continue;
                    line = null;
                }
            }
            if (addClosingBrace) {
                sb.append("}");
            }
            return sb.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String[] toStringArray(JSONArray ja) throws JSONException {
        String[] result = new String[ja.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ja.getString(i);
        }
        return result;
    }

    private static void calcUserProperties(JSONObject jo, Map<String, Object> result) throws JSONException {
        String[] names;
        for (String name : names = JSONObject.getNames((JSONObject)jo)) {
            Object val = jo.get(name);
            if (val instanceof JSONObject) {
                HashMap<String, Object> child = new HashMap<String, Object>();
                AsciiHeadersParser.calcUserProperties(jo, child);
                continue;
            }
            if (val instanceof JSONArray) {
                result.put(name, (JSONArray)val);
                continue;
            }
            result.put(name, val);
        }
    }

    private static BundleDescriptor calcBundleDescriptor(JSONObject jo, String[] columns, String[] columnLabels) {
        String[] snames = new String[columns.length];
        BundleDescriptor bd = new BundleDescriptor();
        String dep0Name = null;
        LinkedHashMap<String, Integer> dsToPosition = new LinkedHashMap<String, Integer>();
        int ids = 0;
        LinkedHashMap<JSONObject, String> messages = new LinkedHashMap<JSONObject, String>();
        String[] names = JSONObject.getNames((JSONObject)jo);
        for (int ivar = 0; ivar < names.length; ++ivar) {
            String jsonName = names[ivar];
            String name = Ops.safeName(jsonName);
            logger.log(Level.FINE, "processing name[{0}]={1}", new Object[]{ivar, jsonName});
            try {
                int j;
                int icol;
                String lookFor;
                int j2;
                int[] idims;
                Object o = jo.get(jsonName);
                if (!(o instanceof JSONObject)) {
                    Object oval = bd.property("USER_PROPERTIES");
                    if (oval != null && !(oval instanceof Map)) {
                        throw new IllegalArgumentException("USER_PROPERTIES is not a map");
                    }
                    HashMap<String, Object> val = (HashMap<String, Object>)oval;
                    if (val == null) {
                        val = new HashMap<String, Object>();
                        bd.putProperty("USER_PROPERTIES", val);
                    }
                    val.put(jsonName, o);
                    continue;
                }
                JSONObject jo1 = (JSONObject)o;
                if (jsonName.equals("USER_PROPERTIES")) {
                    HashMap<String, Object> val = new HashMap<String, Object>();
                    AsciiHeadersParser.calcUserProperties(jo1, val);
                    bd.putProperty(jsonName, val);
                    continue;
                }
                if (!jo1.has(PROP_DIMENSION)) {
                    idims = new int[]{};
                } else {
                    Object dims = jo1.get(PROP_DIMENSION);
                    if (dims instanceof JSONArray) {
                        idims = new int[((JSONArray)dims).length()];
                        for (j2 = 0; j2 < idims.length; ++j2) {
                            idims[j2] = ((JSONArray)dims).getInt(j2);
                        }
                        if (idims.length == 1 && idims[0] == 1 && !jo1.has(PROP_ELEMENT_NAMES)) {
                            idims = new int[]{};
                        }
                    } else if (dims instanceof Integer) {
                        idims = new int[]{(Integer)dims};
                    } else {
                        throw new IllegalArgumentException("Expected array for DIMENSION in " + jsonName);
                    }
                }
                int total = idims.length == 0 ? 1 : idims[0];
                for (j2 = 1; j2 < idims.length; ++j2) {
                    total *= idims[j2];
                }
                String[] labels = null;
                if (jo1.has(PROP_ELEMENT_LABELS)) {
                    Object olabels = jo1.get(PROP_ELEMENT_LABELS);
                    if (olabels instanceof JSONArray) {
                        labels = AsciiHeadersParser.toStringArray((JSONArray)olabels);
                    } else if (olabels instanceof String && total == 1) {
                        logger.log(Level.FINE, "scalar for 1-element array for ELEMENT_LABELS in {0} is acceptable", jsonName);
                        labels = new String[]{(String)olabels};
                    } else {
                        logger.log(Level.FINE, "unable to use ELEMENT_LABELS in {0}, should be array", jsonName);
                    }
                }
                String[] elementNames = null;
                if (jo1.has(PROP_ELEMENT_NAMES)) {
                    Object oelements = jo1.get(PROP_ELEMENT_NAMES);
                    if (oelements instanceof JSONArray) {
                        elementNames = AsciiHeadersParser.toStringArray((JSONArray)oelements);
                    } else if (oelements instanceof String && total == 1) {
                        logger.log(Level.FINE, "scalar for 1-element array for ELEMENT_NAMES in {0} is acceptable", jsonName);
                        elementNames = new String[]{(String)oelements};
                    } else {
                        logger.log(Level.FINE, "unable to use ELEMENT_NAMES in {0}, should be array", jsonName);
                    }
                }
                if (elementNames != null) {
                    int i;
                    int j3;
                    for (String elementName : elementNames) {
                        if (elementName != null) continue;
                        throw new IllegalArgumentException("rich ascii JSON header contains error");
                    }
                    lookFor = elementNames[0];
                    icol = -1;
                    int count = 0;
                    ArrayList<Integer> icols = new ArrayList<Integer>();
                    if (!jo1.has("VALUES")) {
                        for (j3 = 0; j3 < columns.length; ++j3) {
                            if (!columns[j3].equals(lookFor)) continue;
                            logger.log(Level.FINE, "found column named {0} at {1}", new Object[]{lookFor, j3});
                            if (count == 0) {
                                icol = j3;
                            }
                            ++count;
                            icols.add(j3);
                        }
                    }
                    if (icol != -1) {
                        if (count > 1) {
                            logger.log(Level.WARNING, "Multiple columns have label \"{0}\": {1}", new Object[]{lookFor, icols});
                            if (jo1.has("START_COLUMN")) {
                                icol = jo1.getInt("START_COLUMN");
                                logger.log(Level.FINE, "using START_COLUMN={1} property for {0}", new Object[]{lookFor, icol});
                            } else {
                                logger.log(Level.FINE, "using first column ({1}) for {0}", new Object[]{lookFor, icol});
                            }
                            if (labels == null) {
                                labels = new String[elementNames.length];
                                for (i = 0; i < elementNames.length; ++i) {
                                    labels[i] = columnLabels[i + icol];
                                }
                            }
                            bd.addDataSet(name, ids, idims, elementNames, labels);
                        } else {
                            if (labels == null) {
                                labels = new String[elementNames.length];
                                for (i = 0; i < elementNames.length; ++i) {
                                    labels[i] = columnLabels[i + icol];
                                }
                            }
                            bd.addDataSet(name, ids, idims, elementNames, labels);
                        }
                    } else if (jo1.has("START_COLUMN")) {
                        icol = jo1.getInt("START_COLUMN");
                        logger.log(Level.FINE, "using START_COLUMN={1} property for {0}", new Object[]{lookFor, icol});
                        if (labels == null) {
                            labels = new String[elementNames.length];
                            for (i = 0; i < elementNames.length; ++i) {
                                labels[i] = columnLabels[i + icol];
                                if (labels[i] != null) continue;
                                labels[i] = elementNames[i];
                            }
                        }
                        bd.addDataSet(name, ids, idims, elementNames, labels);
                    } else if (jo1.has("VALUES")) {
                        logger.log(Level.FINE, "missing START_COLUMN element, {0} must be a DEPEND_1 dataset", name);
                        int n = DataSetUtil.product(idims);
                        JSONArray arr = jo1.getJSONArray("VALUES");
                        if (n != arr.length()) {
                            throw new IllegalArgumentException("VALUES element doesn't match DIMENSION under " + jsonName);
                        }
                        DDataSet vv = AsciiHeadersParser.getDataSet(jo1, arr, idims);
                        vv.putProperty("NAME", name);
                        bd.addDataSet(name, vv);
                    } else {
                        throw new IllegalArgumentException("Couldn't find column starting with: " + lookFor);
                    }
                    if (icol > -1) {
                        dsToPosition.put(name, icol);
                        ids += DataSetUtil.product(idims);
                    }
                    if (icol > -1) {
                        for (j3 = 0; j3 < total; ++j3) {
                            snames[icol + j3] = name;
                        }
                    }
                    if (total == elementNames.length) continue;
                    throw new IllegalArgumentException("expected " + total + " items in ELEMENTS");
                }
                lookFor = name;
                icol = -1;
                if (total > 1) {
                    elementNames = new String[total];
                    for (int i = 0; i < total; ++i) {
                        elementNames[i] = name + "_" + i;
                    }
                }
                for (j = 0; j < columns.length; ++j) {
                    if (!columns[j].equals(lookFor)) continue;
                    logger.log(Level.FINE, "found column named {0} at {1}", new Object[]{lookFor, j});
                    icol = j;
                    bd.addDataSet(name, ids, idims, elementNames, labels);
                    break;
                }
                if (icol == -1) {
                    if (jo1.has("START_COLUMN")) {
                        icol = jo1.getInt("START_COLUMN");
                        logger.log(Level.FINE, "using START_COLUMN={1} property for {0}", new Object[]{lookFor, icol});
                        bd.addDataSet(name, ids, idims, elementNames, labels);
                    } else {
                        if (jo1.has("VALUES")) {
                            JSONArray arr;
                            int n = DataSetUtil.product(idims);
                            if (n != (arr = jo1.getJSONArray("VALUES")).length()) {
                                throw new IllegalArgumentException("VALUES element doesn't match DIMENSION under " + jsonName);
                            }
                            bd.addDataSet(name, AsciiHeadersParser.getDataSet(jo1, arr, idims));
                            continue;
                        }
                        messages.put(jo1, "Couldn't find column starting with: " + lookFor);
                        if (columns[0].equals("field0")) {
                            throw new IllegalArgumentException("Couldn't find column starting with \"" + lookFor + "\".  Are the columns named?");
                        }
                    }
                }
                if (icol > -1) {
                    dsToPosition.put(name, icol);
                    ids += DataSetUtil.product(idims);
                }
                if (icol > -1) {
                    for (j = 0; j < total; ++j) {
                        if (snames[icol + j] != null) {
                            messages.put(jo1, "column " + (icol + j) + " is already used by " + snames[icol + j] + ", cannot be used by " + name);
                        }
                        snames[icol + j] = name;
                    }
                }
                if (icol != 0 || !jo1.optString("dtype", "").equals("UTC") && !jo1.optString("UNITS", "").equals("UTC")) continue;
                dep0Name = name;
                continue;
            }
            catch (JSONException ex) {
                logger.log(Level.WARNING, "Exception encountered when handling {0}:", jsonName);
                logger.log(Level.WARNING, ex.toString(), ex);
            }
        }
        if (dep0Name != null) {
            for (int i = 0; i < bd.length(); ++i) {
                if (dep0Name.equals(bd.property("NAME", i)) || bd.property("DEPENDNAME_0", i) != null) continue;
                bd.putProperty("DEPENDNAME_0", i, dep0Name);
            }
        }
        if (messages.size() > 0) {
            for (Map.Entry jos1 : messages.entrySet()) {
                logger.log(Level.INFO, "{0}", jos1.getValue());
            }
        }
        Map<String, Object> props = DataSetUtil.getProperties(bd, DataSetUtil.globalProperties(), null);
        bd = bd.resortDataSets(dsToPosition);
        DataSetUtil.putProperties(props, bd);
        for (Map.Entry ee : dsToPosition.entrySet()) {
            int i = (Integer)ee.getValue();
            if (snames[i] == null) {
                bd.addDataSet(columns[i], ids, new int[0]);
            }
            ++ids;
        }
        return bd;
    }

    private static DDataSet getDataSet(JSONObject jo, JSONArray values, int[] dims) throws JSONException {
        DDataSet result;
        double[] dd = new double[values.length()];
        Object[] oo = new Object[values.length()];
        Units u = Units.dimensionless;
        for (int i = 0; i < values.length(); ++i) {
            try {
                dd[i] = values.getDouble(i);
                continue;
            }
            catch (JSONException ex) {
                String s = values.getString(i);
                try {
                    if (s.contains(",")) {
                        String[] ss = s.split(",");
                        double[] dd1 = new double[ss.length];
                        for (int j = 0; j < ss.length; ++j) {
                            dd1[j] = Double.parseDouble(ss[j]);
                        }
                        oo[i] = dd1;
                        continue;
                    }
                    dd[i] = Units.us2000.parse(s).doubleValue((Units)Units.us2000);
                    u = Units.us2000;
                    continue;
                }
                catch (ParseException ex2) {
                    throw ex;
                }
            }
        }
        if (oo[0] != null) {
            int n = Array.getLength(oo[0]);
            result = DDataSet.createRank2(values.length(), n);
            for (int i = 0; i < oo.length; ++i) {
                for (int j = 0; j < n; ++j) {
                    result.putValue(i, j, Array.getDouble(oo[i], j));
                }
            }
        } else {
            result = DDataSet.wrap(dd, dims);
        }
        if (u != Units.dimensionless) {
            result.putProperty("UNITS", u);
        }
        AsciiHeadersParser.fillMetadata1(result, jo);
        return result;
    }

    public static BundleDescriptor parseMetadataHapi(JSONObject doc) throws JSONException, ParseException {
        JSONArray parameters = doc.getJSONArray("parameters");
        int nparameters = parameters.length();
        ParamDescription[] pds = new ParamDescription[nparameters];
        for (int i = 0; i < nparameters; ++i) {
            String type;
            String name = parameters.getJSONObject(i).getString("name");
            pds[i] = new ParamDescription(name);
            if (parameters.getJSONObject(i).has("type")) {
                type = parameters.getJSONObject(i).getString("type");
                if (type == null) {
                    type = "";
                }
            } else {
                type = "";
            }
            if (type.equals("")) {
                logger.log(Level.FINE, "type is not defined: {0}", name);
            }
            if (type.equalsIgnoreCase("isotime")) {
                if (!type.equals("isotime")) {
                    logger.log(Level.WARNING, "isotime should not be capitalized: {0}", type);
                }
                pds[i].units = Units.us2000;
                continue;
            }
            if (parameters.getJSONObject(i).has("units")) {
                String sunits = parameters.getJSONObject(i).getString("units");
                if (sunits != null) {
                    pds[i].units = Units.lookupUnits((String)sunits);
                }
            } else {
                pds[i].units = Units.dimensionless;
            }
            if (parameters.getJSONObject(i).has("fill")) {
                String sfill = parameters.getJSONObject(i).getString("fill");
                if (sfill != null) {
                    pds[i].fillValue = pds[i].units.parse(sfill).doubleValue(pds[i].units);
                    pds[i].hasFill = true;
                }
            } else {
                pds[i].fillValue = -1.0E31;
            }
            if (parameters.getJSONObject(i).has("description")) {
                pds[i].description = parameters.getJSONObject(i).getString("description");
                if (pds[i].description != null) continue;
                pds[i].description = "";
                continue;
            }
            pds[i].description = "";
        }
        BundleDescriptor bds = new BundleDescriptor();
        for (int i = 0; i < pds.length; ++i) {
            bds.addDataSet(Ops.safeName(pds[i].name), i, new int[0]);
        }
        return bds;
    }

    public static BundleDescriptor parseMetadata(String header, String[] columns, String[] columnLabels) throws ParseException {
        try {
            AsciiHeadersParser ahp = new AsciiHeadersParser();
            String sjson = ahp.prep(header);
            JSONObject jo = new JSONObject(sjson);
            if (jo.has("HAPI")) {
                BundleDescriptor bd = AsciiHeadersParser.parseMetadataHapi(jo);
                return bd;
            }
            BundleDescriptor bd = AsciiHeadersParser.calcBundleDescriptor(jo, columns, columnLabels);
            AsciiHeadersParser.fillMetadata(bd, jo);
            return bd;
        }
        catch (IllegalArgumentException | JSONException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.toString(), 0);
        }
    }

    private static Object coerceToType(String propName, Object propValue) {
        try {
            switch (propName) {
                case "UNITS": {
                    return Units.lookupUnits((String)String.valueOf(propValue));
                }
                case "FILL_VALUE": {
                    return Double.parseDouble(String.valueOf(propValue));
                }
                case "VALID_MIN": {
                    return Double.parseDouble(String.valueOf(propValue));
                }
                case "VALID_MAX": {
                    return Double.parseDouble(String.valueOf(propValue));
                }
                case "TYPICAL_MIN": {
                    return Double.parseDouble(String.valueOf(propValue));
                }
                case "TYPICAL_MAX": {
                    return Double.parseDouble(String.valueOf(propValue));
                }
                case "SCALE_TYPE": {
                    return String.valueOf(propValue);
                }
                case "MONOTONIC": {
                    return Boolean.valueOf(String.valueOf(propValue));
                }
                case "CADENCE": {
                    return DataSetUtil.asDataSet(DatumUtil.parse((String)String.valueOf(propValue)));
                }
                case "FORMAT": {
                    return String.valueOf(propValue);
                }
            }
            return String.valueOf(propValue);
        }
        catch (NumberFormatException | ParseException ex) {
            logger.log(Level.WARNING, "unable to parse value for {0}: {1}", new Object[]{propName, propValue});
            return null;
        }
    }

    private static Object convertJsonArray(JSONArray array, Class c) throws JSONException {
        Object result = Array.newInstance(c, array.length());
        for (int i = 0; i < array.length(); ++i) {
            Array.set(result, i, array.get(i));
        }
        return result;
    }

    private static void fillMetadata(BundleDescriptor bd, JSONObject jo) throws JSONException {
        Iterator it = jo.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object o = jo.get(key);
            if (!(o instanceof JSONObject)) {
                Object oUserProperties = bd.property("USER_PROPERTIES");
                if (oUserProperties != null && !(oUserProperties instanceof Map)) {
                    throw new IllegalArgumentException("USER_PROPERTIES is not a map");
                }
                LinkedHashMap<String, Object> userProperties = (LinkedHashMap<String, Object>)oUserProperties;
                if (userProperties == null) {
                    userProperties = new LinkedHashMap<String, Object>();
                    bd.putProperty("USER_PROPERTIES", userProperties);
                }
                if (o instanceof JSONArray) {
                    JSONArray ja = (JSONArray)o;
                    String[] arr = new String[ja.length()];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = ja.get(i).toString();
                    }
                    userProperties.put(key, arr);
                    continue;
                }
                userProperties.put(key, o.toString());
                continue;
            }
            String name = Ops.safeName(key);
            int ids = bd.indexOf(name);
            if (ids == -1) {
                JSONObject inlineObject = (JSONObject)o;
                if (inlineObject.has("VALUES")) continue;
                logger.log(Level.FINE, "metadata found for key {0}, but values are not found in the ascii file columns", key);
                continue;
            }
            JSONObject propsj = (JSONObject)o;
            bd.putProperty("NAME", ids, name);
            Iterator props = propsj.keys();
            while (props.hasNext()) {
                String prop = (String)props.next();
                Object sv = propsj.get(prop);
                if (prop.equals(PROP_DIMENSION) || prop.equals("START_COLUMN") || prop.equals(PROP_ELEMENT_NAMES) || prop.equals(PROP_ELEMENT_LABELS)) {
                    if (!prop.equals(PROP_ELEMENT_NAMES) || sv instanceof JSONArray) {
                        // empty if block
                    }
                    if (bd.property("RENDER_TYPE", ids) != null) continue;
                    bd.putProperty("RENDER_TYPE", ids, "series");
                    continue;
                }
                if (prop.equals("UNITS") && (sv.equals("UTC") || sv.equals("UT"))) {
                    bd.putProperty(prop, ids, Units.us2000);
                    continue;
                }
                if (prop.equals("dtype") && (sv.equals("UTC") || sv.equals("UT"))) {
                    bd.putProperty("UNITS", ids, Units.us2000);
                    continue;
                }
                if (prop.equals("ENUM") && sv instanceof JSONArray) {
                    JSONArray joa = (JSONArray)sv;
                    EnumerationUnits uu = EnumerationUnits.create((Object)name);
                    for (int i = 0; i < joa.length(); ++i) {
                        uu.createDatum((Object)joa.getString(i));
                    }
                    bd.putProperty("UNITS", ids, uu);
                    continue;
                }
                if (prop.equals("LABEL")) {
                    if (bd.length(ids) > 0) {
                        bd.putProperty("ELEMENT_LABEL", ids, sv);
                        continue;
                    }
                    bd.putProperty("LABEL", ids, sv);
                    continue;
                }
                if (prop.equals("DEPEND_0")) continue;
                if (prop.equals("DEPEND_1")) {
                    bd.putProperty("DEPENDNAME_1", ids, sv);
                    continue;
                }
                if (sv instanceof JSONArray) {
                    JSONArray asv = (JSONArray)sv;
                    Object item = asv.get(0);
                    Class<?> clas = item.getClass();
                    boolean allSameValue = true;
                    boolean allSameClass = true;
                    for (int i = 1; i < asv.length(); ++i) {
                        if (!item.equals(asv.get(i))) {
                            allSameValue = false;
                        }
                        if (item.getClass().equals(clas)) continue;
                        allSameClass = false;
                    }
                    if (allSameValue) {
                        Object v = AsciiHeadersParser.coerceToType(prop, item);
                        bd.putProperty(prop, ids, v);
                        continue;
                    }
                    if (DataSetUtil.isDimensionProperty(prop)) {
                        logger.log(Level.WARNING, "invalid value for property {0}: {1}", new Object[]{prop, sv});
                        continue;
                    }
                    LinkedHashMap oUserProperties = bd.property("USER_PROPERTIES", ids);
                    if (oUserProperties == null && oUserProperties == null) {
                        oUserProperties = new LinkedHashMap();
                        bd.putProperty("USER_PROPERTIES", ids, oUserProperties);
                    }
                    if (oUserProperties == null) continue;
                    if (!(oUserProperties instanceof Map)) {
                        throw new IllegalArgumentException("USER_PROPERTIES is not a map");
                    }
                    Map userProperties = oUserProperties;
                    if (allSameClass) {
                        userProperties.put(prop, AsciiHeadersParser.convertJsonArray(asv, clas));
                        continue;
                    }
                    userProperties.put(prop, AsciiHeadersParser.convertJsonArray(asv, Object.class));
                    continue;
                }
                if (sv instanceof JSONObject) {
                    logger.log(Level.WARNING, "invalid value for property {0}: {1}", new Object[]{prop, sv});
                    continue;
                }
                Object v = AsciiHeadersParser.coerceToType(prop, sv);
                try {
                    bd.putProperty(prop, ids, v);
                }
                catch (IllegalArgumentException ex) {
                    bd.putProperty(prop, ids, null);
                    ex.printStackTrace();
                }
            }
        }
    }

    private static void fillMetadata1(MutablePropertyDataSet bd, JSONObject jo) throws JSONException {
        JSONObject propsj = jo;
        Iterator props = propsj.keys();
        while (props.hasNext()) {
            String prop = (String)props.next();
            Object sv = propsj.get(prop);
            if (prop.equals("UNITS") && (sv.equals("UTC") || sv.equals("UT"))) {
                bd.putProperty(prop, Units.us2000);
                continue;
            }
            Object v = AsciiHeadersParser.coerceToType(prop, sv);
            bd.putProperty(prop, v);
        }
    }

    public static QDataSet getInlineDataSet(QDataSet bds, String name) {
        if (bds instanceof BundleDescriptor) {
            Map<String, QDataSet> inlineDataSets = ((BundleDescriptor)bds).inlineDataSets;
            QDataSet result = inlineDataSets.get(name);
            return result;
        }
        throw new IllegalArgumentException("bds is not a BundleDescriptor created by this class");
    }

    public static String[] getInlineDataSetNames(QDataSet bds) {
        if (bds instanceof BundleDescriptor) {
            Map<String, QDataSet> inlineDataSets = ((BundleDescriptor)bds).inlineDataSets;
            return inlineDataSets.keySet().toArray(new String[inlineDataSets.size()]);
        }
        throw new IllegalArgumentException("bds is not a BundleDescriptor created by this class");
    }

    public static class BundleDescriptor
    extends AbstractDataSet {
        Map<String, Integer> datasets;
        Map<Integer, String> datasets2;
        Map<String, QDataSet> inlineDataSets;
        Map<Integer, Map<String, Object>> props;
        Map<String, int[]> qubes;

        BundleDescriptor() {
            this.properties = new LinkedHashMap();
            this.datasets = new LinkedHashMap<String, Integer>();
            this.datasets2 = new LinkedHashMap<Integer, String>();
            this.inlineDataSets = new LinkedHashMap<String, QDataSet>();
            this.props = new LinkedHashMap<Integer, Map<String, Object>>();
            this.qubes = new LinkedHashMap<String, int[]>();
        }

        public int indexOf(String name) {
            Integer i = this.datasets.get(name);
            if (i == null) {
                return -1;
            }
            return i;
        }

        protected void addDataSet(String name, int i, int[] qube) {
            this.addDataSet(name, i, qube, null, null);
        }

        protected void addDataSet(String name, int i, int[] qube, String[] names, String[] labels) {
            int len = DataSetUtil.product(qube);
            name = Ops.safeName(name);
            this.datasets.put(name, i);
            for (int j = 0; j < len; ++j) {
                this.datasets2.put(i + j, name);
            }
            this.putProperty("LABEL", i, name);
            this.putProperty("NAME", i, name);
            if (qube.length > 0) {
                this.putProperty("QUBE", i, Boolean.TRUE);
                this.putProperty("ELEMENT_NAME", i, name);
                this.putProperty("ELEMENT_LABEL", i, name);
                this.putProperty("START_INDEX", i, i);
            }
            if (qube.length > 0 && names != null) {
                for (int k = 0; k < names.length; ++k) {
                    names[k] = Ops.safeName(names[k]);
                }
            }
            if (names != null) {
                this.putProperty(AsciiHeadersParser.PROP_ELEMENT_NAMES, i, names);
            }
            if (labels != null) {
                this.putProperty(AsciiHeadersParser.PROP_ELEMENT_LABELS, i, labels);
            }
            this.qubes.put(name, qube);
        }

        private void addDataSet(String lookFor, QDataSet dataSet) {
            this.inlineDataSets.put(lookFor, dataSet);
        }

        @Override
        public int rank() {
            return 2;
        }

        @Override
        public int length() {
            return this.datasets2.size();
        }

        @Override
        public int length(int i) {
            String name = this.datasets2.get(i);
            int[] qube = this.qubes.get(name);
            if (qube == null || qube.length == 0) {
                return 0;
            }
            return qube.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object property(String name, int ic) {
            BundleDescriptor bundleDescriptor = this;
            synchronized (bundleDescriptor) {
                int i;
                Map<String, Object> props1;
                String[] names;
                Map<String, Object> props12;
                String dsname = this.datasets2.get(ic);
                if (this.datasets == null || this.datasets.get(dsname) == null) {
                    throw new IllegalArgumentException("No slice at " + ic);
                }
                int ids = this.datasets.get(dsname);
                if (name.equals("NAME") && (props12 = this.props.get(ids)) != null && (names = (String[])props12.get(AsciiHeadersParser.PROP_ELEMENT_NAMES)) != null) {
                    return names[ic - ids];
                }
                if (name.equals("LABEL") && (props12 = this.props.get(ids)) != null) {
                    String[] labels = (String[])props12.get(AsciiHeadersParser.PROP_ELEMENT_LABELS);
                    if (labels == null) {
                        labels = (String[])props12.get(AsciiHeadersParser.PROP_ELEMENT_NAMES);
                    }
                    if (labels != null) {
                        if (ic - ids >= labels.length) {
                            return "";
                        }
                        return labels[ic - ids];
                    }
                }
                if ((props1 = this.props.get(i = this.datasets.get(dsname).intValue())) == null) {
                    return null;
                }
                return props1.get(name);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public synchronized void putProperty(String name, int ic, Object v) {
            String dsname = this.datasets2.get(ic);
            int i = this.datasets.get(dsname);
            Map<String, Object> props1 = this.props.get(i);
            if (props1 == null) {
                props1 = new LinkedHashMap<String, Object>();
                this.props.put(i, props1);
            }
            if (name.equals("DEPENDNAME_1")) {
                QDataSet dep1 = this.inlineDataSets.get((String)v);
                if (dep1 != null) {
                    props1.put("DEPEND_1", this.inlineDataSets.get((String)v));
                    return;
                }
                logger.log(Level.WARNING, "unable to resolve property \"{0}\"=\"{1}\" of \"{2}\".  No such dataset found.", new Object[]{name, v, this.datasets2.get(i)});
                props1.put(name, v);
                return;
            }
            if (name.startsWith("DEPEND_") && !name.equals("DEPEND_0") && v instanceof String) {
                if (this.inlineDataSets.containsKey((String)v)) {
                    props1.put(name, this.inlineDataSets.get((String)v));
                    return;
                }
                logger.log(Level.WARNING, "unable to resolve property \"{0}\"=\"{1}\" of \"{2}\".  No such dataset found.", new Object[]{name, v, this.datasets2.get(i)});
                throw new IllegalArgumentException("unable to resolve property \"" + name + "\"=\"" + v + "\" of \"" + this.datasets2.get(i) + "\".  No such dataset found.");
            }
            props1.put(name, v);
        }

        @Override
        public double value(int i0, int i1) {
            String name = this.datasets2.get(i0);
            int[] qube = this.qubes.get(name);
            if (qube == null) {
                throw new IndexOutOfBoundsException("length=0");
            }
            if (i1 >= qube.length) {
                throw new ArrayIndexOutOfBoundsException("qube is " + qube.length + ".");
            }
            return qube[i1];
        }

        @Override
        public QDataSet trim(int start, int end) {
            return DataSetOps.trim(this, start, end - start);
        }

        BundleDescriptor resortDataSets(Map<String, Integer> dsToPosition) {
            LinkedHashMap<Integer, String> positionToDs = new LinkedHashMap<Integer, String>();
            int maxColumn = -1;
            for (Map.Entry<String, Integer> entry : dsToPosition.entrySet()) {
                if (positionToDs.get(entry.getValue()) != null) {
                    throw new IllegalArgumentException("two datasets occupy the same position: " + entry.getKey() + "," + (String)positionToDs.get(entry.getValue()));
                }
                positionToDs.put(entry.getValue(), entry.getKey());
                if (maxColumn >= entry.getValue()) continue;
                maxColumn = entry.getValue();
            }
            BundleDescriptor newb = new BundleDescriptor();
            int i = 0;
            for (int column = 0; i < this.length() && column <= maxColumn; ++column) {
                if (!positionToDs.containsKey(column)) continue;
                String name = (String)positionToDs.get(column);
                Integer ioldIndex = this.datasets.get(name);
                if (ioldIndex == null) {
                    logger.log(Level.WARNING, "unable to find dataset for \"{0}\"", name);
                }
                int oldIndex = this.datasets.get(name);
                int[] qube = this.qubes.get(name);
                int len = DataSetUtil.product(qube);
                newb.addDataSet(name, i, qube);
                Map<String, Object> pp = this.props.get(oldIndex);
                pp.put("START_INDEX", i);
                newb.props.put(i, pp);
                i += len;
            }
            for (Map.Entry<String, QDataSet> e : this.inlineDataSets.entrySet()) {
                newb.addDataSet(e.getKey(), e.getValue());
            }
            return newb;
        }
    }

    private static class ParamDescription {
        boolean hasFill = false;
        double fillValue = -1.0E38;
        Units units = Units.dimensionless;
        String name = "";
        String description = "";

        private ParamDescription(String name) {
            this.name = name;
        }

        public boolean getHasFill() {
            return this.hasFill;
        }

        public double getFillValue() {
            return this.fillValue;
        }
    }
}

