/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AsciiHeadersParser;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class AsciiParser {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.ascii");
    Pattern propertyPattern = null;
    String commentPrefix = "#";
    final int LINE_LENGTH_LIMIT = 100000;
    String[] fieldNames;
    MutablePropertyDataSet bundleDescriptor;
    Units[] units;
    int nonEnumFields = -1;
    String[] fieldUnits;
    String[] fieldLabels;
    FieldParser[] fieldParsers;
    static final String numberPart = "[\\d\\.eE\\+\\-]+";
    static final String decimalRegex = "[\\d\\.eE\\+\\-]+";
    int skipLines;
    int recordCountLimit = Integer.MAX_VALUE;
    int recordStart = 0;
    int fieldCount;
    private Boolean isRichAscii = null;
    public static final Pattern NAME_COLON_VALUE_PATTERN = Pattern.compile("\\s*([a-zA-Z_].*?)\\s*\\:\\s*(.+)\\s*");
    public static final Pattern NAME_EQUAL_VALUE_PATTERN = Pattern.compile("\\s*([a-zA-Z_].*?)\\s*\\=\\s*(.+)\\s*");
    private static final Pattern COLUMN_ID_HEADER_PATTERN = Pattern.compile("\\s*\"?([a-zA-Z][a-zA-Z \\-_0-9\\#]*)([\\(\\[]([a-zA-Z_\\!\\.\\[\\-\\]\\(\\)0-9//\\*\\^\\%\\\u00b0\\#]*)[\\)\\]])?\"?\\s*");
    private static final Pattern COLUMN_CHANNEL_HEADER_PATTERN = Pattern.compile("\\s*\"?(([a-zA-Z_]*)(\\d*\\.?\\d*([eE]\\d+)?)\\-(\\d*\\.?\\d*([eE]\\d+)?))\"?\\s*");
    public static final String PROPERTY_FIELD_NAMES = "fieldNames";
    public static final String PROPERTY_FILE_HEADER = "fileHeader";
    public static final String PROPERTY_FIRST_RECORD = "firstRecord";
    public static final String PROPERTY_FIELD_PARSER = "fieldParser";
    public static final String DELIM_COMMA = ",";
    public static final String DELIM_TAB = "\t";
    public static final String DELIM_WHITESPACE = "\\s+";
    private static final int HEADER_LENGTH_LIMIT = 1000;
    public static final Units UNIT_UTC = Units.t2000;
    StringBuffer headerBuffer = new StringBuffer();
    protected String headerDelimiter = null;
    public static final String PROP_HEADERDELIMITER = "headerDelimiter";
    String whereParm = null;
    int iwhereParm = -1;
    boolean whereEq = false;
    boolean whereNe = false;
    int whereSign = 0;
    String whereValue = null;
    Datum dwhereValue = null;
    DatumRange dwhereWithin = null;
    private Comparator<String> whereComp = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            Datum d;
            if (o1.equals(o2)) {
                return 0;
            }
            try {
                d = AsciiParser.this.units[AsciiParser.this.iwhereParm].parse(o1);
            }
            catch (ParseException ex) {
                return 1 - AsciiParser.this.whereSign;
            }
            if (AsciiParser.this.dwhereValue != null) {
                try {
                    return d.compareTo(AsciiParser.this.dwhereValue);
                }
                catch (InconvertibleUnitsException ex) {
                    if (UnitsUtil.isRatioMeasurement((Units)AsciiParser.this.units[AsciiParser.this.iwhereParm])) {
                        AsciiParser.this.dwhereValue = Datum.create((double)AsciiParser.this.dwhereValue.value(), (Units)AsciiParser.this.units[AsciiParser.this.iwhereParm]);
                        return d.compareTo(AsciiParser.this.dwhereValue);
                    }
                    throw ex;
                }
            }
            if (AsciiParser.this.dwhereWithin != null) {
                try {
                    return AsciiParser.this.dwhereWithin.contains(d) ? 1 : -1;
                }
                catch (InconvertibleUnitsException ex) {
                    if (UnitsUtil.isRatioMeasurement((Units)AsciiParser.this.units[AsciiParser.this.iwhereParm])) {
                        AsciiParser.this.dwhereWithin = DatumRange.newRange((double)AsciiParser.this.dwhereWithin.min().value(), (double)AsciiParser.this.dwhereWithin.max().value(), (Units)AsciiParser.this.units[AsciiParser.this.iwhereParm]);
                        return AsciiParser.this.dwhereWithin.contains(d) ? 1 : -1;
                    }
                    throw ex;
                }
            }
            return 1 - AsciiParser.this.whereSign;
        }
    };
    public static final FieldParser DOUBLE_PARSER = new FieldParser(){

        @Override
        public final double parseField(String field, int columnIndex) {
            if (field.length() == 1) {
                double d = field.charAt(0) - 48;
                return d < 0.0 || d > 9.0 ? Double.NaN : d;
            }
            return Double.parseDouble(field);
        }

        public String toString() {
            return "doubleParser";
        }
    };
    public final FieldParser UNITS_PARSER = new FieldParser(){

        @Override
        public final double parseField(String field, int columnIndex) throws ParseException {
            Units u = AsciiParser.this.units[columnIndex];
            return u.parse(field).doubleValue(u);
        }

        public String toString() {
            return "unitsParser";
        }
    };
    public final FieldParser ENUMERATION_PARSER = new FieldParser(){

        @Override
        public final double parseField(String field, int columnIndex) throws ParseException {
            Units units = AsciiParser.this.units[columnIndex];
            if (!(units instanceof EnumerationUnits)) {
                throw new IllegalStateException("ENUMERATION_PARSER needed EnumerationUnits");
            }
            EnumerationUnits u = (EnumerationUnits)units;
            field = field.trim();
            Datum d = u.createDatum((Object)field);
            return d.doubleValue((Units)u);
        }

        public String toString() {
            return "enumerationParser";
        }
    };
    private static AtomicInteger currentSerialNumber = new AtomicInteger(10000);
    private boolean keepFileHeader;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RecordParser recordParser;
    private double fillValue = -1.0E31;
    protected double validMin = Double.NEGATIVE_INFINITY;
    public static final String PROP_VALIDMIN = "validMin";
    protected double validMax = Double.POSITIVE_INFINITY;
    public static final String PROP_VALIDMAX = "validMax";

    private AsciiParser(String[] fieldNames) {
        this();
        this.setRegexParser(fieldNames);
    }

    public final boolean isHeader(int iline, String lastLine, String thisLine, int recCount) {
        return iline < this.skipLines || this.headerDelimiter != null && recCount == 0 && (lastLine == null || !Pattern.compile(this.headerDelimiter).matcher(lastLine).find()) || this.commentPrefix != null && thisLine.startsWith(this.commentPrefix);
    }

    public final boolean isIso8601Time(String s) {
        if (s.length() > 13 && s.contains("T")) {
            if ((s.startsWith("20") || s.startsWith("19") || s.startsWith("18")) && Character.isDigit(s.charAt(2)) && Character.isDigit(s.charAt(3))) {
                int charCount = 4;
                for (int i = 4; i < s.length(); ++i) {
                    if (!Character.isDigit(s.charAt(i))) continue;
                    ++charCount;
                }
                return charCount > 10;
            }
            return false;
        }
        return false;
    }

    public String readFirstRecord(String filename) throws IOException {
        return this.readFirstRecord(new BufferedReader(new FileReader(filename)));
    }

    public String readFirstRecord(BufferedReader reader) throws IOException {
        String lastLine = null;
        int iline = 0;
        String line = reader.readLine();
        while (line != null && this.isHeader(iline, lastLine, line, 0)) {
            lastLine = line;
            line = reader.readLine();
            ++iline;
        }
        reader.close();
        return line;
    }

    public String readFirstParseableRecord(String filename) throws IOException {
        String line;
        try (LineNumberReader reader = new LineNumberReader(new FileReader(filename));){
            String lastLine = null;
            line = ((BufferedReader)reader).readLine();
            int iline = 0;
            while (line != null && this.isHeader(iline, lastLine, line, 0)) {
                lastLine = line;
                line = ((BufferedReader)reader).readLine();
                ++iline;
            }
            DataSetBuilder builder = new DataSetBuilder(2, 100, this.recordParser.fieldCount());
            if (UnitsUtil.isTimeLocation((Units)this.units[0])) {
                this.fieldParsers[0] = this.UNITS_PARSER;
            }
            if (this.recordParser.fieldCount() > 1 && this.units.length > 1 && UnitsUtil.isTimeLocation((Units)this.units[1])) {
                this.fieldParsers[1] = this.UNITS_PARSER;
            }
            while (line != null && iline < 1000 && !this.recordParser.tryParseRecord(line, 0, builder)) {
                line = ((BufferedReader)reader).readLine();
                ++iline;
            }
            if (iline == 1000) {
                line = null;
            }
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int guessSkipLines(String filename, RecordParser recParser) throws IOException {
        int currentFirstRecord = 0;
        try (BufferedReader reader = null;){
            reader = new LineNumberReader(new FileReader(filename));
            String lastLine = null;
            String line = reader.readLine();
            int iline = 0;
            while (line != null && this.isHeader(iline, lastLine, line, 0)) {
                lastLine = line;
                line = reader.readLine();
                ++iline;
            }
            int currentFieldCount = -1;
            currentFirstRecord = iline;
            int repeatCount = 0;
            while (line != null) {
                int fc = recParser.fieldCount(line);
                if (fc != currentFieldCount) {
                    currentFieldCount = fc;
                    currentFirstRecord = iline;
                    repeatCount = 1;
                } else {
                    ++repeatCount;
                }
                if (repeatCount > 50) {
                    int n = currentFirstRecord;
                    return n;
                }
                line = reader.readLine();
            }
        }
        return currentFirstRecord;
    }

    public static Reader getReader(File file) throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        if (file.length() > 2L) {
            MappedByteBuffer buff = new FileInputStream(file).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 2L);
            byte c0 = buff.get(0);
            byte c1 = buff.get(1);
            if (c0 == -1 && c1 == -2) {
                charset = StandardCharsets.UTF_16LE;
            } else if (c0 == -2 && c1 == -1) {
                charset = StandardCharsets.UTF_16BE;
            }
        }
        return new InputStreamReader((InputStream)new FileInputStream(file), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelimParser guessSkipAndDelimParser(String filename) throws IOException {
        Logger logger = LoggerManager.getLogger((String)"qdataset.ascii.guess");
        DelimParser result = null;
        try (BufferedReader reader = null;){
            reader = new BufferedReader(AsciiParser.getReader(new File(filename)));
            String lastLine = null;
            String line = reader.readLine();
            int iline = 0;
            if (line == null) {
                throw new IllegalArgumentException("File is empty: " + filename);
            }
            if (line.length() > 1 && line.charAt(0) == '\u0000') {
                throw new IllegalArgumentException("ASCII file cannot start with 0: " + filename);
            }
            this.headerBuffer = new StringBuffer();
            while (line != null && this.isHeader(iline, lastLine, line, 0)) {
                lastLine = line;
                if (iline < 1000) {
                    this.headerBuffer.append(line).append("\n");
                }
                line = reader.readLine();
                ++iline;
            }
            if (line == null) {
                DelimParser delimParser = null;
                return delimParser;
            }
            DelimParser p = this.guessDelimParser(line, iline);
            LinkedList<String> lines = new LinkedList<String>();
            int parseCount = 0;
            while (iline < 1000 && line != null && parseCount < 5) {
                boolean enumCountOkay;
                lines.add(line);
                line = p.readNextRecord(reader);
                ++iline;
                while (lines.size() > 10) {
                    lines.remove(0);
                }
                if (line == null) continue;
                p = this.guessDelimParser(line, iline);
                int enumCount = 0;
                int totalCount = 0;
                for (int i = 0; i < p.fieldCount; ++i) {
                    if (this.fieldParsers[i] != this.ENUMERATION_PARSER) continue;
                    ++enumCount;
                }
                totalCount = p.fieldCount;
                int limitEnum = totalCount / 2;
                boolean bl = enumCountOkay = enumCount <= limitEnum;
                if (logger.isLoggable(Level.FINER)) {
                    StringBuilder build = new StringBuilder();
                    for (int i = 0; i < p.fieldCount; ++i) {
                        String s = this.fieldParsers[i].toString();
                        build.append(s.charAt(0));
                        build.append(" ");
                    }
                    logger.finer(String.format("line %03d: %2d %s", iline, p.fieldCount, build.toString()));
                }
                p.showException = false;
                parseCount = enumCountOkay && p.tryParseRecord(line, iline, null) ? 1 : 0;
                for (String line1 : lines) {
                    if (enumCountOkay && p.tryParseRecord(line1, 0, null)) {
                        ++parseCount;
                        continue;
                    }
                    if (iline != 2) continue;
                    String[] ff = p.fields(line);
                    for (int j = 0; j < ff.length; ++j) {
                        if (!TimeParser.isIso8601String((String)ff[j])) continue;
                        this.setUnits(j, UNIT_UTC);
                    }
                    if (!enumCountOkay || !p.tryParseRecord(line1, 0, null)) continue;
                    ++parseCount;
                }
            }
            result = p;
            for (String line1 : lines) {
                if (p.fieldCount(line1) != p.fieldCount()) continue;
                line = line1;
                int n = this.units.length;
                Units[] u = new Units[n];
                System.arraycopy(this.units, 0, u, 0, n);
                result = this.createDelimParser(line1, p.getDelim(), -1);
                System.arraycopy(u, 0, this.units, 0, n);
                result.setGuessUnits(false);
                break;
            }
            if (line == null || parseCount == 0) {
                for (int i = 0; i < this.fieldCount; ++i) {
                    this.units[i] = Units.dimensionless;
                    this.fieldParsers[i] = this.UNITS_PARSER;
                }
                DelimParser i = null;
                return i;
            }
            String[] fields = new String[result.fieldCount];
            if (result.splitRecord(line, fields)) {
                for (int i = 0; i < fields.length; ++i) {
                    if (this.isIso8601Time(fields[i])) {
                        this.setFieldParser(i, this.UNITS_PARSER);
                        this.setUnits(i, (Units)Units.cdfTT2000);
                        continue;
                    }
                    if (this.fieldParsers[i] != this.ENUMERATION_PARSER) continue;
                    this.setFieldParser(i, this.UNITS_PARSER);
                }
            }
        }
        String header = this.headerBuffer.toString();
        boolean isRichHeader = AsciiParser.isRichHeader(header);
        if (isRichHeader) {
            try {
                String ss;
                int ii = header.indexOf("\n");
                if (ii > 0 && (ss = header.substring(0, ii)).split("\\#").length > 2) {
                    throw new IllegalArgumentException("rich header cannot contain more than two hashes (#) on the first line.  Maybe newlines were unintentionally removed");
                }
                this.bundleDescriptor = AsciiHeadersParser.parseMetadata(header, this.fieldNames, this.fieldLabels);
                if (this.bundleDescriptor.length() == this.fieldNames.length) {
                    for (int j = 0; j < this.bundleDescriptor.length(); ++j) {
                        String n;
                        if (j == 0 && this.bundleDescriptor.property("UNITS", j) == null && UnitsUtil.isTimeLocation((Units)this.units[0]) && this.bundleDescriptor.property("UNITS", j) == null) {
                            this.bundleDescriptor.putProperty("UNITS", j, this.units[0]);
                        }
                        if ((n = (String)this.bundleDescriptor.property("NAME", j)) != null) {
                            this.fieldNames[j] = n;
                        }
                        if ((n = (String)this.bundleDescriptor.property("LABEL", j)) == null) continue;
                        this.fieldLabels[j] = n;
                    }
                } else {
                    logger.warning(String.format("rich header buffer not the same length as the dataset (%d!=%d)", this.bundleDescriptor.length(), this.fieldNames.length));
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (result != null) {
                result.header = header;
            }
        }
        return result;
    }

    public DelimParser guessDelimParser(String line) throws IOException {
        return this.guessDelimParser(line, -1);
    }

    public DelimParser guessDelimParser(String line, int lineNumber) throws IOException {
        int tabDelimFieldCount = 1;
        int semiColonDelimFieldCount = 1;
        int commaDelimFieldCount = 1;
        int whitespaceDelimFieldCount = 1;
        boolean withinWhitespace = false;
        boolean withinQuote = false;
        boolean afterEscape = false;
        block8: for (int ich = 0; ich < line.length(); ++ich) {
            char ch = line.charAt(ich);
            switch (ch) {
                case '\t': {
                    boolean afterComma;
                    boolean bl = ich > 1 ? line.charAt(ich - 1) == ',' : (afterComma = false);
                    if (!afterComma) {
                        tabDelimFieldCount += withinQuote ? 0 : 1;
                    }
                    withinWhitespace = true;
                    afterEscape = false;
                    continue block8;
                }
                case ' ': {
                    boolean afterComma;
                    boolean bl = ich > 1 ? line.charAt(ich - 1) == ',' : (afterComma = false);
                    if (!withinWhitespace && !afterComma) {
                        withinWhitespace = true;
                        whitespaceDelimFieldCount += withinQuote ? 0 : 1;
                    }
                    afterEscape = false;
                    continue block8;
                }
                case ';': {
                    semiColonDelimFieldCount += withinQuote ? 0 : 1;
                    afterEscape = false;
                    withinWhitespace = false;
                    continue block8;
                }
                case ',': {
                    commaDelimFieldCount += withinQuote ? 0 : 1;
                    afterEscape = false;
                    withinWhitespace = false;
                    continue block8;
                }
                case '\\': {
                    afterEscape = true;
                    withinWhitespace = false;
                    continue block8;
                }
                case '\"': {
                    if (!afterEscape) {
                        withinQuote = !withinQuote;
                    }
                    afterEscape = false;
                    withinWhitespace = false;
                    continue block8;
                }
                default: {
                    afterEscape = false;
                    withinWhitespace = false;
                }
            }
        }
        String fieldSep = semiColonDelimFieldCount > 1 && semiColonDelimFieldCount >= whitespaceDelimFieldCount / 2 ? ";" : (tabDelimFieldCount > 1 && tabDelimFieldCount != whitespaceDelimFieldCount ? DELIM_TAB : (commaDelimFieldCount > 1 && commaDelimFieldCount >= whitespaceDelimFieldCount / 2 ? DELIM_COMMA : "[\\s\\u00A0]+"));
        logger.log(Level.FINER, "guessDelimParser guesses \"{0}\" for line {1}", new Object[]{fieldSep, lineNumber});
        DelimParser result = this.createDelimParser(line, fieldSep, lineNumber);
        this.setRecordParser(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelimParser setDelimParser(String filename, String delimRegex) throws IOException {
        DelimParser result = null;
        try (FileReader r = null;){
            r = new FileReader(filename);
            result = this.setDelimParser(r, delimRegex);
        }
        return result;
    }

    public DelimParser setDelimParser(String line, String delimRegex, int expectedColumnCount) throws IOException {
        DelimParser result = this.createDelimParser(line, delimRegex, -1);
        if (expectedColumnCount > -1 && result.fieldCount != expectedColumnCount) {
            throw new IllegalArgumentException("expectedColumnCount isn't correct.  Expected " + expectedColumnCount + ", got " + result.fieldCount);
        }
        this.setRecordParser(result);
        return result;
    }

    public DelimParser setDelimParser(Reader in, String delimRegex) throws IOException {
        String line;
        try (LineNumberReader reader = new LineNumberReader(in);){
            line = this.readFirstRecord(reader);
        }
        DelimParser result = this.createDelimParser(line, delimRegex, -1);
        this.setRecordParser(result);
        return result;
    }

    public final RecordParser setRegexParser(String[] fieldNames) {
        this.initializeByFieldCount(fieldNames.length);
        this.fieldNames = Arrays.copyOf(fieldNames, fieldNames.length);
        StringBuilder regexBuf = new StringBuilder();
        regexBuf.append("\\s*");
        for (int i = 0; i < this.fieldCount - 1; ++i) {
            regexBuf.append("([\\d\\.eE\\+\\-]+)[\\s+,+]\\s*");
        }
        regexBuf.append("([\\d\\.eE\\+\\-]+)\\s*");
        this.setRecordParser(new RegexParser(this, regexBuf.toString()));
        return this.recordParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedColumnsParser setFixedColumnsParser(String filename, String delim) throws IOException {
        FixedColumnsParser result;
        try (FileReader r = null;){
            r = new FileReader(filename);
            result = this.setFixedColumnsParser(r, delim);
        }
        return result;
    }

    public FixedColumnsParser setFixedColumnsParser(Reader in, String delim) throws IOException {
        int i;
        int lineNumber;
        String line;
        try (LineNumberReader reader = new LineNumberReader(in);){
            line = this.readFirstRecord(reader);
            lineNumber = reader.getLineNumber();
        }
        int col = 0;
        String[] ss = line.split(delim);
        int[] columnOffsets = new int[ss.length];
        int[] columnWidths = new int[ss.length - 1];
        this.initializeByFieldCount(ss.length);
        this.initializeUnitsByGuessing(ss, lineNumber);
        boolean rightJustified = false;
        if (ss[0].trim().length() == 0) {
            rightJustified = true;
            for (i = 0; i < ss.length - 1; ++i) {
                ss[i] = ss[i + 1];
            }
        }
        columnOffsets[0] = 0;
        if (rightJustified) {
            for (i = 1; i < ss.length; ++i) {
                col = line.indexOf(ss[i - 1], columnOffsets[i - 1]);
                columnOffsets[i] = col + ss[i - 1].length();
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        } else {
            for (i = 1; i < ss.length; ++i) {
                columnOffsets[i] = col = line.indexOf(ss[i], col + ss[i - 1].length());
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        }
        int[] co = new int[columnWidths.length];
        System.arraycopy(columnOffsets, 0, co, 0, columnWidths.length);
        FixedColumnsParser p = new FixedColumnsParser(co, columnWidths);
        this.setRecordParser(p);
        this.propertyPattern = null;
        return p;
    }

    public static int guessFieldCount(String filename) throws FileNotFoundException, IOException {
        int maxFieldCount = 10;
        int[] recCount = new int[10];
        StringBuilder regexBuf = new StringBuilder();
        regexBuf.append("\\s*([\\d\\.eE\\+\\-]+)");
        for (int i = 1; i < 10; ++i) {
            regexBuf.append("([\\s+,+]\\s*([\\d\\.eE\\+\\-]+))?");
        }
        regexBuf.append("\\s*");
        Pattern pat = Pattern.compile(regexBuf.toString());
        try (LineNumberReader reader = new LineNumberReader(new FileReader(filename));){
            String line;
            block10: while ((line = ((BufferedReader)reader).readLine()) != null) {
                Matcher m = pat.matcher(line);
                if (!m.matches()) continue;
                for (int j = 1; j < m.groupCount(); j += 2) {
                    if (m.group(j) != null) continue;
                    int n = (j - 1) / 2;
                    recCount[n] = recCount[n] + 1;
                    continue block10;
                }
            }
        }
        int max = 0;
        int imax = 0;
        for (int j = 1; j < 10; ++j) {
            if (recCount[j] <= max) continue;
            imax = j;
            max = recCount[j];
        }
        return imax;
    }

    public void setFieldParser(int field, FieldParser fp) {
        logger.log(Level.FINER, "setFieldParser field={0} {1}", new Object[]{field, fp});
        if (field >= this.fieldParsers.length) {
            throw new ArrayIndexOutOfBoundsException("parser expects only " + this.fieldParsers.length + " fields");
        }
        FieldParser oldFp = this.fieldParsers[field];
        this.fieldParsers[field] = fp;
        if (fp == this.UNITS_PARSER && UnitsUtil.isTimeLocation((Units)this.units[field])) {
            this.setPropertyPattern(null);
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_FIELD_PARSER, oldFp, fp);
    }

    public static AsciiParser newParser(int fieldCount) {
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return new AsciiParser(fieldNames);
    }

    public static AsciiParser newParser(String[] fieldNames) {
        return new AsciiParser(fieldNames);
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public void setRecordCountLimit(int recordCountLimit) {
        this.recordCountLimit = recordCountLimit;
        if (this.recordStart > 0) {
            this.recordCountLimit += this.recordStart;
        }
    }

    public void setRecordStart(int recordStart) {
        if (recordStart < 0) {
            throw new IllegalArgumentException("must be positive");
        }
        this.recordStart = recordStart;
        if (this.recordCountLimit < Integer.MAX_VALUE) {
            this.recordCountLimit += this.recordStart;
        }
    }

    public void setPropertyPattern(Pattern propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    public void setCommentPrefix(String comment) {
        this.commentPrefix = comment;
    }

    public String getHeaderDelimiter() {
        return this.headerDelimiter;
    }

    public void setHeaderDelimiter(String headerDelimiter) {
        String oldHeaderDelimiter = this.headerDelimiter;
        this.headerDelimiter = headerDelimiter;
        this.propertyChangeSupport.firePropertyChange(PROP_HEADERDELIMITER, oldHeaderDelimiter, headerDelimiter);
    }

    public WritableDataSet readStream(Reader in, ProgressMonitor mon) throws IOException {
        return this.readStream(in, null, mon);
    }

    public WritableDataSet readString(String str, ProgressMonitor mon) throws IOException {
        InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8"))));
        return this.readStream(in, null, mon);
    }

    public WritableDataSet readStream(Reader in, String firstRecord, ProgressMonitor mon) throws IOException {
        WritableDataSet result;
        BufferedReader reader = new BufferedReader(in);
        String line = null;
        int iline = -1;
        int irec = 0;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Reading stream with field parsers:");
            for (int i = 0; i < this.recordParser.fieldCount(); ++i) {
                logger.log(Level.FINE, "  field {0}: {1}", new Object[]{i, this.fieldParsers[i]});
            }
            logger.fine("Reading stream with field parsers:");
        }
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        mon.started();
        DataSetBuilder builder = new DataSetBuilder(2, 100, this.recordParser.fieldCount());
        builder.setFillValue(this.fillValue);
        builder.setValidMax(this.validMax);
        builder.setValidMin(this.validMin);
        int lnonEnumFields = 0;
        for (int i = 0; i < this.units.length; ++i) {
            Units unit = this.units[i];
            if (UnitsUtil.isIntervalOrRatioMeasurement((Units)unit)) {
                ++lnonEnumFields;
                continue;
            }
            if (this.fieldParsers[i] != this.UNITS_PARSER) continue;
            this.fieldParsers[i] = this.ENUMERATION_PARSER;
        }
        this.nonEnumFields = lnonEnumFields;
        long bytesRead = 0L;
        this.headerBuffer = new StringBuffer();
        String lastLine = line;
        if (firstRecord != null) {
            line = firstRecord;
            firstRecord = null;
        } else {
            line = this.recordParser.readNextRecord(reader);
        }
        boolean parsedMeta = false;
        boolean acceptRecord = true;
        while (line != null) {
            bytesRead += (long)(line.length() + 1);
            ++iline;
            if (irec == this.recordCountLimit || mon.isCancelled()) break;
            mon.setTaskProgress(bytesRead);
            if (iline % 100 == 0) {
                mon.setProgressMessage("reading line " + iline);
            }
            if (this.isHeader(iline, lastLine, line, irec)) {
                if (this.commentPrefix != null && line.startsWith(this.commentPrefix)) {
                    line = line.substring(this.commentPrefix.length());
                }
                if (this.keepFileHeader && iline < 1000) {
                    this.headerBuffer.append(line).append("\n");
                }
            } else {
                if (!parsedMeta) {
                    String header = this.headerBuffer.toString();
                    this.parseMeta(header, builder);
                    this.isRichAscii = AsciiParser.isRichHeader(header);
                    if (!this.isRichAscii.booleanValue()) {
                        builder.putProperty(PROPERTY_FILE_HEADER, header);
                    }
                    parsedMeta = true;
                }
                try {
                    if (firstRecord == null) {
                        int nonAsciiCount;
                        if (line.length() > 3 && ((nonAsciiCount = AsciiParser.getNonAsciiCount(line)) > 20 || nonAsciiCount * 100 / line.length() > 20)) {
                            throw new IOException("stream does not appear to be ascii");
                        }
                        firstRecord = line.length() > 132 ? line.substring(0, 132) + "..." : line;
                        builder.putProperty(PROPERTY_FIRST_RECORD, firstRecord);
                        if (line.length() > 1 && line.charAt(0) == '\ufeff') {
                            line = line.substring(1);
                        }
                    }
                    if (this.recordParser.tryParseRecord(line, irec, builder)) {
                        String[] fields;
                        acceptRecord = true;
                        if (this.whereParm != null && this.recordParser.splitRecord(line, fields = new String[this.recordParser.fieldCount()])) {
                            String field = fields[this.iwhereParm].trim();
                            int icomp = this.whereComp.compare(field, this.whereValue);
                            acceptRecord = false;
                            if (this.whereEq && icomp == 0) {
                                acceptRecord = true;
                            } else if (this.whereNe && icomp != 0) {
                                acceptRecord = true;
                            } else if (this.whereSign == icomp) {
                                acceptRecord = true;
                            }
                        }
                        if (acceptRecord) {
                            ++irec;
                            builder.nextRecord();
                        }
                    }
                }
                catch (NumberFormatException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            lastLine = line;
            line = this.recordParser.readNextRecord(reader);
        }
        mon.finished();
        Object o = builder.properties.get("USER_PROPERTIES");
        if (o == null) {
            builder.putProperty("USER_PROPERTIES", new HashMap<String, Object>(builder.properties));
        }
        if (this.bundleDescriptor != null) {
            builder.putProperty("BUNDLE_1", this.bundleDescriptor);
        }
        if ((result = builder.getDataSet()).length() != irec) {
            result = (WritableDataSet)result.trim(0, irec);
        }
        if (this.recordStart > 0) {
            result = (WritableDataSet)result.trim(this.recordStart, result.length());
        }
        return result;
    }

    public static boolean isRichHeader(String header) {
        if (header.length() == 0) {
            return false;
        }
        String hash = header.charAt(0) == '#' ? "\\#" : "";
        Pattern p = Pattern.compile(hash + "\\s*\\{");
        Matcher m = p.matcher(header);
        if (m.find()) {
            int istart = m.start();
            int iend = m.end();
            p = Pattern.compile(hash + ".*\\}");
            m = p.matcher(header);
            if (m.find(iend)) {
                iend = m.end();
                String jsonSrc = header.substring(istart, iend);
                return jsonSrc.contains(":");
            }
        }
        return false;
    }

    public boolean isRichHeader() {
        if (this.isRichAscii == null) {
            throw new IllegalArgumentException("file must be parsed before calling isRichHeader");
        }
        return this.isRichAscii;
    }

    private void parseMeta(String header, DataSetBuilder builder) {
        block11: {
            logger.entering("AsciiParser", "parseMeta");
            boolean doJSON = AsciiParser.isRichHeader(header);
            if (doJSON) {
                try {
                    logger.fine("Parsing Rich JSON Header...");
                    this.bundleDescriptor = AsciiHeadersParser.parseMetadata(header, this.getFieldNames(), this.getFieldLabels());
                    builder.putProperty("BUNDLE_1", this.bundleDescriptor);
                    this.bundleDescriptor.property("LABEL", 1);
                    Map<String, Object> props = DataSetUtil.getProperties(this.bundleDescriptor, DataSetUtil.globalProperties(), null);
                    props.entrySet().forEach(e -> {
                        String k = (String)e.getKey();
                        builder.putProperty(k, e.getValue());
                    });
                    for (int j = 0; j < this.bundleDescriptor.length(); ++j) {
                        Units u;
                        if (j == 0 && UnitsUtil.isTimeLocation((Units)this.units[0]) && this.bundleDescriptor.property("UNITS", j) == null) {
                            this.bundleDescriptor.putProperty("UNITS", j, this.units[0]);
                        }
                        if ((u = (Units)this.bundleDescriptor.property("UNITS", j)) == null) continue;
                        this.fieldParsers[j] = this.UNITS_PARSER;
                        this._setUnits(j, u);
                    }
                    if (this.bundleDescriptor.length() != this.fieldParsers.length) {
                        logger.warning("lengths check didn't work out");
                    }
                    break block11;
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (this.propertyPattern != null) {
                        LinkedHashMap<String, String> userProps = new LinkedHashMap<String, String>();
                        for (String line2 : header.split("\n")) {
                            Matcher m2 = this.propertyPattern.matcher(line2);
                            if (!m2.matches()) continue;
                            userProps.put(m2.group(1).trim(), m2.group(2).trim());
                        }
                        builder.putProperty("USER_PROPERTIES", userProps);
                    }
                    break block11;
                }
            }
            if (this.propertyPattern != null) {
                LinkedHashMap<String, String> userProps = new LinkedHashMap<String, String>();
                for (String line2 : header.split("\n")) {
                    Matcher m2 = this.propertyPattern.matcher(line2);
                    if (!m2.matches()) continue;
                    userProps.put(m2.group(1).trim(), m2.group(2).trim());
                }
                builder.putProperty("USER_PROPERTIES", userProps);
            }
            SparseDataSetBuilder sdsb = new SparseDataSetBuilder(2);
            sdsb.setQube(new int[]{this.units.length, 0});
            for (int i = 0; i < this.units.length; ++i) {
                sdsb.putProperty("UNITS", i, this.units[i]);
                sdsb.putProperty("LABEL", i, this.fieldLabels[i]);
                sdsb.putProperty("NAME", i, this.fieldNames[i]);
            }
            this.bundleDescriptor = sdsb.getDataSet();
        }
        logger.exiting("AsciiParser", "parseMeta");
    }

    public Map<String, String> getRichFields() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.bundleDescriptor != null) {
            for (int i = 0; i < this.bundleDescriptor.length(); ++i) {
                String name = (String)this.bundleDescriptor.property("ELEMENT_NAME", i);
                if (name == null || result.containsKey(name)) continue;
                String label = (String)this.bundleDescriptor.property("ELEMENT_LABEL", i);
                int rank = this.bundleDescriptor.length(i);
                int len = 0;
                if (rank > 0) {
                    len = 1;
                    for (int j = 0; j < rank; ++j) {
                        len *= (int)this.bundleDescriptor.value(i, j);
                    }
                }
                if (len == 0) {
                    result.put(name + ": field" + i, label);
                    continue;
                }
                result.put(name + ": field" + i + "-field" + (i + len - 1), label);
                i = i + len - 1;
            }
        }
        return result;
    }

    public void setWhereConstraint(String sparm, String op, String sval) {
        this.whereParm = sparm;
        this.iwhereParm = this.getFieldIndex(this.whereParm);
        if (this.iwhereParm == -1) {
            throw new IllegalArgumentException("no such column: " + sparm);
        }
        switch (op) {
            case "eq": {
                this.whereSign = 0;
                this.whereEq = true;
                this.whereNe = false;
                break;
            }
            case "ne": {
                this.whereSign = 0;
                this.whereEq = false;
                this.whereNe = true;
                break;
            }
            case "gt": {
                this.whereSign = 1;
                this.whereEq = false;
                this.whereNe = false;
                break;
            }
            case "ge": {
                this.whereSign = 1;
                this.whereEq = true;
                this.whereNe = false;
                break;
            }
            case "lt": {
                this.whereSign = -1;
                this.whereEq = false;
                this.whereNe = false;
                break;
            }
            case "le": {
                this.whereSign = -1;
                this.whereEq = true;
                this.whereNe = false;
                break;
            }
            case "within": {
                this.whereSign = 1;
                this.whereEq = true;
                this.whereNe = false;
                break;
            }
            case "matches": {
                this.whereSign = 0;
                this.whereEq = true;
                this.whereNe = false;
                Pattern p = Pattern.compile(sval);
                this.whereComp = (o1, o2) -> {
                    String s1 = o1;
                    if (p.matcher(s1).matches()) {
                        return 0;
                    }
                    return 1;
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("where constraint not supported: " + op);
            }
        }
        this.whereValue = sval.trim();
        this.dwhereValue = null;
        if (UnitsUtil.isOrdinalMeasurement((Units)this.units[this.iwhereParm])) {
            logger.log(Level.FINE, "column {0} is ordinal data", sparm);
        } else {
            try {
                if (op.equals("within")) {
                    this.dwhereWithin = DatumRangeUtil.parseDatumRange((String)this.whereValue, (Units)this.units[this.iwhereParm]);
                } else {
                    this.dwhereValue = this.units[this.iwhereParm].parse(this.whereValue);
                }
            }
            catch (ParseException ex) {
                logger.log(Level.FINE, "sval is not parseable, assuming it is ordinal data");
            }
        }
    }

    private static int getNonAsciiCount(String line) {
        int nonAsciiCount = 0;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch >= ' ' && ch <= '~' || ch == '\t') continue;
            ++nonAsciiCount;
        }
        return nonAsciiCount;
    }

    private static String[] split(String string, String regex) {
        String[] ss;
        if (regex.equals(DELIM_WHITESPACE)) {
            ss = string.trim().split(regex);
        } else {
            switch (regex) {
                case ",": 
                case ";": {
                    if (string.charAt(string.length() - 1) == '\u201d') {
                        logger.finer("trailing right quote detected");
                        string = string.substring(0, string.length() - 1) + "\"";
                    }
                    ss = string.trim().split(regex + "(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -2);
                    break;
                }
                default: {
                    ss = string.trim().split(regex, -2);
                }
            }
        }
        return ss;
    }

    private DelimParser createDelimParser(String line, String fieldSep, int lineNum) {
        int i;
        logger.entering("AsciiParser", "createDelimParser");
        String[] ss = AsciiParser.split(line.trim(), fieldSep);
        this.initializeByFieldCount(ss.length);
        this.initializeUnitsByGuessing(ss, lineNum);
        this.fieldLabels = new String[this.fieldCount];
        this.fieldUnits = new String[this.fieldCount];
        boolean isColumnHeaders = true;
        for (i = 0; i < ss.length; ++i) {
            String n;
            Matcher m = COLUMN_ID_HEADER_PATTERN.matcher(ss[i]);
            if (m.matches()) {
                n = m.group(1).trim();
                if (n.length() != 3 || !n.equalsIgnoreCase("nan")) {
                    char ch;
                    this.fieldLabels[i] = n;
                    this.fieldNames[i] = Ops.safeName(this.fieldLabels[i]);
                    this.fieldUnits[i] = m.group(3);
                    if (this.fieldUnits[i] == null) continue;
                    this.fieldUnits[i] = this.fieldUnits[i].trim();
                    if (this.fieldUnits[i].length() > 2 && !Character.isLetter(ch = this.fieldUnits[i].charAt(0))) {
                        this.fieldLabels[i] = this.fieldLabels[i] + m.group(2);
                        this.fieldUnits[i] = null;
                    }
                    if (this.fieldUnits[i] == null) continue;
                    this._setUnits(i, Units.lookupUnits((String)this.fieldUnits[i]));
                    continue;
                }
                if (isColumnHeaders) {
                    logger.log(Level.FINEST, "parsed line appears to contain NaN''s, and is not a column header because of field #{0}: {1}", new Object[]{i, ss[i]});
                }
                isColumnHeaders = false;
                continue;
            }
            m = COLUMN_CHANNEL_HEADER_PATTERN.matcher(ss[i]);
            if (m.matches() && m.group(3).length() > 0 && m.group(5).length() > 0) {
                this.fieldLabels[i] = n = m.group(1).trim();
                this.fieldNames[i] = m.group(2).length() > 0 ? n.replaceAll("-", "_") : "ch_" + n.replaceAll("-", "_");
                this.fieldUnits[i] = null;
                continue;
            }
            if (i == ss.length - 1) {
                this.fieldNames[i] = "field" + i;
                continue;
            }
            if (isColumnHeaders) {
                logger.log(Level.FINEST, "first parsed line does not appear to be column header because of field #{0}: {1}", new Object[]{i, ss[i]});
            }
            isColumnHeaders = false;
        }
        if (!isColumnHeaders) {
            for (i = 0; i < this.fieldCount; ++i) {
                if (this.fieldNames[i] != null) continue;
                this.fieldNames[i] = "field" + i;
            }
        }
        DelimParser recordParser1 = new DelimParser(this.fieldParsers.length, fieldSep);
        this.propertyPattern = null;
        logger.exiting("AsciiParser", "createDelimParser");
        return recordParser1;
    }

    public DelimParser getDelimParser(int fieldCount, String delim) {
        DelimParser result = new DelimParser(fieldCount, delim);
        this.setRecordParser(result);
        return result;
    }

    private static String[] f77FormatToCFormat(String[] format) {
        String[] ss = new String[format.length + 1];
        for (int i = 1; i < ss.length; ++i) {
            String field = format[i - 1];
            if (field.length() > 1) {
                Pattern p = Pattern.compile("(\\d*)(\\D)(\\d*).*");
                Matcher m = p.matcher(field);
                if (m.matches()) {
                    int len;
                    String type = m.group(2);
                    int repeat = !m.group(1).equals("") ? Integer.parseInt(m.group(1)) : 1;
                    int n = len = !m.group(3).equals("") ? Integer.parseInt(m.group(3)) : -1;
                    if (type.toLowerCase().equals("x")) {
                        len = len == -1 ? repeat : repeat * len;
                        ss[i] = String.valueOf(len) + type;
                        continue;
                    }
                    if (repeat != 1) {
                        throw new IllegalArgumentException("repeats are only allowed for X: " + field);
                    }
                    ss[i] = String.valueOf(len) + type;
                    continue;
                }
                throw new IllegalArgumentException("unable to parse: " + field);
            }
            ss[i] = field;
        }
        ss[0] = "";
        return ss;
    }

    public static int guessLengthForFormat(String format) {
        if (!format.startsWith("%")) {
            format = "%" + format;
        }
        String[] ss = format.split("%");
        int[] lengths = new int[ss.length];
        for (int i = 1; i < ss.length; ++i) {
            int pp = 0;
            while (Character.isDigit(ss[i].charAt(pp)) || ss[i].charAt(pp) == '-') {
                ++pp;
            }
            lengths[i] = pp > 0 ? Integer.parseInt(ss[i].substring(0, pp)) : (ss[i].equals("%f") ? 10 : (ss[i].equals("%d") ? 10 : -1));
        }
        int totalLength = 0;
        for (int i = 1; i < ss.length; ++i) {
            if (lengths[i] == -1) {
                return -1;
            }
            totalLength += lengths[i];
        }
        return totalLength;
    }

    public static String getRegexForFormat(String format) {
        String[] ss2;
        String[] ss1;
        String[] ss = format.split("%");
        if (ss.length == 1 && (ss1 = format.split("\\$")).length > 1) {
            ss = ss1;
        }
        if (ss.length == 1 && (ss2 = format.split(DELIM_COMMA)).length > 1) {
            ss = AsciiParser.f77FormatToCFormat(ss2);
        }
        int[] lengths = new int[ss.length];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = -1;
        }
        StringBuilder build = new StringBuilder(100);
        for (int i = 1; i < ss.length; ++i) {
            int pp = 0;
            while (Character.isDigit(ss[i].charAt(pp)) || ss[i].charAt(pp) == '-') {
                ++pp;
            }
            lengths[i] = pp > 0 ? Integer.parseInt(ss[i].substring(0, pp)) : -1;
            logger.log(Level.FINE, "ss[i]={0}", ss[i]);
            String fci = ss[i].toLowerCase().endsWith("x") ? (lengths[i] == -1 ? "\\s*\\S+" : ".{" + lengths[i] + "}") : (lengths[i] == -1 ? "\\s*(\\S+)" : "(.{" + lengths[i] + "})");
            build.append(fci);
            if (lengths[i] != -1) continue;
            build.append("\\s*");
        }
        String regex = build.toString();
        return regex;
    }

    public RegexParser getRegexParserForFormat(String format) {
        String regex = AsciiParser.getRegexForFormat(format);
        RegexParser rp = new RegexParser(this, regex);
        this.setRecordParser(rp);
        return rp;
    }

    public RegexParser getRegexParser(String regex) {
        return new RegexParser(this, regex);
    }

    private void initializeByFieldCount(int count) {
        this.fieldCount = count;
        this.fieldNames = new String[this.fieldCount];
        this.fieldParsers = new FieldParser[this.fieldCount];
        this.fieldLabels = new String[this.fieldCount];
        this.fieldUnits = new String[this.fieldCount];
        this.units = new Units[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldParsers[i] = DOUBLE_PARSER;
            this.fieldNames[i] = "field" + i;
            this.fieldLabels[i] = this.fieldNames[i];
            this.fieldUnits[i] = "";
            this._setUnits(i, Units.dimensionless);
        }
    }

    private static Units guessUnits(String sval) {
        if (sval.length() > 0 && sval.charAt(0) == '\"' && sval.charAt(sval.length() - 1) == '\"') {
            sval = sval.substring(1, sval.length() - 1);
        }
        try {
            Units.dimensionless.parse(sval);
            return Units.dimensionless;
        }
        catch (ParseException ex) {
            logger.log(Level.FINER, "fails to parse as number: {0}", sval);
        }
        catch (InconvertibleUnitsException ex) {
            try {
                Datum d = DatumUtil.parse((String)sval);
                return d.getUnits();
            }
            catch (ParseException ex1) {
                return Units.dimensionless;
            }
        }
        try {
            UNIT_UTC.parse(sval);
            return UNIT_UTC;
        }
        catch (ParseException ex) {
            logger.log(Level.FINER, "fails to parse as time: {0}", sval);
            return EnumerationUnits.create((Object)"enum");
        }
    }

    private void initializeUnitsByGuessing(String[] ss, int lineNumber) {
        boolean useOldCode = false;
        if (useOldCode) {
            this.initializeUnitsByGuessingOld(ss, lineNumber);
        } else {
            logger.log(Level.FINER, "guess units at line {0}", lineNumber);
            for (int i = 0; i < ss.length; ++i) {
                String field = ss[i].trim();
                if (field.length() == 0) continue;
                Units u = AsciiParser.guessUnits(field);
                if (UnitsUtil.isTimeLocation((Units)u)) {
                    this._setUnits(i, (Units)Units.t2000);
                    this.fieldParsers[i] = this.UNITS_PARSER;
                } else if (u == Units.dimensionless) {
                    this._setUnits(i, u);
                    this.fieldParsers[i] = DOUBLE_PARSER;
                } else if (u instanceof EnumerationUnits) {
                    this._setUnits(i, u);
                    this.fieldParsers[i] = this.ENUMERATION_PARSER;
                } else {
                    this._setUnits(i, u);
                    this.fieldParsers[i] = this.UNITS_PARSER;
                }
                if (this.bundleDescriptor == null) continue;
                this.bundleDescriptor.putProperty("UNITS", i, u);
            }
        }
    }

    private void initializeUnitsByGuessingOld(String[] ss, int lineNumber) {
        logger.log(Level.FINE, "guess units at line {0}", lineNumber);
        for (int i = 0; i < ss.length; ++i) {
            if (this.isIso8601Time(ss[i].trim())) {
                this._setUnits(i, (Units)Units.t2000);
                this.fieldParsers[i] = this.UNITS_PARSER;
                continue;
            }
            this._setUnits(i, Units.dimensionless);
            this.fieldParsers[i] = DOUBLE_PARSER;
        }
    }

    private void _setUnits(int i, Units u) {
        logger.log(Level.FINEST, "_setUnits({0},{1})", new Object[]{i, u});
        this.units[i] = u;
        if (this.bundleDescriptor != null) {
            this.bundleDescriptor.putProperty("UNITS", i, u);
        }
    }

    public FixedColumnsParser setFixedColumnsParser(int[] columnOffsets, int[] columnWidths, FieldParser[] parsers) {
        FixedColumnsParser result = new FixedColumnsParser(columnOffsets, columnWidths);
        this.setRecordParser(result);
        this.initializeByFieldCount(parsers.length);
        this.fieldParsers = Arrays.copyOf(parsers, parsers.length);
        return result;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public String[] getFieldNames() {
        if (this.fieldNames == null) {
            throw new IllegalArgumentException("unable to identify fields");
        }
        return Arrays.copyOf(this.fieldNames, this.fieldNames.length);
    }

    public String[] getFieldLabels() {
        if (this.fieldLabels == null) {
            this.fieldLabels = new String[this.fieldNames.length];
        }
        for (int i = 0; i < this.fieldLabels.length; ++i) {
            if (this.fieldLabels[i] != null) continue;
            this.fieldLabels[i] = this.fieldNames[i];
        }
        return Arrays.copyOf(this.fieldLabels, this.fieldLabels.length);
    }

    public String[] getFieldUnits() {
        return Arrays.copyOf(this.fieldUnits, this.fieldUnits.length);
    }

    public WritableDataSet readFile(String filename, ProgressMonitor mon) throws IOException {
        long size = new File(filename).length();
        mon.setTaskSize(size);
        try (FileReader in = new FileReader(filename);){
            WritableDataSet result;
            WritableDataSet writableDataSet = result = this.readStream(in, null, mon);
            return writableDataSet;
        }
    }

    public AsciiParser() {
        logger.fine("new ascii parser");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isKeepFileHeader() {
        return this.keepFileHeader;
    }

    public void setKeepFileHeader(boolean keepHeader) {
        boolean oldKeepHeader = this.keepFileHeader;
        this.keepFileHeader = keepHeader;
        this.propertyChangeSupport.firePropertyChange("keepHeader", oldKeepHeader, keepHeader);
    }

    public RecordParser getRecordParser() {
        return this.recordParser;
    }

    public void setRecordParser(RecordParser recordParser) {
        RecordParser oldRecordParser = this.recordParser;
        this.recordParser = recordParser;
        this.propertyChangeSupport.firePropertyChange("recordParser", oldRecordParser, recordParser);
    }

    public Units getUnits(int index) {
        if (this.units[index] == Units.dimensionless && this.fieldUnits[index] != null && this.fieldUnits[index].length() > 0) {
            return Units.lookupUnits((String)this.fieldUnits[index]);
        }
        return this.units[index];
    }

    public void setUnits(int index, Units units) {
        this._setUnits(index, units);
        if (this.fieldParsers[index] == DOUBLE_PARSER) {
            this.setFieldParser(index, this.UNITS_PARSER);
        }
        if (this.fieldParsers[index] == this.ENUMERATION_PARSER) {
            this.setFieldParser(index, this.UNITS_PARSER);
        }
        this.propertyChangeSupport.firePropertyChange("units", null, null);
    }

    public void setUnits(Units ... u) {
        System.arraycopy(u, 0, this.units, 0, u.length);
        for (int i = 0; i < u.length; ++i) {
            if (this.fieldParsers[i] == DOUBLE_PARSER) {
                this.setFieldParser(i, this.UNITS_PARSER);
            }
            if (this.fieldParsers[i] != this.ENUMERATION_PARSER) continue;
            this.setFieldParser(i, this.UNITS_PARSER);
        }
        this.propertyChangeSupport.firePropertyChange("units", null, null);
    }

    public int getFieldIndex(String string) {
        string = string.replaceAll(" ", "_");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        int icol = -1;
        if (Pattern.matches("field[0-9]+", string)) {
            icol = Integer.parseInt(string.substring(5));
        } else if (Pattern.matches("[0-9]+", string)) {
            icol = Integer.parseInt(string);
        }
        if (icol >= this.fieldCount) {
            throw new IllegalArgumentException("bad column parameter: the record parser only expects " + this.fieldCount + " columns");
        }
        return icol;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(double fillValue) {
        double oldFillValue = this.fillValue;
        this.fillValue = fillValue;
        this.propertyChangeSupport.firePropertyChange("fillValue", oldFillValue, fillValue);
    }

    public double getValidMin() {
        return this.validMin;
    }

    public void setValidMin(double validMin) {
        double oldValidMin = this.validMin;
        this.validMin = validMin;
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMIN, oldValidMin, validMin);
    }

    public double getValidMax() {
        return this.validMax;
    }

    public void setValidMax(double validMax) {
        double oldValidMax = this.validMax;
        this.validMax = validMax;
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMAX, oldValidMax, validMax);
    }

    static /* synthetic */ AtomicInteger access$100() {
        return currentSerialNumber;
    }

    public final class FixedColumnsParser
    implements RecordParser {
        int[] columnOffsets;
        int[] columnWidths;
        private final int fieldCount;

        public FixedColumnsParser(int[] columnOffsets, int[] columnWidths) {
            this.columnOffsets = Arrays.copyOf(columnOffsets, columnOffsets.length);
            this.columnWidths = Arrays.copyOf(columnWidths, columnWidths.length);
            this.fieldCount = columnOffsets.length;
        }

        @Override
        public int fieldCount() {
            return this.fieldCount;
        }

        @Override
        public String readNextRecord(BufferedReader reader) throws IOException {
            return reader.readLine();
        }

        @Override
        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            boolean[] fails = new boolean[this.fieldCount];
            int okayCount = 0;
            int failCount = 0;
            int tryCount = 0;
            for (int i = 0; i < this.fieldCount; ++i) {
                ++tryCount;
                try {
                    double d = AsciiParser.this.fieldParsers[i].parseField(line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]), i);
                    ++okayCount;
                    if (builder == null) continue;
                    builder.putValue(irec, i, d);
                    continue;
                }
                catch (NumberFormatException | ParseException ex) {
                    ++failCount;
                    fails[i] = true;
                }
            }
            if (failCount > 0) {
                System.err.println("error(s) parsing record number " + irec + ": ");
                System.err.println(line);
                char[] lineMarker = new char[this.columnOffsets[this.fieldCount - 1] + this.columnWidths[this.fieldCount - 1]];
                for (int i = 0; i < this.fieldCount; ++i) {
                    if (!fails[i]) continue;
                    for (int j = 0; j < this.columnWidths[i]; ++j) {
                        lineMarker[j + this.columnOffsets[i]] = 45;
                    }
                }
                System.err.println(new String(lineMarker));
            }
            return failCount < tryCount && (okayCount > 1 || failCount < 3);
        }

        @Override
        public int fieldCount(String line) {
            return line.split("\\s*").length;
        }

        public String[] fields(String line) {
            String[] result = new String[this.fieldCount];
            for (int i = 0; i < this.fieldCount; ++i) {
                result[i] = line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]);
            }
            return result;
        }

        @Override
        public boolean splitRecord(String line, String[] fields) {
            if (line.length() >= this.columnOffsets[this.fieldCount - 1] + this.columnWidths[this.fieldCount - 1]) {
                for (int i = 0; i < this.fieldCount; ++i) {
                    fields[i] = line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]);
                }
                return true;
            }
            return false;
        }
    }

    public static final class RegexParser
    implements RecordParser {
        Pattern recordPattern;
        AsciiParser parser;
        boolean doGuessUnits = true;

        public static String[] getNamedGroups(String regex) {
            Pattern p = Pattern.compile("\\(\\?\\<([a-zA-Z][0-9a-zA-Z]*)\\>");
            Pattern parenPattern = Pattern.compile("\\(");
            ArrayList<String> result = new ArrayList<String>();
            Matcher m = parenPattern.matcher(regex);
            while (m.find()) {
                if (m.start() == 0 || regex.charAt(m.start() - 1) != '\\') {
                    Matcher nm = p.matcher(regex.substring(m.start()));
                    if (nm.find() && nm.start() == 0) {
                        String name = nm.group(1);
                        result.add(name);
                        continue;
                    }
                    result.add("");
                    continue;
                }
                logger.finer("it wasn't actually a group, it was backslash paren");
            }
            return result.toArray(new String[result.size()]);
        }

        public RegexParser(AsciiParser parser, String regex) {
            this.recordPattern = Pattern.compile(regex);
            this.parser = parser;
            parser.initializeByFieldCount(this.recordPattern.matcher("").groupCount());
            String[] gg = RegexParser.getNamedGroups(regex);
            for (int i = 0; i < gg.length; ++i) {
                if (gg[i].length() <= 0 || i >= parser.fieldNames.length) continue;
                parser.fieldNames[i] = gg[i];
            }
        }

        @Override
        public int fieldCount() {
            return this.parser.fieldCount;
        }

        @Override
        public String readNextRecord(BufferedReader reader) throws IOException {
            return reader.readLine();
        }

        @Override
        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            Matcher m;
            if (this.recordPattern != null && (m = this.recordPattern.matcher(line)).matches()) {
                if (this.doGuessUnits) {
                    int i;
                    Units[] saveUnits = Arrays.copyOf(this.parser.units, this.parser.fieldCount);
                    FieldParser[] saveFieldParsers = Arrays.copyOf(this.parser.fieldParsers, this.parser.fieldCount);
                    String[] ss = new String[this.parser.fieldCount];
                    for (i = 0; i < this.parser.fieldCount; ++i) {
                        ss[i] = m.group(i + 1);
                    }
                    this.parser.initializeUnitsByGuessing(ss, 0);
                    for (i = 0; i < this.parser.fieldCount; ++i) {
                        if (saveUnits[i] == Units.dimensionless && saveFieldParsers[i] == DOUBLE_PARSER) continue;
                        this.parser.units[i] = saveUnits[i];
                        this.parser.fieldParsers[i] = saveFieldParsers[i];
                    }
                    this.doGuessUnits = false;
                }
                try {
                    boolean allInvalid = true;
                    for (int i = 0; i < this.parser.fieldCount; ++i) {
                        try {
                            String parseable = m.group(i + 1);
                            double d = this.parser.fieldParsers[i].parseField(parseable, i);
                            if (builder != null) {
                                builder.putValue(irec, i, d);
                            }
                            allInvalid = false;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return !allInvalid;
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public int fieldCount(String line) {
            return line.split("\\s*").length;
        }

        public String[] fields(String line) {
            Matcher m = this.recordPattern.matcher(line);
            String[] fields = new String[m.groupCount() - 1];
            for (int i = 0; i < this.parser.fieldCount; ++i) {
                fields[i] = m.group(i + 1);
            }
            return fields;
        }

        @Override
        public boolean splitRecord(String line, String[] fields) {
            Matcher m = this.recordPattern.matcher(line);
            if (m.matches()) {
                for (int i = 0; i < this.parser.fieldCount; ++i) {
                    fields[i] = m.group(i + 1);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "RegexParser regex=" + this.recordPattern + "";
        }
    }

    public final class DelimParser
    implements RecordParser {
        int fieldCount;
        String delimRegex;
        Pattern delimPattern;
        boolean[] doParseField;
        public String header = null;
        boolean showException = true;
        boolean guessUnits = true;
        int serialNumber = AsciiParser.access$100().incrementAndGet();

        public DelimParser(int fieldCount, String delim) {
            this.fieldCount = fieldCount;
            this.doParseField = new boolean[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                this.doParseField[i] = true;
            }
            this.delimRegex = delim;
            this.delimPattern = Pattern.compile(delim);
            this.header = "";
        }

        public String getDelim() {
            return this.delimRegex;
        }

        public void setShowException(boolean s) {
            this.showException = s;
        }

        public void setGuessUnits(boolean guess) {
            this.guessUnits = guess;
        }

        @Override
        public String readNextRecord(BufferedReader reader) throws IOException {
            String line = reader.readLine();
            char rightDoubleQuote = '\u201d';
            String quoteSplit = "\"|" + rightDoubleQuote;
            while (line != null && line.split(quoteSplit, -2).length % 2 == 0) {
                if (line.length() > 100000) {
                    logger.warning("unable to find line delimiter, stopping at 100000 characters, check quotes");
                    break;
                }
                String nextLine = reader.readLine();
                if (nextLine == null) break;
                line = line + " " + nextLine;
            }
            return line;
        }

        @Override
        public boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            int j;
            int okayCount = 0;
            int failCount = 0;
            int tryCount = 0;
            if (this.fieldCount != AsciiParser.this.fieldParsers.length) {
                return false;
            }
            String[] ss = new String[this.fieldCount];
            if (!this.splitRecord(line, ss)) {
                return false;
            }
            if (this.guessUnits) {
                Units[] units0 = Arrays.copyOf(AsciiParser.this.units, this.fieldCount);
                FieldParser[] fieldParsers0 = Arrays.copyOf(AsciiParser.this.fieldParsers, this.fieldCount);
                AsciiParser.this.initializeUnitsByGuessing(ss, irec);
                int nonEnumCount = 0;
                for (j = 0; j < this.fieldCount; ++j) {
                    if (!UnitsUtil.isIntervalOrRatioMeasurement((Units)AsciiParser.this.units[j])) continue;
                    ++nonEnumCount;
                }
                if (nonEnumCount >= this.fieldCount / 2) {
                    this.guessUnits = false;
                    AsciiParser.this.parseMeta("", builder);
                } else {
                    System.arraycopy(units0, 0, AsciiParser.this.units, 0, this.fieldCount);
                    System.arraycopy(fieldParsers0, 0, AsciiParser.this.fieldParsers, 0, this.fieldCount);
                }
            }
            Throwable firstException = null;
            for (j = 0; j < this.fieldCount; ++j) {
                ++tryCount;
                if (!this.doParseField[j]) continue;
                String parseable = ss[j];
                if (parseable.length() == 0) {
                    if (AsciiParser.this.units[j] instanceof EnumerationUnits) {
                        if (builder == null) continue;
                        builder.putValue(irec, j, AsciiParser.this.units[j].getFillDouble());
                        continue;
                    }
                    if (builder == null) continue;
                    builder.putValue(irec, j, -1.0E31);
                    continue;
                }
                try {
                    double d = AsciiParser.this.fieldParsers[j].parseField(parseable, j);
                    if (builder != null) {
                        builder.putValue(irec, j, d);
                    }
                    ++okayCount;
                    continue;
                }
                catch (NumberFormatException | ParseException | InconvertibleUnitsException e) {
                    if (irec == 0) {
                        logger.finest("ignore fails on the first line");
                        ++failCount;
                    } else {
                        if (firstException == null && j < this.fieldCount - 1) {
                            firstException = e;
                        }
                        ++failCount;
                    }
                    if (builder == null) continue;
                    builder.putValue(irec, j, -1.0E31);
                }
            }
            logger.log(Level.FINER, "line {0} okayCount: {1} failCount: {2}", new Object[]{irec, okayCount, failCount});
            if (firstException != null && failCount > 0 && failCount < this.fieldCount && this.showException) {
                if (firstException instanceof ParseException) {
                    logger.log(Level.FINE, "The following exception occurred while parsing: " + firstException.getMessage(), firstException);
                    this.showException = false;
                } else {
                    logger.log(Level.WARNING, "The following exception occurred while parsing: " + firstException.getMessage(), firstException);
                    this.showException = false;
                }
            }
            int enumFieldCount = tryCount - AsciiParser.this.nonEnumFields;
            if (AsciiParser.this.nonEnumFields > -1) {
                if (this.guessUnits) {
                    return false;
                }
                return failCount < tryCount && (okayCount > enumFieldCount + 1 || failCount < 3 - enumFieldCount);
            }
            if (tryCount < 5) {
                return okayCount > failCount;
            }
            return failCount < tryCount && (okayCount > 1 || failCount < 3);
        }

        @Override
        public int fieldCount() {
            return this.fieldCount;
        }

        @Override
        public int fieldCount(String line) {
            if (line.endsWith(AsciiParser.DELIM_COMMA)) {
                return this.fields(line).length + 1;
            }
            return this.fields(line).length;
        }

        public void setSkipField(int ifield, boolean skip) {
            this.doParseField[ifield] = !skip;
        }

        private String[] fields(String line) {
            String[] many = new String[1000];
            this.splitRecord(line, many);
            int count = 0;
            for (int i = 0; i < many.length; ++i) {
                if (many[i] != null) continue;
                count = i;
                break;
            }
            String[] ss = new String[count];
            System.arraycopy(many, 0, ss, 0, count);
            return ss;
        }

        @Override
        public boolean splitRecord(String input, String[] fields) {
            int index = 0;
            int ifield = 0;
            Matcher m = this.delimPattern.matcher(input);
            boolean tabDelim = this.delimPattern.pattern().equals(AsciiParser.DELIM_TAB);
            char quote = '\"';
            int len = input.length();
            int index0 = index;
            int qend = -1;
            while (ifield < fields.length && index < len) {
                while (index < len && !tabDelim && Character.isWhitespace(input.charAt(index))) {
                    ++index;
                }
                if (index == len) break;
                if (input.charAt(index) == quote) {
                    index0 = ++index;
                    int i1 = input.indexOf(quote, index);
                    if (i1 == -1) {
                        System.err.println("unclosed quote: " + input);
                        continue;
                    }
                    while (i1 + 1 < input.length() && input.charAt(i1 + 1) == quote) {
                        if ((i1 = input.indexOf(quote, i1 + 2)) != -1) continue;
                        throw new IllegalArgumentException("unclosed quote");
                    }
                    index = i1 + 1;
                    qend = i1;
                    if (index != len && (ifield != fields.length - 1 || input.substring(index).trim().length() != 0)) continue;
                    fields[ifield] = input.substring(index0, qend);
                    if (ifield == fields.length - 1 && input.substring(index).trim().length() == 0) {
                        index = len;
                    }
                    ++ifield;
                    continue;
                }
                if (m.find(index)) {
                    if (qend == -1) {
                        index0 = index;
                    }
                    index = m.start();
                    if (qend == -1) {
                        fields[ifield] = input.substring(index0, index);
                    } else {
                        if (qend < index0) {
                            return false;
                        }
                        fields[ifield] = input.substring(index0, qend).replaceAll("\"\"", "\"");
                        qend = -1;
                    }
                    index0 = index = m.end();
                    ++ifield;
                    continue;
                }
                if (ifield == fields.length - 1) {
                    fields[ifield] = qend == -1 ? input.substring(index0) : input.substring(index0, qend);
                    ++ifield;
                    index = len;
                    continue;
                }
                fields[ifield] = input.substring(index0);
                return false;
            }
            if (index == len && ifield == fields.length - 1 && !this.delimPattern.toString().equals(" ")) {
                fields[ifield] = "";
                ++ifield;
            }
            for (int i = 0; i < ifield; ++i) {
                String s = fields[i];
                int n = s.length();
                if (n <= 0 || s.charAt(0) != '\"' || s.charAt(n - 1) != '\"') continue;
                fields[i] = s.substring(1, n - 1);
            }
            return ifield == fields.length && index == len;
        }

        public String toString() {
            return "AsciiParser.DelimParser: delim=" + this.delimRegex + " fieldCount=" + this.fieldCount + " serialNumber=" + this.serialNumber;
        }
    }

    public static interface FieldParser {
        public double parseField(String var1, int var2) throws ParseException;
    }

    public static interface RecordParser {
        public String readNextRecord(BufferedReader var1) throws IOException;

        public boolean tryParseRecord(String var1, int var2, DataSetBuilder var3);

        public int fieldCount();

        public int fieldCount(String var1);

        public boolean splitRecord(String var1, String[] var2);
    }
}

