/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.util.LinkedHashMap;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;

public class LSpec {
    public static final String USER_PROP_SWEEPS = "sweeps";
    public static int DIR_INWARD = -1;
    public static int DIR_OUTWARD = 1;
    public static int DIR_BOTH = 0;

    private LSpec() {
    }

    public static QDataSet identifySweeps(QDataSet lds, int dir) {
        DataSetBuilder builder = new DataSetBuilder(2, 100, 2);
        DataSetBuilder dep0builder = new DataSetBuilder(2, 100, 2);
        double slope0 = lds.value(1) - lds.value(0);
        int start = 0;
        int end = 0;
        QDataSet wds = SemanticOps.weightsDataSet(lds);
        ArrayDataSet tds = ArrayDataSet.copy(SemanticOps.xtagsDataSet(lds));
        wds = Ops.multiply(wds, SemanticOps.weightsDataSet(tds));
        Datum cadence = SemanticOps.guessXTagWidth(tds, lds);
        cadence = cadence.multiply(10.0);
        tds.putProperty("CADENCE", DataSetUtil.asDataSet(cadence));
        QDataSet nonGap = SemanticOps.cadenceCheck(tds, lds);
        for (int i = 1; i < lds.length(); ++i) {
            double slope1 = lds.value(i) - lds.value(i - 1);
            if (slope0 * slope1 <= 0.0 || nonGap.value(i - 1) == 1.0 && nonGap.value(i) == 0.0) {
                if (slope0 != 0.0 && (dir == 0 || slope0 * (double)dir > 0.0 && end - start > 1) && start < end) {
                    builder.putValue(-1, 0, start);
                    builder.putValue(-1, 1, end - 1);
                    builder.nextRecord();
                    dep0builder.putValue(-1, 0, tds.slice(start));
                    dep0builder.putValue(-1, 1, tds.slice(end - 1));
                    dep0builder.nextRecord();
                }
                if (slope1 != 0.0 || nonGap.value(i) > 0.0) {
                    start = i;
                }
            } else if (wds.value(i) > 0.0) {
                if (nonGap.value(i - 1) == 0.0 && nonGap.value(i) == 1.0) {
                    start = i;
                    end = i + 1;
                } else {
                    end = i + 1;
                }
            }
            slope0 = slope1;
        }
        dep0builder.putProperty("BINS_1", "min,maxInclusive");
        dep0builder.putProperty("UNITS", SemanticOps.getUnits(tds));
        DDataSet result = builder.getDataSet();
        result.putProperty("DEPEND_0", dep0builder.getDataSet());
        result.putProperty("RENDER_TYPE", "eventsBar");
        return result;
    }

    private static int findIndex(QDataSet datax, int start, int end, double x, int guess, int dir) {
        int index;
        if (dir > 0) {
            for (index = Math.max(Math.min(guess, end - 1), start); index < end && datax.value(index + 1) < x; ++index) {
            }
            while (index > start && datax.value(index) > x) {
                --index;
            }
        } else {
            while (index < end && datax.value(index + 1) > x) {
                ++index;
            }
            while (index > start && datax.value(index) < x) {
                --index;
            }
        }
        return index;
    }

    private static void interpolate(QDataSet lds, QDataSet zds, int start, int end, int col, QDataSet lgrid, DDataSet ds) {
        Units u = SemanticOps.getUnits(ds);
        double fill = u.getFillDouble();
        ds.putProperty("FILL_VALUE", fill);
        if (!u.equals(SemanticOps.getUnits(zds))) {
            throw new IllegalArgumentException("zds units must be the same as ds units!");
        }
        QDataSet wds = Ops.valid(zds);
        int dir = (int)Math.signum(lds.value(end) - lds.value(start));
        int index = dir > 0 ? start : end;
        for (int i = 0; i < lgrid.length(); ++i) {
            double ll = lgrid.value(i);
            double alpha = (ll - lds.value(index = LSpec.findIndex(lds, start, end, ll, index, dir))) / (lds.value(index + 1) - lds.value(index));
            if (alpha < 0.0) {
                ds.putValue(col, i, fill);
                continue;
            }
            if (alpha > 1.0) {
                ds.putValue(col, i, fill);
                continue;
            }
            if (alpha == 0.0) {
                ds.putValue(col, i, zds.value(index));
                continue;
            }
            if (wds.value(index) == 0.0 || wds.value(index + 1) == 0.0) {
                ds.putValue(col, i, fill);
                continue;
            }
            ds.putValue(col, i, zds.value(index) * (1.0 - alpha) + zds.value(index + 1) * alpha);
        }
    }

    public static QDataSet rebin(QDataSet lds, QDataSet zds, QDataSet lgrid) {
        return LSpec.rebin(lds, zds, lgrid, 0);
    }

    public static QDataSet rebin(QDataSet tlz, QDataSet lgrid, int dir) {
        QDataSet lds = Ops.link(Ops.slice1(tlz, 0), Ops.slice1(tlz, 1));
        QDataSet zds = Ops.slice1(tlz, 2);
        return LSpec.rebin(lds, zds, lgrid, dir);
    }

    public static QDataSet rebin(QDataSet tt, QDataSet lds, QDataSet zds, QDataSet tspace, QDataSet lgrid, int dir) {
        int i;
        QDataSet sweeps = LSpec.identifySweeps(lds, dir);
        if (tt == null) {
            tt = (QDataSet)lds.property("DEPEND_0");
        }
        Units tu = SemanticOps.getUnits(tt);
        Number fill = (Number)zds.property("FILL_VALUE");
        double dfill = fill == null ? -1.0E31 : fill.doubleValue();
        QDataSet wds = DataSetUtil.weightsDataSet(zds);
        int ny = lgrid.length();
        double[] ss = new double[ny];
        double[] nn = new double[ny];
        DataSetBuilder builder = new DataSetBuilder(2, 100, ny);
        DataSetBuilder tbuilder = new DataSetBuilder(1, 100);
        tbuilder.putProperty("UNITS", tu);
        builder.putProperty("FILL_VALUE", dfill);
        int ix = -1;
        double nextx = Double.MAX_VALUE;
        double dt = DataSetUtil.asDatum(tspace).doubleValue(tu.getOffsetUnits());
        double t0 = -1.0;
        double dg = lgrid.value(1) - lgrid.value(0);
        double g0 = lgrid.value(0);
        int n = ny - 1;
        for (i = 2; i < n; ++i) {
        }
        for (i = 0; i < sweeps.length(); ++i) {
            int ist = (int)sweeps.value(i, 0);
            int ien = (int)sweeps.value(i, 1);
            for (int j = ist; j < ien; ++j) {
                double w;
                int iy;
                if (ix == -1 || tt.value(j) - nextx >= 0.0) {
                    int k;
                    nextx = dt * Math.ceil(tt.value(j) / dt);
                    if (ix > -1) {
                        for (k = 0; k < ny; ++k) {
                            if (nn[k] == 0.0) {
                                builder.putValue(-1, k, dfill);
                                continue;
                            }
                            builder.putValue(-1, k, ss[k] / nn[k]);
                        }
                        builder.nextRecord();
                        tbuilder.putValue(-1, t0 - dt / 2.0);
                        tbuilder.nextRecord();
                    }
                    t0 = nextx;
                    for (k = 0; k < ny; ++k) {
                        ss[k] = 0.0;
                        nn[k] = 0.0;
                    }
                    ++ix;
                }
                if ((iy = (int)Math.floor((lds.value(j) - g0) / dg)) < 0 || iy >= ny || !((w = wds.value(j)) > 0.0)) continue;
                int n2 = iy;
                ss[n2] = ss[n2] + w * zds.value(j);
                int n3 = iy;
                nn[n3] = nn[n3] + w;
            }
        }
        DDataSet result = builder.getDataSet();
        result.putProperty("DEPEND_0", tbuilder.getDataSet());
        result.putProperty("DEPEND_1", lgrid);
        DataSetUtil.copyDimensionProperties(zds, result);
        String title = (String)result.property("TITLE");
        if (title == null) {
            title = "";
        }
        if (dir == -1) {
            title = title + "!cinward";
        } else if (dir == 1) {
            title = title + "!coutward";
        }
        result.putProperty("TITLE", title);
        result.putProperty("FILL_VALUE", dfill);
        return result;
    }

    public static QDataSet rebin(QDataSet lds, QDataSet zds, QDataSet lgrid, int dir) {
        QDataSet sweeps = LSpec.identifySweeps(lds, dir);
        DDataSet result = DDataSet.createRank2(sweeps.length(), lgrid.length());
        result.putProperty("UNITS", zds.property("UNITS"));
        for (int i = 0; i < sweeps.length(); ++i) {
            LSpec.interpolate(lds, zds, (int)sweeps.value(i, 0), (int)sweeps.value(i, 1), i, lgrid, result);
        }
        DDataSet xtags = DDataSet.createRank2(sweeps.length(), 2);
        QDataSet dep0 = (QDataSet)lds.property("DEPEND_0");
        if (dep0 != null) {
            for (int i = 0; i < sweeps.length(); ++i) {
                xtags.putValue(i, 0, dep0.value((int)sweeps.value(i, 0)));
                xtags.putValue(i, 1, dep0.value((int)sweeps.value(i, 1)));
            }
            DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(dep0, null), xtags);
            Units xunits = SemanticOps.getUnits(dep0);
            xtags.putProperty("UNITS", xunits);
            xtags.putProperty("BINS_1", "min,max");
            xtags.putProperty("MONOTONIC", DataSetUtil.isMonotonic(dep0));
        } else {
            for (int i = 0; i < sweeps.length(); ++i) {
                xtags.putValue(i, 0, sweeps.value(i, 0));
                xtags.putValue(i, 1, sweeps.value(i, 1));
            }
        }
        LinkedHashMap<String, QDataSet> userProps = new LinkedHashMap<String, QDataSet>();
        userProps.put(USER_PROP_SWEEPS, sweeps);
        result.putProperty("USER_PROPERTIES", userProps);
        if (lgrid.property("UNITS") == null) {
            ArrayDataSet lgridCopy = ArrayDataSet.copy(lgrid);
            Units u = (Units)lds.property("UNITS");
            if (u != null) {
                lgridCopy.putProperty("UNITS", u);
            }
            lgrid = lgridCopy;
        }
        result.putProperty("DEPEND_1", lgrid);
        result.putProperty("DEPEND_0", xtags);
        DataSetUtil.putProperties(DataSetUtil.getDimensionProperties(zds, null), result);
        return result;
    }
}

