/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;

public final class LttbDownsampler {
    private LttbDownsampler() {
    }

    public static QDataSet lttb(QDataSet yData, int threshold) {
        int i;
        int dataLength = yData.length();
        if (dataLength == 0) {
            return yData;
        }
        if (threshold >= dataLength || threshold <= 2) {
            return yData;
        }
        QDataSet xDep = (QDataSet)yData.property("DEPEND_0");
        double[] x = new double[dataLength];
        double[] y = new double[dataLength];
        if (xDep != null) {
            for (i = 0; i < dataLength; ++i) {
                x[i] = xDep.value(i);
            }
        } else {
            for (i = 0; i < dataLength; ++i) {
                x[i] = i;
            }
        }
        for (i = 0; i < dataLength; ++i) {
            y[i] = yData.value(i);
        }
        double[] sampledX = new double[threshold];
        double[] sampledY = new double[threshold];
        int sampledIndex = 0;
        sampledX[sampledIndex] = x[0];
        sampledY[sampledIndex] = y[0];
        ++sampledIndex;
        double bucketSize = (double)(dataLength - 2) / (double)(threshold - 2);
        int a = 0;
        for (int i2 = 0; i2 < threshold - 2; ++i2) {
            int avgRangeLength;
            int avgRangeStart = (int)Math.floor((double)(i2 + 1) * bucketSize) + 1;
            int avgRangeEnd = (int)Math.floor((double)(i2 + 2) * bucketSize) + 1;
            if (avgRangeEnd > dataLength) {
                avgRangeEnd = dataLength;
            }
            if ((avgRangeLength = avgRangeEnd - avgRangeStart) < 1) {
                avgRangeLength = 1;
                avgRangeEnd = (avgRangeStart = Math.max(avgRangeStart, 1)) + 1;
                if (avgRangeEnd > dataLength) {
                    avgRangeEnd = dataLength;
                    avgRangeStart = avgRangeEnd - 1;
                }
            }
            double avgX = 0.0;
            double avgY = 0.0;
            for (int j = avgRangeStart; j < avgRangeEnd; ++j) {
                avgX += x[j];
                avgY += y[j];
            }
            avgX /= (double)avgRangeLength;
            avgY /= (double)avgRangeLength;
            int rangeOffs = (int)Math.floor((double)i2 * bucketSize) + 1;
            int rangeTo = (int)Math.floor((double)(i2 + 1) * bucketSize) + 1;
            rangeTo = Math.min(rangeTo, dataLength - 1);
            double maxArea = -1.0;
            int maxAreaIndex = rangeOffs;
            double ax = x[a];
            double ay = y[a];
            for (int j = rangeOffs; j < rangeTo; ++j) {
                double area = Math.abs((ax - avgX) * (y[j] - ay) - (ax - x[j]) * (avgY - ay));
                if (!(area > maxArea)) continue;
                maxArea = area;
                maxAreaIndex = j;
            }
            sampledX[sampledIndex] = x[maxAreaIndex];
            sampledY[sampledIndex] = y[maxAreaIndex];
            ++sampledIndex;
            a = maxAreaIndex;
        }
        sampledX[sampledIndex] = x[dataLength - 1];
        sampledY[sampledIndex] = y[dataLength - 1];
        DDataSet xOut = DDataSet.createRank1(threshold);
        DDataSet yOut = DDataSet.createRank1(threshold);
        for (int i3 = 0; i3 < threshold; ++i3) {
            xOut.putValue(i3, sampledX[i3]);
            yOut.putValue(i3, sampledY[i3]);
        }
        if (xDep != null && xDep.property("UNITS") != null) {
            xOut.putProperty("UNITS", xDep.property("UNITS"));
        }
        if (yData.property("UNITS") != null) {
            yOut.putProperty("UNITS", yData.property("UNITS"));
        }
        yOut.putProperty("DEPEND_0", xOut);
        return yOut;
    }
}

