/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.util.Arrays;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;

public class TransposeRankNDataSet
extends AbstractDataSet {
    QDataSet source;
    int[] order;
    int[] qube;
    final int shuffleType;
    private static final int SHUFFLE_123 = 0;
    private static final int SHUFFLE_132 = 1;
    private static final int SHUFFLE_213 = 2;
    private static final int SHUFFLE_231 = 3;
    private static final int SHUFFLE_312 = 4;
    private static final int SHUFFLE_321 = 5;

    public TransposeRankNDataSet(QDataSet source, int[] order) {
        this.source = source;
        this.order = new int[order.length];
        System.arraycopy(order, 0, this.order, 0, order.length);
        this.qube = DataSetUtil.qubeDims(source);
        for (int i = 0; i < source.rank(); ++i) {
            QDataSet depi = (QDataSet)source.property("DEPEND_" + order[i]);
            if (depi == null) continue;
            this.properties.put("DEPEND_" + i, depi);
        }
        int[] lorder = order;
        if (order.length == 4) {
            if (order[0] != 0) {
                throw new IllegalArgumentException("rank not supported unless order[0]=0");
            }
            lorder = Arrays.copyOfRange(order, 1, 4);
            int i = 0;
            while (i < lorder.length) {
                int n = i++;
                lorder[n] = lorder[n] - 1;
            }
        }
        switch (lorder[0]) {
            case 0: {
                if (lorder[1] == 1) {
                    this.shuffleType = 0;
                    break;
                }
                this.shuffleType = 1;
                break;
            }
            case 1: {
                if (lorder[1] == 0) {
                    this.shuffleType = 2;
                    break;
                }
                this.shuffleType = 3;
                break;
            }
            default: {
                this.shuffleType = lorder[1] == 0 ? 4 : 5;
            }
        }
    }

    @Override
    public int rank() {
        return this.source.rank();
    }

    @Override
    public double value(int i) {
        return super.value(i);
    }

    @Override
    public double value(int i0, int i1) {
        return this.source.value(i1, i0);
    }

    @Override
    public double value(int i1, int i2, int i3) {
        switch (this.shuffleType) {
            case 0: {
                return this.source.value(i1, i2, i3);
            }
            case 1: {
                return this.source.value(i1, i3, i2);
            }
            case 2: {
                return this.source.value(i2, i1, i3);
            }
            case 3: {
                return this.source.value(i2, i3, i1);
            }
            case 4: {
                return this.source.value(i3, i1, i2);
            }
            case 5: {
                return this.source.value(i3, i2, i1);
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        switch (this.shuffleType) {
            case 0: {
                return this.source.value(i0, i1, i2, i3);
            }
            case 1: {
                return this.source.value(i0, i1, i3, i2);
            }
            case 2: {
                return this.source.value(i0, i2, i1, i3);
            }
            case 3: {
                return this.source.value(i0, i2, i3, i1);
            }
            case 4: {
                return this.source.value(i0, i3, i1, i2);
            }
            case 5: {
                return this.source.value(i0, i3, i2, i1);
            }
        }
        throw new RuntimeException("implementation error");
    }

    @Override
    public Object property(String name) {
        Object v = this.properties.get(name);
        return v == null ? this.source.property(name) : v;
    }

    @Override
    public Object property(String name, int i) {
        Object v = this.properties.get(name);
        return v == null ? this.source.property(name, i) : v;
    }

    @Override
    public int length() {
        return this.qube[this.order[0]];
    }

    @Override
    public int length(int i) {
        return this.qube[this.order[1]];
    }

    @Override
    public int length(int i, int j) {
        return this.qube[this.order[2]];
    }

    @Override
    public int length(int i, int j, int k) {
        return this.qube[this.order[3]];
    }
}

