/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.das2.qds.filters;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;

/**
 * ApplyIndex allows a subset of the data to be extracted.  
 * @author jbf
 */
public class ApplyIndexEditorPanel extends javax.swing.JPanel implements FilterEditorPanel {

    private static final Logger logger= LoggerManager.getLogger("qdataset.filters");
    /**
     * Creates new form ApplyIndexEditorPanel
     */
    public ApplyIndexEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        dimensionCB = new javax.swing.JComboBox<>();
        indicesTF = new javax.swing.JComboBox<>();
        jButton1 = new javax.swing.JButton();

        jLabel1.setText("Dimension:");

        jLabel2.setText("Apply Index to a dimension, extracting a subset.");

        jLabel3.setText("Indices:");

        dimensionCB.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        indicesTF.setEditable(true);
        indicesTF.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "1", "2,4,6", "1-3,4:40:2", "~2-4" }));
        indicesTF.setSelectedItem("");

        jButton1.setText("?");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(dimensionCB, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 102, Short.MAX_VALUE)
                        .addComponent(jButton1))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(indicesTF, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jButton1))
                .addGap(7, 7, 7)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(dimensionCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(indicesTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        try {
            java.net.URI target= new URI("http://autoplot.org//filters#applyIndex");
            Desktop.getDesktop().browse( target );
        } catch (URISyntaxException | IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_jButton1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> dimensionCB;
    private javax.swing.JComboBox<String> indicesTF;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    // End of variables declaration//GEN-END:variables

    @Override
    public String getFilter() {
        return "|applyIndex"+dimensionCB.getSelectedIndex()+"("+indicesTF.getSelectedItem()+")";
    }

    public static final String PROP_REGEX= "\\|?applyIndex(\\d)\\((\\~?(\\d+|\\,|\\:|\\-)+)\\)";
    
    @Override
    public void setFilter(String filter) {
        Pattern p= Pattern.compile(PROP_REGEX );
        Matcher m= p.matcher(filter);
        if ( m.matches() ) {
            dimensionCB.setSelectedIndex( Integer.parseInt(m.group(1)) );
            indicesTF.setSelectedItem( m.group(2) );
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void setInput(QDataSet ds) {
        String[] depNames1= FilterEditorPanelUtil.getDimensionNames(ds);
        int index= dimensionCB.getSelectedIndex();
        dimensionCB.setModel(new DefaultComboBoxModel(depNames1));
        try {
            dimensionCB.setSelectedIndex(index);
        } catch ( IllegalArgumentException ex ) {
            dimensionCB.setSelectedIndex(depNames1.length-1);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateFilter(String filter, QDataSet in) {
        return true;
    }

    @Override
    public void setExpertMode(boolean expert) {
        dimensionCB.setEnabled(expert);
    }
}
