/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.das2.qds.filters;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

/**
 *
 * @author mmclouth
 */
public class ButterworthFilterEditorPanel extends AbstractFilterEditorPanel {
    private String tf;

    /**
     * Creates new form ButterworthFilterEditorPane
     */
    public ButterworthFilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        orderPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        orderCB = new javax.swing.JComboBox();
        subPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        type1CB = new javax.swing.JComboBox();
        subPanel3 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        cutoffFreq = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        subPanel4 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        lowFreq = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        highFreq = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();

        FormListener formListener = new FormListener();

        jLabel1.setText("Order:  ");

        orderCB.setEditable(true);
        orderCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "1", "2", "3", "4", "5", "6", "7", "8" }));

        jLabel2.setText("Type:");

        type1CB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "High-Pass", "Low-Pass", "Band-Pass", "Band-Reject" }));
        type1CB.addActionListener(formListener);

        org.jdesktop.layout.GroupLayout subPanel1Layout = new org.jdesktop.layout.GroupLayout(subPanel1);
        subPanel1.setLayout(subPanel1Layout);
        subPanel1Layout.setHorizontalGroup(
            subPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(subPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(subPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(subPanel1Layout.createSequentialGroup()
                        .add(12, 12, 12)
                        .add(type1CB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jLabel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 55, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(0, 0, Short.MAX_VALUE))
        );
        subPanel1Layout.setVerticalGroup(
            subPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(subPanel1Layout.createSequentialGroup()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(type1CB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        org.jdesktop.layout.GroupLayout orderPanelLayout = new org.jdesktop.layout.GroupLayout(orderPanel);
        orderPanel.setLayout(orderPanelLayout);
        orderPanelLayout.setHorizontalGroup(
            orderPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(orderPanelLayout.createSequentialGroup()
                .add(orderPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(orderPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(orderPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(orderPanelLayout.createSequentialGroup()
                                .add(12, 12, 12)
                                .add(orderCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jLabel1)))
                    .add(subPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        orderPanelLayout.setVerticalGroup(
            orderPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(orderPanelLayout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(orderCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(0, 86, Short.MAX_VALUE))
        );

        jLabel10.setText("Cutoff Frequency:");

        cutoffFreq.setPreferredSize(new java.awt.Dimension(75, 27));

        jLabel3.setText("Hz");

        org.jdesktop.layout.GroupLayout subPanel3Layout = new org.jdesktop.layout.GroupLayout(subPanel3);
        subPanel3.setLayout(subPanel3Layout);
        subPanel3Layout.setHorizontalGroup(
            subPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, subPanel3Layout.createSequentialGroup()
                .addContainerGap(25, Short.MAX_VALUE)
                .add(cutoffFreq, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3)
                .add(10, 10, 10))
            .add(subPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel10)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        subPanel3Layout.setVerticalGroup(
            subPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(subPanel3Layout.createSequentialGroup()
                .add(jLabel10)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cutoffFreq, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3)))
        );

        jLabel4.setText("Low Frequency:");

        lowFreq.setName("lowf"); // NOI18N
        lowFreq.setPreferredSize(new java.awt.Dimension(75, 27));

        jLabel5.setText("Hz");

        jLabel6.setText("High Frequency:");

        highFreq.setPreferredSize(new java.awt.Dimension(75, 27));

        jLabel7.setText("Hz");

        org.jdesktop.layout.GroupLayout subPanel4Layout = new org.jdesktop.layout.GroupLayout(subPanel4);
        subPanel4.setLayout(subPanel4Layout);
        subPanel4Layout.setHorizontalGroup(
            subPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(subPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(subPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel6)
                    .add(subPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(subPanel4Layout.createSequentialGroup()
                            .add(19, 19, 19)
                            .add(highFreq, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(jLabel7))
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, subPanel4Layout.createSequentialGroup()
                            .add(12, 12, 12)
                            .add(lowFreq, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(jLabel5)))
                    .add(jLabel4))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        subPanel4Layout.setVerticalGroup(
            subPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(subPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel4)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lowFreq, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel6)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel7)
                    .add(highFreq, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 27, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(17, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(orderPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(subPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(subPanel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(orderPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(layout.createSequentialGroup()
                .add(subPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(subPanel4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener {
        FormListener() {}
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == type1CB) {
                ButterworthFilterEditorPanel.this.type1CBActionPerformed(evt);
            }
        }
    }// </editor-fold>//GEN-END:initComponents

    private void setType( int type ) {
        switch (type) {
            case 0:
                subPanel3.setVisible(true);
                subPanel4.setVisible(false);
                break;
            case 1:
                subPanel3.setVisible(true);
                subPanel4.setVisible(false);
                break;
            case 2:
                subPanel3.setVisible(false);
                subPanel4.setVisible(true);
                break;
            case 3:
                subPanel3.setVisible(false);
                subPanel4.setVisible(true);
                break;
            default:
                break;
        }
        
    }
    
    private void type1CBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_type1CBActionPerformed
        setType( type1CB.getSelectedIndex() );    
    }//GEN-LAST:event_type1CBActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            logger.log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>
        
        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                FilterEditorPanel p= new ButterworthFilterEditorPanel();
                p.setFilter("|butterworth(1,45.,46.,True)");
                JOptionPane.showMessageDialog( null, p );
                System.err.println( p.getFilter() );
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.JTextField cutoffFreq;
    public javax.swing.JTextField highFreq;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel10;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JLabel jLabel3;
    public javax.swing.JLabel jLabel4;
    public javax.swing.JLabel jLabel5;
    public javax.swing.JLabel jLabel6;
    public javax.swing.JLabel jLabel7;
    public javax.swing.JTextField lowFreq;
    public javax.swing.JComboBox orderCB;
    public javax.swing.JPanel orderPanel;
    public javax.swing.JPanel subPanel1;
    public javax.swing.JPanel subPanel3;
    public javax.swing.JPanel subPanel4;
    public javax.swing.JComboBox type1CB;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setFilter(String filter) {
        String dec= FilterEditorPanelUtil.decimalRegexSloppy();
        String decw= "\\s*("+dec+")\\s*";
        Pattern p= Pattern.compile("\\|butterworth\\((\\d),"+decw+",(\\w+)\\)");
        Pattern p1= Pattern.compile("\\|butterworth\\((\\d),"+decw+","+decw+",(\\w+)\\)");
        Matcher m= p.matcher(filter);
        Matcher n= p1.matcher(filter);
        if ( m.matches() ) {
            //System.out.println("M matches");
            orderCB.setSelectedItem( m.group(1) );
            cutoffFreq.setText( m.group(2) );
            switch (m.group(3)) {
                case "True":
                    type1CB.setSelectedIndex(1);
                    break;
                case "False":
                    type1CB.setSelectedIndex(0);
                    break;
                default:
                    type1CB.setSelectedIndex(0);
                    break;
            }
        }
        else if (n.matches()) {
            //System.out.println("N matches");
            orderCB.setSelectedItem( n.group(1) );
            lowFreq.setText( n.group(2) );
            highFreq.setText( n.group(3) );
            switch (n.group(4)) {
                case "True":
                    type1CB.setSelectedIndex(2);
                    break;
                case "False":
                    type1CB.setSelectedIndex(3);
                    break;
                default:
                    type1CB.setSelectedIndex(0);
                    break;
            }
        }
        else {
            orderCB.setSelectedIndex( 0 );
            lowFreq.setText( "0" );
            highFreq.setText( "50" );
            cutoffFreq.setText("10");
            type1CB.setSelectedIndex(0);
        }
        setType(type1CB.getSelectedIndex());
        }

    

    @Override
    public String getFilter() {
         
        if (type1CB.getSelectedItem().equals("Low-Pass")) {
            tf = "True";
            return "|butterworth(" + orderCB.getSelectedItem() + "," + cutoffFreq.getText() + "," + tf + ")";
        }
        else if (type1CB.getSelectedItem().equals("High-Pass")) {
            tf = "False";
            return "|butterworth(" + orderCB.getSelectedItem() + "," + cutoffFreq.getText() + "," + tf + ")";
        }

        else if (type1CB.getSelectedItem().equals("Band-Pass")) {
            tf = "True";
            return "|butterworth(" + orderCB.getSelectedItem() + "," + lowFreq.getText() + "," + highFreq.getText() + "," + tf + ")";
        }
        else if (type1CB.getSelectedItem().equals("Band-Reject")) {
            tf = "False";
            return "|butterworth(" + orderCB.getSelectedItem() + "," + lowFreq.getText() + "," + highFreq.getText() + "," + tf + ")";
        }
        else {
            // return something, so the user doesn't loose so much info.
            tf = "False";
            return "|butterworth(" + orderCB.getSelectedItem() + "," + cutoffFreq.getText() + "," + tf + ")";
        }
    }
    
    public String getHighFreq() {
        return highFreq.getText();
    }
    
    public String getLowFreq()  {
        return lowFreq.getText();
    }
}
         

            
    
