/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import org.das2.qds.QDataSet;

/**
 *
 * @author jbf
 */
public class CollapseFilterEditorPanel extends javax.swing.JPanel implements FilterEditorPanel {

    /**
     * Creates new form CollapseFilterEditorPanel
     */
    public CollapseFilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this
     * code. The content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel2 = new javax.swing.JLabel();
        dimensionCB = new javax.swing.JComboBox();

        jLabel2.setText("Collapse Dimension:");

        dimensionCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dimensionCB, 0, 267, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(dimensionCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox dimensionCB;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables

    @Override
    public String getFilter() {
        return String.format( "|collapse%d()", dimensionCB.getSelectedIndex() );
    }

    @Override
    public void setFilter(String filter) {
        Pattern p= Pattern.compile("\\|collapse(\\d)\\(\\)");
        Matcher m= p.matcher(filter);
        if ( m.matches() ) {
            dimensionCB.setSelectedIndex( Integer.parseInt(m.group(1)) );
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void setInput(QDataSet ds) {
        String[] depNames1= FilterEditorPanelUtil.getDimensionNames(ds);
        int index= dimensionCB.getSelectedIndex();
        dimensionCB.setModel(new DefaultComboBoxModel(depNames1));
        try {
            dimensionCB.setSelectedIndex(index);
        } catch ( IllegalArgumentException ex ) {
            dimensionCB.setSelectedIndex(depNames1.length-1);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateFilter(String filter, QDataSet in) {
        return true;
    }

    @Override
    public void setExpertMode(boolean expert) {
        dimensionCB.setEnabled(expert);
    }
}
