/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Controller for dbAboveBackgroundFilter.
 * @author mmclouth
 */
public class DbAboveBackgroundDim1FilterEditorPanel extends AbstractFilterEditorPanel {

    /**
     * Creates new form dbAboveBackgroundDim1FilterEditorPanel
     */
    public DbAboveBackgroundDim1FilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        percentTF = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        voltageButton = new javax.swing.JRadioButton();
        powerRadioButton = new javax.swing.JRadioButton();

        FormListener formListener = new FormListener();

        jLabel1.setText("Show data as decibels above the ");

        percentTF.setText("10");
        percentTF.setPreferredSize(new java.awt.Dimension(40, 27));

        jLabel2.setText("% level,");

        buttonGroup1.add(voltageButton);
        voltageButton.setSelected(true);
        voltageButton.setText("input data are proportional to field intensity (20 * log10( ds / background ))");
        voltageButton.addActionListener(formListener);

        buttonGroup1.add(powerRadioButton);
        powerRadioButton.setText("input data are proportional to power (10 * log10( ds / background ))");
        powerRadioButton.addActionListener(formListener);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .add(1, 1, 1)
                        .add(percentTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(3, 3, 3)
                        .add(jLabel2))
                    .add(voltageButton)
                    .add(powerRadioButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(percentTF, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(voltageButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(powerRadioButton)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener {
        FormListener() {}
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == voltageButton) {
                DbAboveBackgroundDim1FilterEditorPanel.this.voltageButtonActionPerformed(evt);
            }
            else if (evt.getSource() == powerRadioButton) {
                DbAboveBackgroundDim1FilterEditorPanel.this.powerRadioButtonActionPerformed(evt);
            }
        }
    }// </editor-fold>//GEN-END:initComponents

    private void powerRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_powerRadioButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_powerRadioButtonActionPerformed

    private void voltageButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_voltageButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_voltageButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.ButtonGroup buttonGroup1;
    public javax.swing.JLabel jLabel1;
    public javax.swing.JLabel jLabel2;
    public javax.swing.JTextField percentTF;
    public javax.swing.JRadioButton powerRadioButton;
    public javax.swing.JRadioButton voltageButton;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setFilter(String filter) {
        Pattern p= Pattern.compile("\\|dbAboveBackgroundDim1\\((\\d+)\\)");
        Matcher m= p.matcher(filter);
        if ( m.matches() ) {
            percentTF.setText(m.group(1));
            powerRadioButton.setSelected(false);
            voltageButton.setSelected(true);
            
        } else {
            Pattern p2= Pattern.compile("\\|dbAboveBackgroundDim1\\((\\d+),(True|False)\\)");
            Matcher m2= p2.matcher(filter);
            if ( m2.matches() ) {
                percentTF.setText(m2.group(1));
                powerRadioButton.setSelected(m2.group(2).equals("True"));
                voltageButton.setSelected(!m2.group(2).equals("True"));
            } else {
                percentTF.setText("10");
            }
        }
        
    }

    @Override
    public String getFilter() {
        if ( powerRadioButton.isSelected() ) {
            return "|dbAboveBackgroundDim1(" + percentTF.getText() + ",True)";
        } else {
            return "|dbAboveBackgroundDim1(" + percentTF.getText() + ")";
        }
    }
}
