
package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;

/**
 * Controller for histogram filter allows automatic mode and min/max/bins.
 * @author jbf
 */
public class HistogramFilterEditorPanel extends AbstractFilterEditorPanel {

    static String PROP_REGEX = "\\|histogram\\(\\s*([^,]+)\\s*,\\s*([^,]+)\\s*,\\s*([^,]+(\\s*[^,]+\\s*))?\\)";

    /**
     * Creates new form HistogramFilterEditorPanel
     */
    public HistogramFilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        manualCB = new javax.swing.JCheckBox();
        paramsPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        binsizeTF = new javax.swing.JTextField();
        maximumTF = new javax.swing.JTextField();
        minimumTF = new javax.swing.JTextField();

        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                formFocusLost(evt);
            }
        });

        manualCB.setText("Configure Histogram Manually");

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, paramsPanel, org.jdesktop.beansbinding.ELProperty.create("${visible}"), manualCB, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        jLabel1.setText("Minimum:");

        jLabel2.setText("Maximum:");

        jLabel3.setText("Bin Size:");

        binsizeTF.setText("1");

        maximumTF.setText("10");

        minimumTF.setText("0");
        minimumTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                minimumTFActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout paramsPanelLayout = new javax.swing.GroupLayout(paramsPanel);
        paramsPanel.setLayout(paramsPanelLayout);
        paramsPanelLayout.setHorizontalGroup(
            paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(paramsPanelLayout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addGroup(paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(maximumTF, javax.swing.GroupLayout.PREFERRED_SIZE, 296, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(minimumTF, javax.swing.GroupLayout.PREFERRED_SIZE, 301, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(binsizeTF, javax.swing.GroupLayout.PREFERRED_SIZE, 167, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(13, Short.MAX_VALUE))
        );

        paramsPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {maximumTF, minimumTF});

        paramsPanelLayout.setVerticalGroup(
            paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, paramsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(minimumTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(maximumTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(paramsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(binsizeTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(paramsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(manualCB)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(manualCB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(paramsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

    private void minimumTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_minimumTFActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_minimumTFActionPerformed

    private void formFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusLost
        System.err.println("hfep: focus lost");
    }//GEN-LAST:event_formFocusLost


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField binsizeTF;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JCheckBox manualCB;
    private javax.swing.JTextField maximumTF;
    private javax.swing.JTextField minimumTF;
    private javax.swing.JPanel paramsPanel;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setFilter(String filter) {
        Pattern p1= Pattern.compile( PROP_REGEX );
        Pattern p2= Pattern.compile("\\|histogram\\(\\s*\\)");
        Matcher m= p1.matcher(filter);
        Matcher n= p2.matcher(filter);
        if ( m.matches() ) {
            minimumTF.setText(m.group(1));
            maximumTF.setText(m.group(2));
            binsizeTF.setText(m.group(3));
            manualCB.setSelected(true);
        } else if ( n.matches() ) {
            manualCB.setSelected(false);
        }
    }
     
    @Override
    public String getFilter() {
        if ( manualCB.isSelected() ) {
            return "|histogram("+minimumTF.getText()+","+maximumTF.getText()+","+binsizeTF.getText()+")";
        } else {
            return "|histogram()";
        }
    }
    
    @Override
    public void setInput( QDataSet ds ) {
        QDataSet h= Ops.autoHistogram(ds);
        QDataSet dep0= (QDataSet) h.property(QDataSet.DEPEND_0);
        QDataSet extent= Ops.extent(dep0);
        QDataSet s= extent.slice(0);
        Units u= SemanticOps.getUnits(s);
        if ( manualCB.isSelected() ) {
            logger.fine("manual, skip");
        } else {
            if ( UnitsUtil.isTimeLocation(u) ) {
                minimumTF.setText( extent.slice(0).toString().trim() );
                maximumTF.setText( extent.slice(1).toString().trim() );
                binsizeTF.setText( Ops.subtract( dep0.slice(1), dep0.slice(0) ).toString().trim() );        
            } else {
                minimumTF.setText( String.valueOf( extent.slice(0).value() ) );
                maximumTF.setText( String.valueOf( extent.slice(1).value() ) );
                binsizeTF.setText( String.valueOf( Ops.subtract( dep0.slice(1), dep0.slice(0) ).value() ) );
            }
        }
    }
}
