
package org.das2.qds.filters;

import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;

/**
 * rebundle filter extracts or resorts indeces.
 * @author jbf
 */
public class RebundleFilterEditorPanel extends AbstractFilterEditorPanel implements FilterEditorPanel {

    public final static String PROP_REGEX= "\\|rebundle\\(.+\\)";
    
    /**
     * Creates new form RebundleFilterEditorPanel
     */
    public RebundleFilterEditorPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        bundleNamesLabel = new javax.swing.JLabel();
        rebundleValueTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();

        jLabel1.setText("<html>rebundle takes a list of positional arguments for position within a bundle and creates a new bundle.");
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        bundleNamesLabel.setText("Bundle names:");

        rebundleValueTextField.setText(" ");

        jLabel2.setText("Comma-separated list of names or indices, starting with 0:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                        .addComponent(bundleNamesLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 296, Short.MAX_VALUE)
                        .addComponent(rebundleValueTextField))
                    .addComponent(jLabel2))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(bundleNamesLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(rebundleValueTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel bundleNamesLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField rebundleValueTextField;
    // End of variables declaration//GEN-END:variables

    @Override
    public void setFilter(String filter) {
        rebundleValueTextField.setText(filter);
    }

    @Override
    public String getFilter() {
        return rebundleValueTextField.getText();
    }

    @Override
    public void setInput(QDataSet ds) {
        String[] ss= DataSetOps.bundleNames(ds);
        bundleNamesLabel.setText( "Dataset names: " + String.join(",",ss) );
    }
    
}
