/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.das2.qds.filters;

import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import org.das2.qds.QDataSet;
import static org.das2.qds.filters.FilterEditorPanel.PROP_FILTER;

/**
 * Editor panel to replace the original GUI that was a part of the data panel.
 * @author jbf
 */
public class TotalFilterEditorPanel extends AbstractFilterEditorPanel implements FilterEditorPanel {

    static final long t0= System.currentTimeMillis();
    int[] qube= null;
    
    /**
     * Creates new form SlicesFilterEditorPanel
     */
    public TotalFilterEditorPanel() {
        initComponents();
        setName("sliceFilterEditorPanel" + String.format( "%04d", (System.currentTimeMillis()-t0)/100 ));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        sliceDimensionCB = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();

        sliceDimensionCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        sliceDimensionCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sliceDimensionCBActionPerformed(evt);
            }
        });

        jLabel2.setText("Total over Dimension:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(sliceDimensionCB, 0, 253, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(sliceDimensionCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void sliceDimensionCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sliceDimensionCBActionPerformed
        final String ff= getFilter();
        logger.log(Level.FINEST, "0: {0}{1}", new Object[]{ff, this.getName()});
        firePropertyChange( PROP_FILTER, null, ff );
    }//GEN-LAST:event_sliceDimensionCBActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel2;
    private javax.swing.JComboBox sliceDimensionCB;
    // End of variables declaration//GEN-END:variables

    @Override
    public String getFilter() {
        logger.fine( "getFilter" );
        return String.format( "|total%d()", sliceDimensionCB.getSelectedIndex() );
    }

    @Override
    public void setFilter(String filter) {
        logger.log(Level.FINE, "setFilter {0}", filter);
        Pattern p= Pattern.compile("\\|total(\\d)\\(()\\)");
        Matcher m= p.matcher(filter);
        if ( m.matches() ) {
            sliceDimensionCB.setSelectedIndex( Integer.parseInt(m.group(1)) );
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void setInput(QDataSet ds) {
        logger.log(Level.FINE, "setInput {0}", ds.toString() );
        String[] depNames1= FilterEditorPanelUtil.getDimensionNames(ds);
        int idx= sliceDimensionCB.getSelectedIndex();
        sliceDimensionCB.setModel(new DefaultComboBoxModel<>(depNames1));
        try {
            sliceDimensionCB.setSelectedIndex(idx);
        } catch ( IllegalArgumentException ex ) {
            sliceDimensionCB.setSelectedIndex(0);
        }
    }
    

}
