/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.das2.qds.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

/**
 *
 * @author aluthens
 */
public class TrimFilterEditorPanel extends AbstractFilterEditorPanel {

    public final static String PROP_REGEX= "\\|trim\\(\\s*(?:(\\d+),)?\\s*([^\\s,]+)\\s*\\,\\s*([^\\s,]+)\\s*\\)";
    public final static String PROP_TRIMI_REGEX= "\\|trim(\\d)\\(\\s*(\\S+)\\s*\\,\\s*(\\S+)\\s*\\)";

    private boolean automaticSetting= true;
            
    /**
     * Creates new form TrimTest
     */
    public TrimFilterEditorPanel() {
        initComponents();
    }
    public static void main( String[] args ) {
        FilterEditorPanel filter= new TrimFilterEditorPanel();
        QDataSet ds= Ops.ripplesTimeSeries(1440); //FiltersChainPanel.getExampleDataSet("rank1TimeSeries");
        int dataSize= getDataSetSize(ds);
        filter.setFilter("|trim(0,"+dataSize+")");
        filter.setInput(ds);
        JOptionPane.showMessageDialog( null, filter);
        System.err.println( filter.getFilter() );
    }
    
    private static int getDataSetSize(QDataSet ds){
        int dataSize=ds.length();
        return dataSize;
    }
    
    @Override
    @SuppressWarnings("unchecked")
    public void setInput(QDataSet ds){
        if ( automaticSetting ) { 
            endLabel.setText( String.format( "Up to but not including (%d bins):",ds.length() ) );
        }
        String[] depNames1= FilterEditorPanelUtil.getDimensionNames(ds);
        int index= dimensionCB.getSelectedIndex();
        dimensionCB.setModel(new DefaultComboBoxModel(depNames1));
        dimensionCB.setSelectedIndex(index);
    }
    
    
    @Override
    public void setFilter(String filter) {
        
        Pattern p= Pattern.compile( PROP_REGEX );
        Matcher m= p.matcher(filter);
        Pattern p2= Pattern.compile( PROP_TRIMI_REGEX );
        Matcher m2= p2.matcher(filter);
        
        if ( m.matches() && m.group(1)==null ) {
            lowerBound.setText(m.group(2));
            upperBound.setText( m.group(3) );
            automaticSetting= false;
            dimensionCB.setSelectedIndex(0);
        } else if ( m.matches() && m.group(1)!=null ) {
            lowerBound.setText(m.group(2));
            upperBound.setText( m.group(3) );
            automaticSetting= false;
            dimensionCB.setSelectedIndex(Integer.parseInt(m.group(1)) );
                
        } else if ( (m2.matches() )) {
            lowerBound.setText(m2.group(2));
            upperBound.setText( m2.group(3) );
            automaticSetting= false;
            dimensionCB.setSelectedIndex( Integer.parseInt(m2.group(1)) );
            
        } else {
            //String maxUpperBound=m.group(3);
            lowerBound.setText( "0" );
            upperBound.setText( "10" );
            dimensionCB.setSelectedIndex(0);
            automaticSetting= true;
        }
    }

    //test for subversion commit
    @Override
    public String getFilter() {
        String upperBoundPoint = upperBound.getText().replaceAll("\\s","");
        String lowerBoundPoint = lowerBound.getText().replaceAll("\\s","");
        if ( dimensionCB.getSelectedIndex()==0 ) {
            return "|trim(" + lowerBoundPoint + "," + upperBoundPoint +  ")";
//        } else if ( dimensionCB.getSelectedIndex()==1 ) {
//            return "|trim" + dimensionCB.getSelectedIndex() + "(" + lowerBoundPoint + "," + upperBoundPoint +  ")";
        } else {
            return "|trim(" + dimensionCB.getSelectedIndex() + "," + lowerBoundPoint + "," + upperBoundPoint +  ")";
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        endLabel = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        upperBound = new javax.swing.JTextField();
        lowerBound = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        dimensionCB = new javax.swing.JComboBox();

        endLabel.setText("Up to but not including:");
        endLabel.setToolTipText("Negative indeces are allowed, so -1 refers to the last index.  Blank may be used to include the last index.");

        jLabel3.setText("Trim from (index or Datum):");
        jLabel3.setToolTipText("index of the first element, and negative indices are relative to the end.  A datum may be used as well.");

        upperBound.setText("-1");

        lowerBound.setText("0");

        jLabel1.setText("Trim Dimension:");

        dimensionCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(dimensionCB, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(endLabel)
                            .addComponent(jLabel3))
                        .addGap(14, 14, 14)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lowerBound)
                            .addComponent(upperBound, javax.swing.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(dimensionCB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(lowerBound, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(endLabel)
                    .addComponent(upperBound, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(19, 19, 19))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox dimensionCB;
    private javax.swing.JLabel endLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField lowerBound;
    private javax.swing.JTextField upperBound;
    // End of variables declaration//GEN-END:variables
}
