/*
 * DataSourceEditorDialog.java
 *
 * Created on November 30, 2008, 12:56 PM
 */

package org.autoplot.datasource;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

/**
 * Dialog that contains DataSourceEditorPanels, and actions like:
 * Cancel, Overplot, Plot Below, and Plot.
 * 
 * @author  jbf
 */
public class DataSourceEditorDialog extends javax.swing.JDialog {

    
    /** Creates new form DataSourceEditorDialog */
    public DataSourceEditorDialog( java.awt.Frame parent, Component message, boolean modal ) {
        super(parent, modal);
        initComponents();
        this.jPanel1.add(message,BorderLayout.CENTER);
        setLocationRelativeTo(parent);
        problemsList.setVisible(false);
        this.validate();
        this.setName( message.getName() ); // used for dialog positions
    }

    public DataSourceEditorDialog( java.awt.Dialog parent, Component message, boolean modal ) {
        super(parent, modal);
        initComponents();
        this.jPanel1.add(message,BorderLayout.CENTER);
        setLocationRelativeTo(parent);
        this.validate();
        this.setName( message.getName() ); // used for dialog positions
    }
    
    public void setProblems( List<String> problems ) {
        if ( problems==null || problems.isEmpty() ) {
            problemsList.setVisible(false);
        } else {
            String[] prob= new String[problems.size()+1];
            prob[0]= "Problems indicated...";
            for ( int i=0; i<problems.size(); i++ ) {
                prob[i+1]= "<html><em>&bull;&nbsp;"+problems.get(i);
            }
            problemsList.setModel( new DefaultComboBoxModel(prob));
            problemsList.setVisible(true);
        }
    }

    protected boolean cancelled = true;
    public static final String PROP_CANCELLED = "cancelled";

    public boolean isCancelled() {
        return cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    protected int modifiers = 0;
    public static final String PROP_MODIFIERS = "modifiers";

    public int getModifiers() {
        return modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setExpertMode( boolean expert ) {
        if ( overplotButton.isVisible() ) { // support setPlayButton
            overplotButton.setVisible(expert);
            plotBelowButton.setVisible(expert);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        okayButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        plotBelowButton = new javax.swing.JButton();
        overplotButton = new javax.swing.JButton();
        problemsList = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jPanel1.setLayout(new java.awt.BorderLayout());

        okayButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/go.png"))); // NOI18N
        okayButton.setText("Plot");
        okayButton.setToolTipText("Plot, replacing any previous plot.");
        okayButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okayButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        plotBelowButton.setText("Plot Below");
        plotBelowButton.setToolTipText("Plot below the current plot.  Holding shift will plot above.");
        plotBelowButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                plotBelowButtonMouseMoved(evt);
            }
        });
        plotBelowButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                plotBelowButtonMouseExited(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                plotBelowButtonMouseEntered(evt);
            }
        });
        plotBelowButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotBelowButtonActionPerformed(evt);
            }
        });

        overplotButton.setText("Overplot");
        overplotButton.setToolTipText("Add this to the current plot as an overplot");
        overplotButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overplotButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(cancelButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 94, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(overplotButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotBelowButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(okayButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 83, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(okayButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 29, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(cancelButton)
                .add(plotBelowButton)
                .add(overplotButton))
        );

        problemsList.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(problemsList, 0, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(18, 18, 18)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 850, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 444, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(problemsList, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    org.das2.util.LoggerManager.logGuiEvent(evt);
    this.cancelled= true;
    this.setVisible(false);
}//GEN-LAST:event_cancelButtonActionPerformed

private void okayButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okayButtonActionPerformed
    org.das2.util.LoggerManager.logGuiEvent(evt);
    this.cancelled= false;
    this.setModifiers(evt.getModifiers());
    this.setVisible(false);
}//GEN-LAST:event_okayButtonActionPerformed

private void plotBelowButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotBelowButtonActionPerformed
    org.das2.util.LoggerManager.logGuiEvent(evt);
    this.cancelled= false;
    setModifiers( KeyEvent.CTRL_MASK | evt.getModifiers() );
    this.setVisible(false);
}//GEN-LAST:event_plotBelowButtonActionPerformed

private void overplotButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overplotButtonActionPerformed
    org.das2.util.LoggerManager.logGuiEvent(evt);
    this.cancelled= false;
    setModifiers( KeyEvent.SHIFT_MASK );
    this.setVisible(false);
}//GEN-LAST:event_overplotButtonActionPerformed

    private void plotBelowUpdate( boolean above ) {    
        if ( above ) {
            plotBelowButton.setText("Plot Above");
        } else {
            plotBelowButton.setText("Plot Below");
        }    
    }
    
    private void plotBelowButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotBelowButtonMouseMoved
        plotBelowUpdate( evt.isShiftDown() );
    }//GEN-LAST:event_plotBelowButtonMouseMoved

    private void plotBelowButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotBelowButtonMouseEntered
        plotBelowUpdate( evt.isShiftDown() );
    }//GEN-LAST:event_plotBelowButtonMouseEntered

    private void plotBelowButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_plotBelowButtonMouseExited
        plotBelowUpdate( evt.isShiftDown() );
    }//GEN-LAST:event_plotBelowButtonMouseExited


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton okayButton;
    private javax.swing.JButton overplotButton;
    private javax.swing.JButton plotBelowButton;
    private javax.swing.JComboBox problemsList;
    // End of variables declaration//GEN-END:variables

    /**
     * provide way to hide the play button.
     */
    void setPlayButton(boolean b) {
        if ( b ) {
            okayButton.setIcon(  new javax.swing.ImageIcon(getClass().getResource("/org/autoplot/datasource/go.png") ) );
            okayButton.setText("Plot");
        } else {
            okayButton.setIcon(null);
            okayButton.setText("OK");
        }
        plotBelowButton.setVisible(b);
        overplotButton.setVisible(b);
    }

}
