/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess;

import gov.nasa.arc.pds.xml.generated.Array;
import gov.nasa.arc.pds.xml.generated.Array2DImage;
import gov.nasa.arc.pds.xml.generated.Array3DImage;
import gov.nasa.arc.pds.xml.generated.Array3DSpectrum;
import gov.nasa.arc.pds.xml.generated.ByteStream;
import gov.nasa.arc.pds.xml.generated.FieldBinary;
import gov.nasa.arc.pds.xml.generated.FieldCharacter;
import gov.nasa.arc.pds.xml.generated.FieldDelimited;
import gov.nasa.arc.pds.xml.generated.FileArea;
import gov.nasa.arc.pds.xml.generated.FileAreaAncillary;
import gov.nasa.arc.pds.xml.generated.FileAreaBrowse;
import gov.nasa.arc.pds.xml.generated.FileAreaInventory;
import gov.nasa.arc.pds.xml.generated.FileAreaObservational;
import gov.nasa.arc.pds.xml.generated.FileAreaObservationalSupplemental;
import gov.nasa.arc.pds.xml.generated.FileAreaSIPDeepArchive;
import gov.nasa.arc.pds.xml.generated.FileAreaTransferManifest;
import gov.nasa.arc.pds.xml.generated.GroupFieldDelimited;
import gov.nasa.arc.pds.xml.generated.Header;
import gov.nasa.arc.pds.xml.generated.ProductObservational;
import gov.nasa.arc.pds.xml.generated.TableBinary;
import gov.nasa.arc.pds.xml.generated.TableCharacter;
import gov.nasa.arc.pds.xml.generated.TableDelimited;
import gov.nasa.pds.label.jaxb.XMLLabelContext;
import gov.nasa.pds.objectAccess.ObjectProvider;
import gov.nasa.pds.objectAccess.ParseException;
import gov.nasa.pds.objectAccess.utility.Utility;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectAccess
implements ObjectProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectAccess.class);
    private String archiveRoot;
    private URL root;
    private final XMLInputFactory xif = XMLInputFactory.newInstance();
    private XMLLabelContext labelContext;

    public ObjectAccess() throws MalformedURLException, URISyntaxException {
        this(new File("."));
    }

    public ObjectAccess(String archiveRoot) throws MalformedURLException, URISyntaxException {
        URL url = null;
        try {
            url = new URL(archiveRoot);
        }
        catch (MalformedURLException mu) {
            url = new File(archiveRoot).toURI().toURL();
        }
        this.root = url.toURI().normalize().toURL();
        this.archiveRoot = this.root.toString();
        this.labelContext = new XMLLabelContext();
    }

    public ObjectAccess(File archiveRoot) throws MalformedURLException, URISyntaxException {
        this(archiveRoot.toURI().toURL());
    }

    public ObjectAccess(URL archiveRoot) throws URISyntaxException, MalformedURLException {
        this.root = archiveRoot.toURI().normalize().toURL();
        this.archiveRoot = this.root.toString();
        this.labelContext = new XMLLabelContext();
    }

    private JAXBContext getJAXBContext(String pkgName) throws JAXBException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof WorkaroundClassLoader)) {
            WorkaroundClassLoader loader = new WorkaroundClassLoader(currentLoader != null ? currentLoader : this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
        }
        return JAXBContext.newInstance((String)pkgName);
    }

    @Override
    public <T> T getProduct(File labelFile, Class<T> productClass) throws ParseException {
        try {
            return this.getProduct(labelFile.toURI().toURL(), productClass);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to load the product from the label.", (Throwable)e);
            throw new ParseException("Unable to parse the product label", e);
        }
    }

    @Override
    public <T> T getProduct(URL label, Class<T> productClass) throws ParseException {
        try {
            JAXBContext context = this.getJAXBContext("gov.nasa.arc.pds.xml.generated");
            Unmarshaller u = context.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new LenientEventHandler());
            return productClass.cast(u.unmarshal(Utility.openConnection(label)));
        }
        catch (JAXBException je) {
            LOGGER.error("Failed to load the product from the label.", (Throwable)je);
            throw new ParseException("Unable to parse the product label", je);
        }
        catch (IOException io) {
            LOGGER.error("Failed to load the product from the label.", (Throwable)io);
            throw new ParseException("Unable to parse the product label", io);
        }
        catch (Exception e) {
            throw new ParseException("Error while parsing the product label", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ProductObservational getObservationalProduct(String relativeXmlFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setObservationalProduct(String relativeXmlFilePath, ProductObservational product) throws Exception {
        this.setObservationalProduct(relativeXmlFilePath, product, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setObservationalProduct(String relativeXmlFilePath, ProductObservational product, XMLLabelContext labelContext) throws Exception {
        try {
            JAXBContext context = this.getJAXBContext("gov.nasa.arc.pds.xml.generated");
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            if (labelContext != null) {
                m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)labelContext.getNamespaces());
                m.setProperty("com.sun.xml.bind.xmlHeaders", (Object)labelContext.getXmlModelPIs());
                m.setProperty("jaxb.schemaLocation", (Object)labelContext.getSchemaLocation());
            }
            if ("file".equalsIgnoreCase(this.getRoot().getProtocol())) {
                File parent = FileUtils.toFile((URL)this.getRoot());
                File f = new File(parent, relativeXmlFilePath);
                m.marshal((Object)product, f);
                return;
            }
            OutputStream os = null;
            try {
                URL u = new URL(this.getRoot(), relativeXmlFilePath);
                URLConnection conn = u.openConnection();
                conn.setDoOutput(true);
                os = conn.getOutputStream();
                m.marshal((Object)product, os);
            }
            catch (Exception e) {
                try {
                    LOGGER.error("Failed to set the product observational.", (Throwable)e);
                    e.printStackTrace();
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)os);
            return;
        }
        catch (JAXBException e) {
            LOGGER.error("Failed to set the product observational.", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public List<Array> getArrays(FileArea fileArea) {
        ArrayList<Array> list = new ArrayList<Array>();
        if (fileArea instanceof FileAreaObservational) {
            list.addAll(this.getArrays((FileAreaObservational)fileArea));
        } else if (fileArea instanceof FileAreaBrowse) {
            list.addAll(this.getArrays((FileAreaBrowse)fileArea));
        }
        return list;
    }

    @Override
    public List<Array> getArrays(FileAreaObservational fileArea) {
        ArrayList<Array> list = new ArrayList<Array>();
        for (ByteStream obj : fileArea.getDataObjects()) {
            if (!(obj instanceof Array)) continue;
            list.add((Array)Array.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<Array> getArrays(FileAreaBrowse fileArea) {
        ArrayList<Array> list = new ArrayList<Array>();
        for (ByteStream obj : fileArea.getDataObjects()) {
            if (!(obj instanceof Array)) continue;
            list.add((Array)Array.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<Array2DImage> getArray2DImages(FileAreaObservational observationalFileArea) {
        ArrayList<Array2DImage> list = new ArrayList<Array2DImage>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            if (!obj.getClass().equals(Array2DImage.class)) continue;
            list.add((Array2DImage)Array2DImage.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<Array3DImage> getArray3DImages(FileAreaObservational observationalFileArea) {
        ArrayList<Array3DImage> list = new ArrayList<Array3DImage>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            if (!obj.getClass().equals(Array3DImage.class)) continue;
            list.add((Array3DImage)Array3DImage.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<Array3DSpectrum> getArray3DSpectrums(FileAreaObservational observationalFileArea) {
        ArrayList<Array3DSpectrum> list = new ArrayList<Array3DSpectrum>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            if (!obj.getClass().equals(Array3DSpectrum.class)) continue;
            list.add((Array3DSpectrum)Array3DSpectrum.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<Object> getHeaderObjects(FileAreaAncillary anciilaryFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : anciilaryFileArea.getArraiesAndArray1DsAndArray2Ds()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(Header.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getHeaderObjects(FileAreaObservational observationalFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(Header.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getHeaderObjects(FileAreaBrowse browseFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : browseFileArea.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(Header.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getHeaderObjects(FileArea fileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (fileArea instanceof FileAreaObservational) {
            list.addAll(this.getHeaderObjects((FileAreaObservational)fileArea));
        } else if (fileArea instanceof FileAreaBrowse) {
            list.addAll(this.getHeaderObjects((FileAreaBrowse)fileArea));
        } else if (fileArea instanceof FileAreaAncillary) {
            list.addAll(this.getHeaderObjects((FileAreaAncillary)fileArea));
        }
        return list;
    }

    @Override
    public List<Object> getTableObjects(FileAreaObservational observationalFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(TableCharacter.class) && !clazz.equals(TableBinary.class) && !clazz.equals(TableDelimited.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getTableObjects(FileAreaBrowse browseFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : browseFileArea.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(TableCharacter.class) && !clazz.equals(TableBinary.class) && !clazz.equals(TableDelimited.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getTableObjects(FileAreaAncillary anciilaryFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : anciilaryFileArea.getArraiesAndArray1DsAndArray2Ds()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(TableCharacter.class) && !clazz.equals(TableBinary.class) && !clazz.equals(TableDelimited.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getTableObjects(FileAreaObservationalSupplemental observationalFileAreaSupplemental) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : observationalFileAreaSupplemental.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(TableCharacter.class) && !clazz.equals(TableBinary.class) && !clazz.equals(TableDelimited.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getTableObjects(FileArea fileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (fileArea instanceof FileAreaObservational) {
            list.addAll(this.getTableObjects((FileAreaObservational)fileArea));
        } else if (fileArea instanceof FileAreaInventory) {
            list.add(((FileAreaInventory)fileArea).getInventory());
        } else if (fileArea instanceof FileAreaSIPDeepArchive) {
            list.add(((FileAreaSIPDeepArchive)fileArea).getManifestSIPDeepArchive());
        } else if (fileArea instanceof FileAreaTransferManifest) {
            list.add(((FileAreaTransferManifest)fileArea).getTransferManifest());
        } else if (fileArea instanceof FileAreaBrowse) {
            list.addAll(this.getTableObjects((FileAreaBrowse)fileArea));
        } else if (fileArea instanceof FileAreaAncillary) {
            list.addAll(this.getTableObjects((FileAreaAncillary)fileArea));
        } else if (fileArea instanceof FileAreaObservationalSupplemental) {
            list.add(this.getTableObjects((FileAreaObservationalSupplemental)fileArea));
        }
        return list;
    }

    @Override
    public List<Object> getTablesAndImages(FileArea fileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (fileArea instanceof FileAreaObservational) {
            list.addAll(this.getTablesAndImages((FileAreaObservational)fileArea));
        } else if (fileArea instanceof FileAreaInventory) {
            list.add(((FileAreaInventory)fileArea).getInventory());
        } else if (fileArea instanceof FileAreaSIPDeepArchive) {
            list.add(((FileAreaSIPDeepArchive)fileArea).getManifestSIPDeepArchive());
        } else if (fileArea instanceof FileAreaTransferManifest) {
            list.add(((FileAreaTransferManifest)fileArea).getTransferManifest());
        } else if (fileArea instanceof FileAreaBrowse) {
            list.addAll(this.getTablesAndImages((FileAreaBrowse)fileArea));
        } else if (fileArea instanceof FileAreaAncillary) {
            list.addAll(this.getTableObjects((FileAreaAncillary)fileArea));
        }
        return list;
    }

    @Override
    public List<Object> getTablesAndImages(FileAreaObservational observationalFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(Array3DSpectrum.class) && !clazz.equals(Array2DImage.class) && !clazz.equals(Array3DImage.class) && !clazz.equals(TableCharacter.class) && !clazz.equals(TableBinary.class) && !clazz.equals(TableDelimited.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getTablesAndImages(FileAreaBrowse browseFileArea) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ByteStream obj : browseFileArea.getDataObjects()) {
            Class<?> clazz = obj.getClass();
            if (!clazz.equals(Array3DSpectrum.class) && !clazz.equals(Array2DImage.class) && !clazz.equals(Array3DImage.class) && !clazz.equals(TableCharacter.class) && !clazz.equals(TableBinary.class) && !clazz.equals(TableDelimited.class)) continue;
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<TableCharacter> getTableCharacters(FileAreaObservational observationalFileArea) {
        ArrayList<TableCharacter> list = new ArrayList<TableCharacter>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            if (!obj.getClass().equals(TableCharacter.class)) continue;
            list.add((TableCharacter)TableCharacter.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<TableBinary> getTableBinaries(FileAreaObservational observationalFileArea) {
        ArrayList<TableBinary> list = new ArrayList<TableBinary>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            if (!obj.getClass().equals(TableBinary.class)) continue;
            list.add((TableBinary)TableBinary.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<TableDelimited> getTableDelimiteds(FileAreaObservational observationalFileArea) {
        ArrayList<TableDelimited> list = new ArrayList<TableDelimited>();
        for (ByteStream obj : observationalFileArea.getDataObjects()) {
            if (!obj.getClass().equals(TableDelimited.class)) continue;
            list.add((TableDelimited)TableDelimited.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<FieldCharacter> getFieldCharacters(TableCharacter table) {
        ArrayList<FieldCharacter> list = new ArrayList<FieldCharacter>();
        for (Object obj : table.getRecordCharacter().getFieldCharactersAndGroupFieldCharacters()) {
            if (!obj.getClass().equals(FieldCharacter.class)) continue;
            list.add((FieldCharacter)FieldCharacter.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<FieldDelimited> getFieldDelimiteds(TableDelimited table) {
        ArrayList<FieldDelimited> list = new ArrayList<FieldDelimited>();
        for (Object obj : table.getRecordDelimited().getFieldDelimitedsAndGroupFieldDelimiteds()) {
            if (!obj.getClass().equals(FieldDelimited.class)) continue;
            list.add((FieldDelimited)FieldDelimited.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<GroupFieldDelimited> getGroupFieldDelimiteds(TableDelimited table) {
        ArrayList<GroupFieldDelimited> list = new ArrayList<GroupFieldDelimited>();
        for (Object obj : table.getRecordDelimited().getFieldDelimitedsAndGroupFieldDelimiteds()) {
            if (!obj.getClass().equals(GroupFieldDelimited.class)) continue;
            list.add((GroupFieldDelimited)GroupFieldDelimited.class.cast(obj));
        }
        return list;
    }

    @Override
    public List<Object> getFieldDelimitedAndGroupFieldDelimiteds(TableDelimited table) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : table.getRecordDelimited().getFieldDelimitedsAndGroupFieldDelimiteds()) {
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getFieldCharacterAndGroupFieldCharacters(TableCharacter table) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : table.getRecordCharacter().getFieldCharactersAndGroupFieldCharacters()) {
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<Object> getFieldBinaryAndGroupFieldBinaries(TableBinary table) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : table.getRecordBinary().getFieldBinariesAndGroupFieldBinaries()) {
            list.add(obj);
        }
        return list;
    }

    @Override
    public List<FieldBinary> getFieldBinaries(TableBinary table) {
        ArrayList<FieldBinary> list = new ArrayList<FieldBinary>();
        for (Object obj : table.getRecordBinary().getFieldBinariesAndGroupFieldBinaries()) {
            if (!obj.getClass().equals(FieldBinary.class)) continue;
            list.add((FieldBinary)FieldBinary.class.cast(obj));
        }
        return list;
    }

    static boolean isConvertibleImage(String child) {
        return child.endsWith("raw");
    }

    @Override
    public String getArchiveRoot() {
        return this.archiveRoot;
    }

    @Override
    public URL getRoot() {
        return this.root;
    }

    public XMLLabelContext getXMLLabelContext() {
        return this.labelContext;
    }

    private static class EmptyEnumeration<T>
    implements Enumeration<T> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public T nextElement() throws NoSuchElementException {
            throw new NoSuchElementException();
        }
    }

    private static class WorkaroundClassLoader
    extends ClassLoader {
        private static final String IGNORED_RESOURCE = "META-INF/services/javax.xml.parsers.DocumentBuilderFactory";

        public WorkaroundClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (!name.equals(IGNORED_RESOURCE)) {
                return super.findResources(name);
            }
            return new EmptyEnumeration<URL>();
        }

        @Override
        protected URL findResource(String name) {
            if (!name.equals(IGNORED_RESOURCE)) {
                return super.findResource(name);
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            if (!name.equals(IGNORED_RESOURCE)) {
                return super.getResource(name);
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (!name.equals(IGNORED_RESOURCE)) {
                return super.getResources(name);
            }
            return new EmptyEnumeration<URL>();
        }
    }

    private static class LenientEventHandler
    implements ValidationEventHandler {
        private LenientEventHandler() {
        }

        public boolean handleEvent(ValidationEvent event) {
            if (event.getSeverity() == 2) {
                System.err.println("Fatal error: " + event.getLocator().toString() + ": " + event.getMessage());
                return false;
            }
            return true;
        }
    }
}

