/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.pds.objectAccess.array;

import gov.nasa.pds.objectAccess.array.DataTypeAdapter;
import gov.nasa.pds.objectAccess.array.DoubleAdapter;
import gov.nasa.pds.objectAccess.array.FloatAdapter;
import gov.nasa.pds.objectAccess.array.IntegerAdapter;
import java.util.HashMap;
import java.util.Map;

public class ElementType {
    private static final Map<String, ElementType> TYPES = new HashMap<String, ElementType>();
    private int size;
    private DataTypeAdapter adapter;

    public static ElementType getTypeForName(String typeName) {
        return TYPES.get(typeName);
    }

    private ElementType(int size, DataTypeAdapter adapter) {
        this.size = size;
        this.adapter = adapter;
    }

    public int getSize() {
        return this.size;
    }

    public DataTypeAdapter getAdapter() {
        return this.adapter;
    }

    static {
        TYPES.put("IEEE754LSBDouble", new ElementType(8, new DoubleAdapter(false)));
        TYPES.put("IEEE754MSBDouble", new ElementType(8, new DoubleAdapter(true)));
        TYPES.put("IEEE754LSBSingle", new ElementType(4, new FloatAdapter(false)));
        TYPES.put("IEEE754MSBSingle", new ElementType(4, new FloatAdapter(true)));
        TYPES.put("SignedByte", new ElementType(1, new IntegerAdapter(1, false, false)));
        TYPES.put("SignedLSB2", new ElementType(2, new IntegerAdapter(2, false, false)));
        TYPES.put("SignedLSB4", new ElementType(4, new IntegerAdapter(4, false, false)));
        TYPES.put("SignedLSB8", new ElementType(8, new IntegerAdapter(8, false, false)));
        TYPES.put("SignedMSB2", new ElementType(2, new IntegerAdapter(2, true, false)));
        TYPES.put("SignedMSB4", new ElementType(4, new IntegerAdapter(4, true, false)));
        TYPES.put("SignedMSB8", new ElementType(8, new IntegerAdapter(8, true, false)));
        TYPES.put("UnsignedByte", new ElementType(1, new IntegerAdapter(1, false, true)));
        TYPES.put("UnsignedLSB2", new ElementType(2, new IntegerAdapter(2, false, true)));
        TYPES.put("UnsignedLSB4", new ElementType(4, new IntegerAdapter(4, false, true)));
        TYPES.put("UnsignedLSB8", new ElementType(8, new IntegerAdapter(8, false, true)));
        TYPES.put("UnsignedMSB2", new ElementType(2, new IntegerAdapter(2, true, true)));
        TYPES.put("UnsignedMSB4", new ElementType(4, new IntegerAdapter(4, true, true)));
        TYPES.put("UnsignedMSB8", new ElementType(8, new IntegerAdapter(8, true, true)));
    }
}

