/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MultiSelListDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JListOperator
extends JComponentOperator
implements Outputable {
    public static final String ITEM_PREFIX_DPROP = "Item";
    public static final String SELECTED_ITEM_PREFIX_DPROP = "SelectedItem";
    private TestOut output;
    private MultiSelListDriver driver = DriverManager.getMultiSelListDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JList;

    public JListOperator(JList b) {
        super(b);
    }

    public JListOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JList)cont.waitSubComponent(new JListFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JListOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JListOperator(ContainerOperator cont, String text, int itemIndex, int index) {
        this((JList)JListOperator.waitComponent(cont, (ComponentChooser)new JListByItemFinder(text, itemIndex, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JListOperator(ContainerOperator cont, String text, int index) {
        this(cont, text, -1, index);
    }

    public JListOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JListOperator(ContainerOperator cont, int index) {
        this((JList)JListOperator.waitComponent(cont, (ComponentChooser)new JListFinder(), index));
        this.copyEnvironment(cont);
    }

    public JListOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JList findJList(Container cont, ComponentChooser chooser, int index) {
        return (JList)JListOperator.findComponent(cont, new JListFinder(chooser), index);
    }

    public static JList findJList(Container cont, ComponentChooser chooser) {
        return JListOperator.findJList(cont, chooser, 0);
    }

    public static JList findJList(Container cont, String text, boolean ce, boolean ccs, int itemIndex, int index) {
        return JListOperator.findJList(cont, new JListByItemFinder(text, itemIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JList findJList(Container cont, String text, boolean ce, boolean ccs, int itemIndex) {
        return JListOperator.findJList(cont, text, ce, ccs, itemIndex, 0);
    }

    public static JList waitJList(Container cont, ComponentChooser chooser, int index) {
        return (JList)JListOperator.waitComponent(cont, (ComponentChooser)new JListFinder(chooser), index);
    }

    public static JList waitJList(Container cont, ComponentChooser chooser) {
        return JListOperator.waitJList(cont, chooser, 0);
    }

    public static JList waitJList(Container cont, String text, boolean ce, boolean ccs, int itemIndex, int index) {
        return JListOperator.waitJList(cont, new JListByItemFinder(text, itemIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JList waitJList(Container cont, String text, boolean ce, boolean ccs, int itemIndex) {
        return JListOperator.waitJList(cont, text, ce, ccs, itemIndex, 0);
    }

    public void setOutput(TestOut output) {
        super.setOutput(output.createErrorOutput());
        this.output = output;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (MultiSelListDriver)DriverManager.getDriver("drivers.multisellist", this.getClass(), anotherOperator.getProperties());
    }

    public Point getClickPoint(int itemIndex) {
        Rectangle rect = this.getCellBounds(itemIndex, itemIndex);
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    public Component getRenderedComponent(int itemIndex, boolean isSelected, boolean cellHasFocus) {
        return this.getCellRenderer().getListCellRendererComponent((JList)this.getSource(), this.getModel().getElementAt(itemIndex), itemIndex, isSelected, cellHasFocus);
    }

    public Component getRenderedComponent(int itemIndex) {
        return this.getRenderedComponent(itemIndex, this.isSelectedIndex(itemIndex), false);
    }

    public int findItemIndex(ListItemChooser chooser, int index) {
        ListModel model = this.getModel();
        int count = 0;
        for (int i = 0; i < model.getSize(); ++i) {
            if (!chooser.checkItem(this, i)) continue;
            if (count == index) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    public int findItemIndex(ListItemChooser chooser) {
        return this.findItemIndex(chooser, 0);
    }

    public int findItemIndex(String item, Operator.StringComparator comparator, int index) {
        return this.findItemIndex(new BySubStringListItemChooser(item, comparator), index);
    }

    public int findItemIndex(String item, boolean ce, boolean cc, int index) {
        return this.findItemIndex(item, new Operator.DefaultStringComparator(ce, cc), index);
    }

    public int findItemIndex(String item, int index) {
        return this.findItemIndex(item, this.getComparator(), index);
    }

    public int findItemIndex(String item, Operator.StringComparator comparator) {
        return this.findItemIndex(item, comparator, 0);
    }

    public int findItemIndex(String item, boolean ce, boolean cc) {
        return this.findItemIndex(item, ce, cc, 0);
    }

    public int findItemIndex(String item) {
        return this.findItemIndex(item, 0);
    }

    public int findItemIndex(ComponentChooser chooser, int index) {
        return this.findItemIndex(new ByRenderedComponentListItemChooser(chooser), index);
    }

    public int findItemIndex(ComponentChooser chooser) {
        return this.findItemIndex(chooser, 0);
    }

    public Object clickOnItem(final int itemIndex, final int clickCount) {
        this.output.printLine("Click " + Integer.toString(clickCount) + " times on JList\n    : " + this.toStringSource());
        this.output.printGolden("Click " + Integer.toString(clickCount) + " times on JList");
        this.checkIndex(itemIndex);
        try {
            this.scrollToItem(itemIndex);
        }
        catch (TimeoutExpiredException e) {
            this.output.printStackTrace(e);
        }
        if (((JList)this.getSource()).getModel().getSize() <= itemIndex) {
            this.output.printErrLine("JList " + this.toStringSource() + " does not contain " + Integer.toString(itemIndex) + "'th item");
            return null;
        }
        if (((JList)this.getSource()).getAutoscrolls()) {
            ((JList)this.getSource()).ensureIndexIsVisible(itemIndex);
        }
        return this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                Rectangle rect = JListOperator.this.getCellBounds(itemIndex, itemIndex);
                if (rect == null) {
                    JListOperator.this.output.printErrLine("Impossible to determine click point for " + Integer.toString(itemIndex) + "'th item");
                    return null;
                }
                Point point = new Point((int)(rect.getX() + rect.getWidth() / 2.0), (int)(rect.getY() + rect.getHeight() / 2.0));
                Object result = JListOperator.this.getModel().getElementAt(itemIndex);
                JListOperator.this.clickMouse(point.x, point.y, clickCount);
                return result;
            }
        });
    }

    public Object clickOnItem(final String item, final Operator.StringComparator comparator, final int clickCount) {
        this.scrollToItem(this.findItemIndex(item, comparator, 0));
        return this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                int index = JListOperator.this.findItemIndex(item, comparator, 0);
                if (index != -1) {
                    return JListOperator.this.clickOnItem(index, clickCount);
                }
                throw new NoSuchItemException(item);
            }
        });
    }

    public Object clickOnItem(String item, boolean ce, boolean cc, int clickCount) {
        return this.clickOnItem(item, new Operator.DefaultStringComparator(ce, cc), clickCount);
    }

    public Object clickOnItem(String item, int clickCount) {
        return this.clickOnItem(item, this.getComparator(), clickCount);
    }

    public Object clickOnItem(String item, Operator.StringComparator comparator) {
        return this.clickOnItem(item, comparator, 1);
    }

    public Object clickOnItem(String item, boolean ce, boolean cc) {
        return this.clickOnItem(item, ce, cc, 1);
    }

    public Object clickOnItem(String item) {
        return this.clickOnItem(item, 0);
    }

    public void scrollToItem(int itemIndex) {
        this.output.printTrace("Scroll JList to " + Integer.toString(itemIndex) + "'th item\n    : " + this.toStringSource());
        this.output.printGolden("Scroll JList to " + Integer.toString(itemIndex) + "'th item");
        this.checkIndex(itemIndex);
        this.makeComponentVisible();
        JScrollPane scroll = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
        if (scroll == null) {
            return;
        }
        JScrollPaneOperator scroller = new JScrollPaneOperator(scroll);
        scroller.copyEnvironment(this);
        scroller.setVisualizer(new EmptyVisualizer());
        Rectangle rect = this.getCellBounds(itemIndex, itemIndex);
        scroller.scrollToComponentRectangle(this.getSource(), (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public void scrollToItem(String item, Operator.StringComparator comparator) {
        this.scrollToItem(this.findItemIndex(item, comparator));
    }

    public void scrollToItem(String item, boolean ce, boolean cc) {
        this.scrollToItem(this.findItemIndex(item, ce, cc));
    }

    public void selectItem(int index) {
        this.checkIndex(index);
        this.driver.selectItem(this, index);
        if (this.getVerification()) {
            this.waitItemSelection(index, true);
        }
    }

    public void selectItem(final String item) {
        this.scrollToItem(this.findItemIndex(item));
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                JListOperator.this.driver.selectItem(JListOperator.this, JListOperator.this.findItemIndex(item));
                return null;
            }
        });
    }

    public void selectItems(int[] indices) {
        this.checkIndices(indices);
        this.driver.selectItems(this, indices);
        if (this.getVerification()) {
            this.waitItemsSelection(indices, true);
        }
    }

    public void selectItem(String[] items) {
        int[] indices = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            indices[i] = this.findItemIndex(items[i]);
        }
        this.selectItems(indices);
    }

    public void waitItemsSelection(final int[] itemIndices, final boolean selected) {
        this.getOutput().printLine("Wait items to be " + (selected ? "" : "un") + "selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait items to be " + (selected ? "" : "un") + "selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                int[] indices = JListOperator.this.getSelectedIndices();
                for (int i = 0; i < indices.length; ++i) {
                    if (indices[i] == itemIndices[i]) continue;
                    return false;
                }
                return true;
            }

            public String getDescription() {
                return "Item has been " + (selected ? "" : "un") + "selected";
            }
        });
    }

    public void waitItemSelection(int itemIndex, boolean selected) {
        this.waitItemsSelection(new int[]{itemIndex}, selected);
    }

    public void waitItem(String item, int itemIndex) {
        this.getOutput().printLine("Wait \"" + item + "\" at the " + Integer.toString(itemIndex) + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + item + "\" at the " + Integer.toString(itemIndex) + " position");
        this.waitState(new JListByItemFinder(item, itemIndex, this.getComparator()));
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        Object[] items = new String[((JList)this.getSource()).getModel().getSize()];
        for (int i = 0; i < ((JList)this.getSource()).getModel().getSize(); ++i) {
            items[i] = ((JList)this.getSource()).getModel().getElementAt(i).toString();
        }
        int[] selectedIndices = ((JList)this.getSource()).getSelectedIndices();
        Object[] selectedItems = new String[selectedIndices.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            selectedItems[i] = items[selectedIndices[i]];
        }
        this.addToDump(result, ITEM_PREFIX_DPROP, items);
        this.addToDump(result, SELECTED_ITEM_PREFIX_DPROP, selectedItems);
        return result;
    }

    public void addListSelectionListener(final ListSelectionListener listSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("addListSelectionListener"){

            public void map() {
                ((JList)JListOperator.this.getSource()).addListSelectionListener(listSelectionListener);
            }
        });
    }

    public void addSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("addSelectionInterval"){

            public void map() {
                ((JList)JListOperator.this.getSource()).addSelectionInterval(i, i1);
            }
        });
    }

    public void clearSelection() {
        this.runMapping(new Operator.MapVoidAction("clearSelection"){

            public void map() {
                ((JList)JListOperator.this.getSource()).clearSelection();
            }
        });
    }

    public void ensureIndexIsVisible(final int i) {
        this.runMapping(new Operator.MapVoidAction("ensureIndexIsVisible"){

            public void map() {
                ((JList)JListOperator.this.getSource()).ensureIndexIsVisible(i);
            }
        });
    }

    public int getAnchorSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getAnchorSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getAnchorSelectionIndex();
            }
        });
    }

    public Rectangle getCellBounds(final int i, final int i1) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getCellBounds"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getCellBounds(i, i1);
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return (ListCellRenderer)this.runMapping(new Operator.MapAction("getCellRenderer"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getCellRenderer();
            }
        });
    }

    public int getFirstVisibleIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getFirstVisibleIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getFirstVisibleIndex();
            }
        });
    }

    public int getFixedCellHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getFixedCellHeight"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getFixedCellHeight();
            }
        });
    }

    public int getFixedCellWidth() {
        return this.runMapping(new Operator.MapIntegerAction("getFixedCellWidth"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getFixedCellWidth();
            }
        });
    }

    public int getLastVisibleIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getLastVisibleIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getLastVisibleIndex();
            }
        });
    }

    public int getLeadSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getLeadSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getLeadSelectionIndex();
            }
        });
    }

    public int getMaxSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getMaxSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getMaxSelectionIndex();
            }
        });
    }

    public int getMinSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getMinSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getMinSelectionIndex();
            }
        });
    }

    public ListModel getModel() {
        return (ListModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getModel();
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public Object getPrototypeCellValue() {
        return this.runMapping(new Operator.MapAction("getPrototypeCellValue"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getPrototypeCellValue();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getScrollableBlockIncrement(rectangle, i, i1);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getScrollableUnitIncrement(rectangle, i, i1);
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public int[] getSelectedIndices() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedIndices"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectedIndices();
            }
        });
    }

    public Object getSelectedValue() {
        return this.runMapping(new Operator.MapAction("getSelectedValue"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectedValue();
            }
        });
    }

    public Object[] getSelectedValues() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedValues"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectedValues();
            }
        });
    }

    public Color getSelectionBackground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionBackground"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectionBackground();
            }
        });
    }

    public Color getSelectionForeground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionForeground"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectionForeground();
            }
        });
    }

    public int getSelectionMode() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionMode"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getSelectionMode();
            }
        });
    }

    public ListSelectionModel getSelectionModel() {
        return (ListSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public ListUI getUI() {
        return (ListUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean getValueIsAdjusting() {
        return this.runMapping(new Operator.MapBooleanAction("getValueIsAdjusting"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).getValueIsAdjusting();
            }
        });
    }

    public int getVisibleRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleRowCount"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getVisibleRowCount();
            }
        });
    }

    public Point indexToLocation(final int i) {
        return (Point)this.runMapping(new Operator.MapAction("indexToLocation"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).indexToLocation(i);
            }
        });
    }

    public boolean isSelectedIndex(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isSelectedIndex"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).isSelectedIndex(i);
            }
        });
    }

    public boolean isSelectionEmpty() {
        return this.runMapping(new Operator.MapBooleanAction("isSelectionEmpty"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).isSelectionEmpty();
            }
        });
    }

    public int locationToIndex(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("locationToIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).locationToIndex(point);
            }
        });
    }

    public void removeListSelectionListener(final ListSelectionListener listSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("removeListSelectionListener"){

            public void map() {
                ((JList)JListOperator.this.getSource()).removeListSelectionListener(listSelectionListener);
            }
        });
    }

    public void removeSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionInterval"){

            public void map() {
                ((JList)JListOperator.this.getSource()).removeSelectionInterval(i, i1);
            }
        });
    }

    public void setCellRenderer(final ListCellRenderer listCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setCellRenderer"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setCellRenderer(listCellRenderer);
            }
        });
    }

    public void setFixedCellHeight(final int i) {
        this.runMapping(new Operator.MapVoidAction("setFixedCellHeight"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setFixedCellHeight(i);
            }
        });
    }

    public void setFixedCellWidth(final int i) {
        this.runMapping(new Operator.MapVoidAction("setFixedCellWidth"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setFixedCellWidth(i);
            }
        });
    }

    public void setListData(final Vector vector) {
        this.runMapping(new Operator.MapVoidAction("setListData"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setListData(vector);
            }
        });
    }

    public void setListData(final Object[] object) {
        this.runMapping(new Operator.MapVoidAction("setListData"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setListData(object);
            }
        });
    }

    public void setModel(final ListModel listModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setModel(listModel);
            }
        });
    }

    public void setPrototypeCellValue(final Object object) {
        this.runMapping(new Operator.MapVoidAction("setPrototypeCellValue"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setPrototypeCellValue(object);
            }
        });
    }

    public void setSelectedIndex(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndex"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectedIndex(i);
            }
        });
    }

    public void setSelectedIndices(final int[] i) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndices"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectedIndices(i);
            }
        });
    }

    public void setSelectedValue(final Object object, final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setSelectedValue"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectedValue(object, b);
            }
        });
    }

    public void setSelectionBackground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionBackground"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionBackground(color);
            }
        });
    }

    public void setSelectionForeground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionForeground"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionForeground(color);
            }
        });
    }

    public void setSelectionInterval(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setSelectionInterval"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionInterval(i, i1);
            }
        });
    }

    public void setSelectionMode(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionMode"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionMode(i);
            }
        });
    }

    public void setSelectionModel(final ListSelectionModel listSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionModel(listSelectionModel);
            }
        });
    }

    public void setUI(final ListUI listUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setUI(listUI);
            }
        });
    }

    public void setValueIsAdjusting(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setValueIsAdjusting"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setValueIsAdjusting(b);
            }
        });
    }

    public void setVisibleRowCount(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVisibleRowCount"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setVisibleRowCount(i);
            }
        });
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getModel().getSize()) {
            throw new NoSuchItemException(index);
        }
    }

    private void checkIndices(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            this.checkIndex(indices[i]);
        }
    }

    public static class JListFinder
    extends Operator.Finder {
        public JListFinder(ComponentChooser sf) {
            super(class$javax$swing$JList == null ? (class$javax$swing$JList = JListOperator.class$("javax.swing.JList")) : class$javax$swing$JList, sf);
        }

        public JListFinder() {
            super(class$javax$swing$JList == null ? (class$javax$swing$JList = JListOperator.class$("javax.swing.JList")) : class$javax$swing$JList);
        }
    }

    public static class JListByItemFinder
    implements ComponentChooser {
        String label;
        int itemIndex;
        Operator.StringComparator comparator;

        public JListByItemFinder(String lb, int ii, Operator.StringComparator comparator) {
            this.label = lb;
            this.itemIndex = ii;
            this.comparator = comparator;
        }

        public JListByItemFinder(String lb, int ii) {
            this(lb, ii, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof JList) {
                if (this.label == null) {
                    return true;
                }
                if (((JList)comp).getModel().getSize() > this.itemIndex) {
                    int ii = this.itemIndex;
                    if (ii == -1 && (ii = ((JList)comp).getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(((JList)comp).getModel().getElementAt(ii).toString(), this.label);
                }
            }
            return false;
        }

        public String getDescription() {
            return "JList with text \"" + this.label + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }

    private class ByRenderedComponentListItemChooser
    implements ListItemChooser {
        ComponentChooser chooser;

        public ByRenderedComponentListItemChooser(ComponentChooser chooser) {
            this.chooser = chooser;
        }

        public boolean checkItem(JListOperator oper, int index) {
            return this.chooser.checkComponent(oper.getRenderedComponent(index));
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    private class BySubStringListItemChooser
    implements ListItemChooser {
        String subString;
        Operator.StringComparator comparator;

        public BySubStringListItemChooser(String subString, Operator.StringComparator comparator) {
            this.subString = subString;
            this.comparator = comparator;
        }

        public boolean checkItem(JListOperator oper, int index) {
            return this.comparator.equals(oper.getModel().getElementAt(index).toString(), this.subString);
        }

        public String getDescription() {
            return "Item containing \"" + this.subString + "\" string";
        }
    }

    public class NoSuchItemException
    extends JemmyInputException {
        public NoSuchItemException(String item) {
            super("No such item as \"" + item + "\"", JListOperator.this.getSource());
        }

        public NoSuchItemException(int index) {
            super("List does not contain " + index + "'th item", JListOperator.this.getSource());
        }
    }

    public static interface ListItemChooser {
        public boolean checkItem(JListOperator var1, int var2);

        public String getDescription();
    }
}

