/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import org.eso.fits.FitsException;
import org.eso.fits.FitsHDUnit;

public class FitsFile {
    private File file;
    private RandomAccessFile raFile;
    private Vector hdUnits = new Vector(1);
    private boolean changeHDU = false;

    public FitsFile() {
    }

    public FitsFile(DataInput dataInput) throws FitsException {
        this();
        this.scanFitsFile(dataInput, false);
    }

    public FitsFile(DataInput dataInput, boolean bl) throws FitsException {
        this();
        this.scanFitsFile(dataInput, bl);
    }

    public FitsFile(File file) throws IOException, FitsException {
        this();
        this.raFile = new RandomAccessFile(file, "r");
        this.file = file;
        this.scanFitsFile(this.raFile, false);
    }

    public FitsFile(String string) throws IOException, FitsException {
        this(new File(string));
    }

    private void scanFitsFile(DataInput dataInput, boolean bl) throws FitsException {
        int n = 0;
        try {
            while (true) {
                FitsHDUnit fitsHDUnit = new FitsHDUnit(dataInput, bl);
                this.hdUnits.setSize(n++);
                this.hdUnits.addElement(fitsHDUnit);
            }
        }
        catch (FitsException fitsException) {
            if (n < 1) {
                throw new FitsException("No a FITS file", 1);
            }
            this.hdUnits.trimToSize();
            return;
        }
    }

    protected void finalize() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
        }
        this.file = null;
    }

    public static boolean isFitsFile(File file) {
        Object object;
        int n = 0;
        byte[] byArray = new byte[80];
        try {
            object = new RandomAccessFile(file, "r");
            n = ((RandomAccessFile)object).read(byArray);
            ((RandomAccessFile)object).close();
        }
        catch (IOException iOException) {
            return false;
        }
        if (n < 80) {
            return false;
        }
        object = new String(byArray);
        return ((String)object).startsWith("SIMPLE  = ");
    }

    public static boolean isFitsFile(String string) {
        return FitsFile.isFitsFile(new File(string));
    }

    public void addHDUnit(FitsHDUnit fitsHDUnit) {
        this.hdUnits.addElement(fitsHDUnit);
        this.changeHDU = true;
    }

    public void insertHDUnitAt(FitsHDUnit fitsHDUnit, int n) {
        this.hdUnits.insertElementAt(fitsHDUnit, n);
        this.changeHDU = true;
    }

    public void removeHDUnitAt(int n) {
        this.hdUnits.removeElementAt(n);
        this.changeHDU = true;
    }

    public final FitsHDUnit getHDUnit(int n) {
        int n2 = 0;
        if (n < 0) {
            return (FitsHDUnit)this.hdUnits.firstElement();
        }
        if (n >= this.hdUnits.size()) {
            return (FitsHDUnit)this.hdUnits.lastElement();
        }
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            FitsHDUnit fitsHDUnit = (FitsHDUnit)enumeration.nextElement();
            if (n2 == n) {
                return fitsHDUnit;
            }
            ++n2;
        }
        return (FitsHDUnit)this.hdUnits.lastElement();
    }

    public void saveFile() throws IOException, FitsException {
        if (this.changeHDU) {
            throw new FitsException("HD Units of file have been changes", 1);
        }
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            if (((FitsHDUnit)enumeration.nextElement()).canSave()) continue;
            throw new FitsException("No space in FITS header", 6);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
        enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            ((FitsHDUnit)enumeration.nextElement()).saveFile(randomAccessFile);
        }
        randomAccessFile.close();
    }

    public void writeFile(DataOutput dataOutput) throws IOException, FitsException {
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            ((FitsHDUnit)enumeration.nextElement()).writeFile(dataOutput);
        }
    }

    public void writeFile(File file) throws IOException, FitsException {
        if (file == null) {
            throw new FitsException("Cannot write to null-pointer file", 1);
        }
        if (file.exists()) {
            if (!file.isFile()) {
                throw new FitsException("Cannot overwrite special file", 1);
            }
            if (this.file != null && this.file.getCanonicalPath().equals(file.getCanonicalPath())) {
                throw new FitsException("Cannot overwrite itself", 1);
            }
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.writeFile(randomAccessFile);
        randomAccessFile.close();
    }

    public void writeFile(String string) throws IOException, FitsException {
        this.writeFile(new File(string));
    }

    public void closeFile() {
        Enumeration enumeration = this.hdUnits.elements();
        while (enumeration.hasMoreElements()) {
            ((FitsHDUnit)enumeration.nextElement()).closeFile();
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.file = null;
    }

    public final int getNoHDUnits() {
        return this.hdUnits.size();
    }

    public String getName() {
        String string = "";
        if (this.file != null) {
            try {
                string = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = this.file.getAbsolutePath();
            }
        }
        return string;
    }

    public File getFile() {
        return this.file;
    }
}

